/*
 * Decompiled with CFR 0.152.
 */
package kafka.message;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import kafka.message.ByteBufferBackedInputStream;
import kafka.message.ByteBufferMessageSet;
import kafka.message.CompressionCodec;
import kafka.message.CompressionFactory$;
import kafka.message.Message;
import kafka.message.MessageSet$;
import kafka.message.NoCompressionCodec$;
import scala.Function0;
import scala.Function1;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.package$;
import scala.runtime.LongRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ByteBufferMessageSet$
implements ScalaObject {
    public static final ByteBufferMessageSet$ MODULE$;

    static {
        new ByteBufferMessageSet$();
    }

    public final ByteBuffer kafka$message$ByteBufferMessageSet$$create(AtomicLong offsetCounter$1, CompressionCodec compressionCodec, Seq<Message> messages) {
        DataOutputStream output$1;
        ByteBuffer byteBuffer;
        if (messages.size() == 0) {
            byteBuffer = MessageSet$.MODULE$.Empty().buffer();
        } else {
            CompressionCodec compressionCodec2 = compressionCodec;
            NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
            if (!(compressionCodec2 != null ? !compressionCodec2.equals(noCompressionCodec$) : noCompressionCodec$ != null)) {
                ByteBuffer buffer$1 = ByteBuffer.allocate(MessageSet$.MODULE$.messageSetSize((Iterable<Message>)messages));
                messages.foreach((Function1)new Serializable(offsetCounter$1, buffer$1){
                    public static final long serialVersionUID;
                    private final AtomicLong offsetCounter$1;
                    private final ByteBuffer buffer$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(Message message) {
                        ByteBufferMessageSet$.MODULE$.writeMessage(this.buffer$1, message, this.offsetCounter$1.getAndIncrement());
                    }
                    {
                        this.offsetCounter$1 = atomicLong;
                        this.buffer$1 = byteBuffer;
                    }
                });
                buffer$1.rewind();
                byteBuffer = buffer$1;
            } else {
                ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream(MessageSet$.MODULE$.messageSetSize((Iterable<Message>)messages));
                output$1 = new DataOutputStream(CompressionFactory$.MODULE$.apply(compressionCodec, byteArrayStream));
                LongRef offset$1 = new LongRef(-1L);
                messages.foreach((Function1)new Serializable(offsetCounter$1, output$1, offset$1){
                    public static final long serialVersionUID;
                    private final AtomicLong offsetCounter$1;
                    private final DataOutputStream output$1;
                    private final LongRef offset$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(Message message) {
                        this.offset$1.elem = this.offsetCounter$1.getAndIncrement();
                        this.output$1.writeLong(this.offset$1.elem);
                        this.output$1.writeInt(message.size());
                        this.output$1.write(message.buffer().array(), message.buffer().arrayOffset(), message.buffer().limit());
                    }
                    {
                        this.offsetCounter$1 = atomicLong;
                        this.output$1 = dataOutputStream;
                        this.offset$1 = longRef;
                    }
                });
                byte[] bytes = byteArrayStream.toByteArray();
                Message message = new Message(bytes, compressionCodec);
                ByteBuffer buffer = ByteBuffer.allocate(message.size() + MessageSet$.MODULE$.LogOverhead());
                this.writeMessage(buffer, message, offset$1.elem);
                buffer.rewind();
                byteBuffer = buffer;
            }
        }
        return byteBuffer;
        finally {
            output$1.close();
        }
    }

    public ByteBufferMessageSet decompress(Message message) {
        ByteArrayOutputStream outputStream$1 = new ByteArrayOutputStream();
        ByteBufferBackedInputStream inputStream = new ByteBufferBackedInputStream(message.payload());
        byte[] intermediateBuffer$1 = new byte[1024];
        InputStream compressed$1 = CompressionFactory$.MODULE$.apply(message.compressionCodec(), inputStream);
        package$.MODULE$.Stream().continually((Function0)new Serializable(intermediateBuffer$1, compressed$1){
            public static final long serialVersionUID;
            private final byte[] intermediateBuffer$1;
            private final InputStream compressed$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return this.compressed$1.read(this.intermediateBuffer$1);
            }
            {
                this.intermediateBuffer$1 = byArray;
                this.compressed$1 = inputStream;
            }
        }).takeWhile((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(int n) {
                return this.apply$mcZI$sp(n);
            }

            public boolean apply$mcZI$sp(int v1) {
                return v1 > 0;
            }
        }).foreach((Function1)new Serializable(outputStream$1, intermediateBuffer$1){
            public static final long serialVersionUID;
            private final ByteArrayOutputStream outputStream$1;
            private final byte[] intermediateBuffer$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(int dataRead) {
                this.apply$mcVI$sp(dataRead);
            }

            public void apply$mcVI$sp(int v1) {
                this.outputStream$1.write(this.intermediateBuffer$1, 0, v1);
            }
            {
                this.outputStream$1 = byteArrayOutputStream;
                this.intermediateBuffer$1 = byArray;
            }
        });
        ByteBuffer outputBuffer = ByteBuffer.allocate(outputStream$1.size());
        outputBuffer.put(outputStream$1.toByteArray());
        outputBuffer.rewind();
        return new ByteBufferMessageSet(outputBuffer);
        finally {
            compressed$1.close();
        }
    }

    public void writeMessage(ByteBuffer buffer, Message message, long offset) {
        buffer.putLong(offset);
        buffer.putInt(message.size());
        buffer.put(message.buffer());
        message.buffer().rewind();
    }

    private ByteBufferMessageSet$() {
        MODULE$ = this;
    }
}

