/*
 * Decompiled with CFR 0.152.
 */
package kafka.producer;

import java.io.OutputStream;
import java.util.Properties;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.message.DefaultCompressionCodec$;
import kafka.message.NoCompressionCodec$;
import kafka.producer.ConsoleProducer;
import kafka.producer.KeyedMessage;
import kafka.producer.Producer;
import kafka.producer.ProducerConfig;
import kafka.serializer.StringEncoder;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConsoleProducer$
implements ScalaObject {
    public static final ConsoleProducer$ MODULE$;

    static {
        new ConsoleProducer$();
    }

    public void main(String[] args) {
        OptionParser parser$1 = new OptionParser();
        ArgumentAcceptingOptionSpec topicOpt = parser$1.accepts("topic", "REQUIRED: The topic id to produce messages to.").withRequiredArg().describedAs("topic").ofType(String.class);
        ArgumentAcceptingOptionSpec brokerListOpt = parser$1.accepts("broker-list", "REQUIRED: The broker list string in the form HOST1:PORT1,HOST2:PORT2.").withRequiredArg().describedAs("broker-list").ofType(String.class);
        OptionSpecBuilder syncOpt = parser$1.accepts("sync", "If set message send requests to the brokers are synchronously, one at a time as they arrive.");
        OptionSpecBuilder compressOpt = parser$1.accepts("compress", "If set, messages batches are sent compressed");
        ArgumentAcceptingOptionSpec batchSizeOpt = parser$1.accepts("batch-size", "Number of messages to send in a single batch if they are not being sent synchronously.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(200), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec messageSendMaxRetriesOpt = parser$1.accepts("message-send-max-retries", "Brokers can fail receiving the message for multiple reasons, and being unavailable transiently is just one of them. This property specifies the number of retires before the producer give up and drop this message.").withRequiredArg().ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(3), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec retryBackoffMsOpt = parser$1.accepts("retry-backoff-ms", "Before each retry, the producer refreshes the metadata of relevant topics. Since leader election takes a bit of time, this property specifies the amount of time that the producer waits before refreshing the metadata.").withRequiredArg().ofType(Long.class).defaultsTo((Object)Predef$.MODULE$.long2Long(100L), (Object[])new Long[0]);
        ArgumentAcceptingOptionSpec sendTimeoutOpt = parser$1.accepts("timeout", "If set and the producer is running in asynchronous mode, this gives the maximum amount of time a message will queue awaiting suffient batch size. The value is given in ms.").withRequiredArg().describedAs("timeout_ms").ofType(Long.class).defaultsTo((Object)Predef$.MODULE$.long2Long(1000L), (Object[])new Long[0]);
        ArgumentAcceptingOptionSpec queueSizeOpt = parser$1.accepts("queue-size", "If set and the producer is running in asynchronous mode, this gives the maximum amount of  messages will queue awaiting suffient batch size.").withRequiredArg().describedAs("queue_size").ofType(Long.class).defaultsTo((Object)Predef$.MODULE$.long2Long(10000L), (Object[])new Long[0]);
        ArgumentAcceptingOptionSpec queueEnqueueTimeoutMsOpt = parser$1.accepts("queue-enqueuetimeout-ms", "Timeout for event enqueue").withRequiredArg().describedAs("queue enqueuetimeout ms").ofType(Long.class).defaultsTo((Object)Predef$.MODULE$.long2Long(Integer.MAX_VALUE), (Object[])new Long[0]);
        ArgumentAcceptingOptionSpec requestRequiredAcksOpt = parser$1.accepts("request-required-acks", "The required acks of the producer requests").withRequiredArg().describedAs("request required acks").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec requestTimeoutMsOpt = parser$1.accepts("request-timeout-ms", "The ack timeout of the producer requests. Value must be non-negative and non-zero").withRequiredArg().describedAs("request timeout ms").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1500), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec valueEncoderOpt = parser$1.accepts("value-serializer", "The class name of the message encoder implementation to use for serializing values.").withRequiredArg().describedAs("encoder_class").ofType(String.class).defaultsTo((Object)StringEncoder.class.getName(), (Object[])new String[0]);
        ArgumentAcceptingOptionSpec keyEncoderOpt = parser$1.accepts("key-serializer", "The class name of the message encoder implementation to use for serializing keys.").withRequiredArg().describedAs("encoder_class").ofType(String.class).defaultsTo((Object)StringEncoder.class.getName(), (Object[])new String[0]);
        ArgumentAcceptingOptionSpec messageReaderOpt = parser$1.accepts("line-reader", "The class name of the class to use for reading lines from standard in. By default each line is read as a separate message.").withRequiredArg().describedAs("reader_class").ofType(String.class).defaultsTo((Object)ConsoleProducer.LineMessageReader.class.getName(), (Object[])new String[0]);
        ArgumentAcceptingOptionSpec socketBufferSizeOpt = parser$1.accepts("socket-buffer-size", "The size of the tcp RECV size.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(102400), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec propertyOpt = parser$1.accepts("property", "A mechanism to pass user-defined properties in the form key=value to the message reader. This allows custom configuration for a user-defined message reader.").withRequiredArg().describedAs("prop").ofType(String.class);
        OptionSet options$1 = parser$1.parse(args);
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArgumentAcceptingOptionSpec[]{topicOpt, brokerListOpt})).foreach((Function1)new Serializable(parser$1, options$1){
            public static final long serialVersionUID;
            private final OptionParser parser$1;
            private final OptionSet options$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(ArgumentAcceptingOptionSpec<String> arg) {
                if (!this.options$1.has(arg)) {
                    System.err.println(new StringBuilder().append((Object)"Missing required argument \"").append(arg).append((Object)"\"").toString());
                    this.parser$1.printHelpOn((OutputStream)System.err);
                    System.exit(1);
                }
            }
            {
                this.parser$1 = optionParser;
                this.options$1 = optionSet;
            }
        });
        String topic = (String)options$1.valueOf((OptionSpec)topicOpt);
        String brokerList = (String)options$1.valueOf((OptionSpec)brokerListOpt);
        boolean sync = options$1.has((OptionSpec)syncOpt);
        boolean compress = options$1.has((OptionSpec)compressOpt);
        Integer batchSize = (Integer)options$1.valueOf((OptionSpec)batchSizeOpt);
        Long sendTimeout = (Long)options$1.valueOf((OptionSpec)sendTimeoutOpt);
        Long queueSize = (Long)options$1.valueOf((OptionSpec)queueSizeOpt);
        Long queueEnqueueTimeoutMs = (Long)options$1.valueOf((OptionSpec)queueEnqueueTimeoutMsOpt);
        Integer requestRequiredAcks = (Integer)options$1.valueOf((OptionSpec)requestRequiredAcksOpt);
        Integer requestTimeoutMs = (Integer)options$1.valueOf((OptionSpec)requestTimeoutMsOpt);
        String keyEncoderClass = (String)options$1.valueOf((OptionSpec)keyEncoderOpt);
        String valueEncoderClass = (String)options$1.valueOf((OptionSpec)valueEncoderOpt);
        String readerClass = (String)options$1.valueOf((OptionSpec)messageReaderOpt);
        Integer socketBuffer = (Integer)options$1.valueOf((OptionSpec)socketBufferSizeOpt);
        Properties cmdLineProps = this.parseLineReaderArgs((Iterable<String>)JavaConversions$.MODULE$.asScalaBuffer(options$1.valuesOf((OptionSpec)propertyOpt)));
        cmdLineProps.put("topic", topic);
        Properties props = new Properties();
        props.put("metadata.broker.list", brokerList);
        int codec = compress ? DefaultCompressionCodec$.MODULE$.codec() : NoCompressionCodec$.MODULE$.codec();
        props.put("compression.codec", ((Object)BoxesRunTime.boxToInteger((int)codec)).toString());
        props.put("producer.type", sync ? "sync" : "async");
        Object object = options$1.has((OptionSpec)batchSizeOpt) ? props.put("batch.num.messages", batchSize.toString()) : BoxedUnit.UNIT;
        props.put("message.send.max.retries", ((Integer)options$1.valueOf((OptionSpec)messageSendMaxRetriesOpt)).toString());
        props.put("retry.backoff.ms", ((Long)options$1.valueOf((OptionSpec)retryBackoffMsOpt)).toString());
        props.put("queue.buffering.max.ms", sendTimeout.toString());
        props.put("queue.buffering.max.messages", queueSize.toString());
        props.put("queue.enqueue.timeout.ms", queueEnqueueTimeoutMs.toString());
        props.put("request.required.acks", requestRequiredAcks.toString());
        props.put("request.timeout.ms", requestTimeoutMs.toString());
        props.put("key.serializer.class", keyEncoderClass);
        props.put("serializer.class", valueEncoderClass);
        props.put("send.buffer.bytes", socketBuffer.toString());
        ConsoleProducer.MessageReader reader = (ConsoleProducer.MessageReader)Class.forName(readerClass).newInstance();
        reader.init(System.in, cmdLineProps);
        try {
            Producer producer$1 = new Producer(new ProducerConfig(props));
            Runtime.getRuntime().addShutdownHook(new Thread(producer$1){
                private final Producer producer$1;

                public void run() {
                    this.producer$1.close();
                }
                {
                    this.producer$1 = producer;
                }
            });
            KeyedMessage message = null;
            while (true) {
                if ((message = reader.readMessage()) != null) {
                    producer$1.send(Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{message}));
                }
                if (message != null) {
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    /*
     * WARNING - void declaration
     */
    public Properties parseLineReaderArgs(Iterable<String> args) {
        void var3_3;
        Iterable splits = (Iterable)((TraversableLike)((TraversableLike)args.map((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String[] apply(String string) {
                return string.split("=");
            }
        }, Iterable$.MODULE$.canBuildFrom())).filterNot((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(String[] stringArray) {
                return stringArray == null;
            }
        })).filterNot((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(String[] stringArray) {
                return stringArray.length == 0;
            }
        });
        if (!splits.forall((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(String[] stringArray) {
                return stringArray.length == 2;
            }
        })) {
            System.err.println(new StringBuilder().append((Object)"Invalid line reader properties: ").append((Object)args.mkString(" ")).toString());
            System.exit(1);
        }
        Properties props$1 = new Properties();
        splits.foreach((Function1)new Serializable(props$1){
            public static final long serialVersionUID;
            private final Properties props$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Object apply(String[] a) {
                return this.props$1.put(a[0], a[1]);
            }
            {
                this.props$1 = properties;
            }
        });
        return var3_3;
    }

    private ConsoleProducer$() {
        MODULE$ = this;
    }
}

