/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import kafka.common.TopicAndPartition;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u000113A!\u0001\u0002\u0001\u000f\t\u0001rJ\u001a4tKR\u001c\u0005.Z2la>Lg\u000e\u001e\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M!\u0001\u0001\u0003\t\u0017!\tIa\"D\u0001\u000b\u0015\tYA\"\u0001\u0003mC:<'\"A\u0007\u0002\t)\fg/Y\u0005\u0003\u001f)\u0011aa\u00142kK\u000e$\bCA\t\u0015\u001b\u0005\u0011\"BA\n\u0005\u0003\u0015)H/\u001b7t\u0013\t)\"CA\u0004M_\u001e<\u0017N\\4\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\t;\u0001\u0011)\u0019!C\u0001=\u0005!a-\u001b7f+\u0005y\u0002C\u0001\u0011$\u001b\u0005\t#B\u0001\u0012\r\u0003\tIw.\u0003\u0002%C\t!a)\u001b7f\u0011!1\u0003A!A!\u0002\u0013y\u0012!\u00024jY\u0016\u0004\u0003\"\u0002\u0015\u0001\t\u0003I\u0013A\u0002\u001fj]&$h\b\u0006\u0002+YA\u00111\u0006A\u0007\u0002\u0005!)Qd\na\u0001?!9a\u0006\u0001b\u0001\n\u0013y\u0013\u0001\u00027pG.,\u0012\u0001\u0003\u0005\u0007c\u0001\u0001\u000b\u0011\u0002\u0005\u0002\u000b1|7m\u001b\u0011\t\u000bM\u0002A\u0011\u0001\u001b\u0002\u000b]\u0014\u0018\u000e^3\u0015\u0005UB\u0004CA\f7\u0013\t9\u0004D\u0001\u0003V]&$\b\"B\u001d3\u0001\u0004Q\u0014aB8gMN,Go\u001d\t\u0005wy\u0002e)D\u0001=\u0015\ti\u0004$\u0001\u0006d_2dWm\u0019;j_:L!a\u0010\u001f\u0003\u00075\u000b\u0007\u000f\u0005\u0002B\t6\t!I\u0003\u0002D\t\u000511m\\7n_:L!!\u0012\"\u0003#Q{\u0007/[2B]\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0002\u0018\u000f&\u0011\u0001\n\u0007\u0002\u0005\u0019>tw\rC\u0003K\u0001\u0011\u00051*\u0001\u0003sK\u0006$G#\u0001\u001e")
public class OffsetCheckpoint
implements Logging {
    private final File file;
    private final Object lock;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        OffsetCheckpoint offsetCheckpoint = this;
        synchronized (offsetCheckpoint) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public File file() {
        return this.file;
    }

    private Object lock() {
        return this.lock;
    }

    public void write(Map<TopicAndPartition, Object> offsets$1) {
        Object object = this.lock();
        synchronized (object) {
            File temp;
            block7: {
                block6: {
                    BoxedUnit boxedUnit;
                    block5: {
                        temp = new File(new StringBuilder().append((Object)this.file().getAbsolutePath()).append((Object)".tmp").toString());
                        BufferedWriter writer$1 = new BufferedWriter(new FileWriter(temp));
                        this.liftedTree1$1(offsets$1, writer$1);
                        if (!temp.renameTo(this.file())) break block5;
                        boxedUnit = BoxedUnit.UNIT;
                        break block6;
                    }
                    this.file().delete();
                    if (!temp.renameTo(this.file())) break block7;
                    boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
            throw new IOException(Predef$.MODULE$.augmentString("File rename from %s to %s failed.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{temp.getAbsolutePath(), this.file().getAbsolutePath()})));
        }
    }

    public Map<TopicAndPartition, Object> read() {
        NonLocalReturnControl nonLocalReturnControl2;
        block6: {
            Object object = new Object();
            Map exceptionResult1 = null;
            try {
                Object object2 = this.lock();
                synchronized (object2) {
                    BufferedReader reader$1 = new BufferedReader(new FileReader(this.file()));
                    Map map = this.liftedTree2$1(reader$1, object);
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var4_3
                    exceptionResult1 = map;
                }
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block6;
                exceptionResult1 = (Map)nonLocalReturnControl2.value();
            }
            return exceptionResult1;
        }
        throw nonLocalReturnControl2;
    }

    private final void liftedTree1$1(Map map, BufferedWriter bufferedWriter) {
        try {
            bufferedWriter.write(((Object)BoxesRunTime.boxToInteger((int)0)).toString());
            bufferedWriter.newLine();
            bufferedWriter.write(((Object)BoxesRunTime.boxToInteger((int)map.size())).toString());
            bufferedWriter.newLine();
            map.foreach((Function1)new Serializable(this, bufferedWriter){
                public static final long serialVersionUID;
                private final BufferedWriter writer$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(Tuple2<TopicAndPartition, Object> tuple2) {
                    Tuple2<TopicAndPartition, Object> tuple22 = tuple2;
                    if (tuple22 != null) {
                        TopicAndPartition topicAndPartition;
                        TopicAndPartition topicPart = topicAndPartition = (TopicAndPartition)tuple22._1();
                        this.writer$1.write(Predef$.MODULE$.augmentString("%s %d %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPart.topic(), BoxesRunTime.boxToInteger((int)topicPart.partition()), tuple22._2()})));
                        this.writer$1.newLine();
                        return;
                    }
                    throw new MatchError(tuple22);
                }
                {
                    this.writer$1 = bufferedWriter;
                }
            });
            bufferedWriter.flush();
            return;
        }
        finally {
            bufferedWriter.close();
        }
    }

    private final Map liftedTree2$1(BufferedReader bufferedReader, Object object) {
        Map exceptionResult2 = null;
        try {
            String line = bufferedReader.readLine();
            if (line == null) {
                throw new NonLocalReturnControl(object, (Object)Map$.MODULE$.empty());
            }
            int version = Predef$.MODULE$.augmentString(line).toInt();
            int n = version;
            if (n == 0) {
                line = bufferedReader.readLine();
                if (line == null) {
                    throw new NonLocalReturnControl(object, (Object)Map$.MODULE$.empty());
                }
                int expectedSize = Predef$.MODULE$.augmentString(line).toInt();
                Map offsets = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
                line = bufferedReader.readLine();
                while (true) {
                    if (line == null) {
                        if (offsets.size() != expectedSize) {
                            throw new IOException(Predef$.MODULE$.augmentString("Expected %d entries but found only %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)expectedSize), BoxesRunTime.boxToInteger((int)offsets.size())})));
                        }
                        exceptionResult2 = offsets;
                        return exceptionResult2;
                    }
                    String[] pieces = line.split("\\s+");
                    if (pieces.length != 3) {
                        throw new IOException(Predef$.MODULE$.augmentString("Malformed line in offset checkpoint file: '%s'.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{line})));
                    }
                    String topic = pieces[0];
                    int partition = Predef$.MODULE$.augmentString(pieces[1]).toInt();
                    long offset = Predef$.MODULE$.augmentString(pieces[2]).toLong();
                    offsets = offsets.$plus(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition(topic, partition)).$minus$greater((Object)BoxesRunTime.boxToLong((long)offset)));
                    line = bufferedReader.readLine();
                }
            }
            throw new IOException(new StringBuilder().append((Object)"Unrecognized version of the highwatermark checkpoint file: ").append((Object)BoxesRunTime.boxToInteger((int)version)).toString());
        }
        finally {
            bufferedReader.close();
        }
    }

    public OffsetCheckpoint(File file) {
        this.file = file;
        Logging$class.$init$(this);
        this.lock = new Object();
        new File(Predef$.MODULE$.any2stringadd((Object)file).$plus(".tmp")).delete();
        file.createNewFile();
    }
}

