/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.modules.properties;

import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import org.apache.felix.utils.properties.Properties;
import org.apache.karaf.jaas.boot.principal.GroupPrincipal;
import org.apache.karaf.jaas.boot.principal.RolePrincipal;
import org.apache.karaf.jaas.boot.principal.UserPrincipal;
import org.apache.karaf.jaas.modules.BackingEngine;
import org.apache.karaf.jaas.modules.encryption.EncryptionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesBackingEngine
implements BackingEngine {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(PropertiesBackingEngine.class);
    static final String GROUP_PREFIX = "_g_:";
    private Properties users;
    private EncryptionSupport encryptionSupport;

    public PropertiesBackingEngine(Properties users) {
        this.users = users;
    }

    public PropertiesBackingEngine(Properties users, EncryptionSupport encryptionSupport) {
        this.users = users;
        this.encryptionSupport = encryptionSupport;
    }

    @Override
    public void addUser(String username, String password) {
        if (username.startsWith(GROUP_PREFIX)) {
            throw new IllegalArgumentException("Prefix not permitted: _g_:");
        }
        this.addUserInternal(username, password);
    }

    private void addUserInternal(String username, String password) {
        String userInfos;
        String[] infos = null;
        StringBuffer userInfoBuffer = new StringBuffer();
        String newPassword = password;
        if (this.encryptionSupport != null && this.encryptionSupport.getEncryption() != null) {
            newPassword = this.encryptionSupport.getEncryption().encryptPassword(password);
            if (this.encryptionSupport.getEncryptionPrefix() != null) {
                newPassword = this.encryptionSupport.getEncryptionPrefix() + newPassword;
            }
            if (this.encryptionSupport.getEncryptionSuffix() != null) {
                newPassword = newPassword + this.encryptionSupport.getEncryptionSuffix();
            }
        }
        if ((userInfos = (String)this.users.get(username)) != null && userInfos.length() > 0) {
            infos = userInfos.split(",");
            userInfoBuffer.append(newPassword);
            for (int i = 1; i < infos.length; ++i) {
                userInfoBuffer.append(",");
                userInfoBuffer.append(infos[i]);
            }
            String newUserInfo = userInfoBuffer.toString();
            this.users.put(username, newUserInfo);
        } else {
            this.users.put(username, newPassword);
        }
        try {
            this.users.save();
        }
        catch (Exception ex) {
            LOGGER.error("Cannot update users file,", (Throwable)ex);
        }
    }

    @Override
    public void deleteUser(String username) {
        for (GroupPrincipal gp : this.listGroups(username)) {
            this.deleteGroup(username, gp.getName());
        }
        this.users.remove(username);
        try {
            this.users.save();
        }
        catch (Exception ex) {
            LOGGER.error("Cannot remove users file,", (Throwable)ex);
        }
    }

    @Override
    public List<UserPrincipal> listUsers() {
        ArrayList<UserPrincipal> result = new ArrayList<UserPrincipal>();
        for (Object user : this.users.keySet()) {
            String userName = (String)user;
            if (userName.startsWith(GROUP_PREFIX)) continue;
            UserPrincipal userPrincipal = new UserPrincipal(userName);
            result.add(userPrincipal);
        }
        return result;
    }

    @Override
    public List<RolePrincipal> listRoles(Principal principal) {
        String userName = principal.getName();
        if (principal instanceof GroupPrincipal) {
            userName = GROUP_PREFIX + userName;
        }
        return this.listRoles(userName);
    }

    private List<RolePrincipal> listRoles(String name) {
        ArrayList<RolePrincipal> result = new ArrayList<RolePrincipal>();
        String userInfo = (String)this.users.get(name);
        String[] infos = userInfo.split(",");
        for (int i = 1; i < infos.length; ++i) {
            String roleName = infos[i];
            if (roleName.startsWith(GROUP_PREFIX)) {
                for (RolePrincipal rp : this.listRoles(roleName)) {
                    if (result.contains(rp)) continue;
                    result.add(rp);
                }
                continue;
            }
            RolePrincipal rp = new RolePrincipal(roleName);
            if (result.contains(rp)) continue;
            result.add(rp);
        }
        return result;
    }

    @Override
    public void addRole(String username, String role) {
        String userInfos = (String)this.users.get(username);
        if (userInfos != null) {
            for (RolePrincipal rp : this.listRoles(username)) {
                if (!role.equals(rp.getName())) continue;
                return;
            }
            String newUserInfos = userInfos + "," + role;
            this.users.put(username, newUserInfos);
        }
        try {
            this.users.save();
        }
        catch (Exception ex) {
            LOGGER.error("Cannot update users file,", (Throwable)ex);
        }
    }

    @Override
    public void deleteRole(String username, String role) {
        String[] infos = null;
        StringBuffer userInfoBuffer = new StringBuffer();
        String userInfos = (String)this.users.get(username);
        if (userInfos != null && userInfos.length() > 0) {
            infos = userInfos.split(",");
            String password = infos[0];
            userInfoBuffer.append(password);
            for (int i = 1; i < infos.length; ++i) {
                if (infos[i] == null || infos[i].equals(role)) continue;
                userInfoBuffer.append(",");
                userInfoBuffer.append(infos[i]);
            }
            String newUserInfo = userInfoBuffer.toString();
            this.users.put(username, newUserInfo);
        }
        try {
            this.users.save();
        }
        catch (Exception ex) {
            LOGGER.error("Cannot update users file,", (Throwable)ex);
        }
    }

    @Override
    public List<GroupPrincipal> listGroups(UserPrincipal user) {
        String userName = user.getName();
        return this.listGroups(userName);
    }

    private List<GroupPrincipal> listGroups(String userName) {
        ArrayList<GroupPrincipal> result = new ArrayList<GroupPrincipal>();
        String userInfo = (String)this.users.get(userName);
        if (userInfo != null) {
            String[] infos = userInfo.split(",");
            for (int i = 1; i < infos.length; ++i) {
                String name = infos[i];
                if (!name.startsWith(GROUP_PREFIX)) continue;
                result.add(new GroupPrincipal(name.substring(GROUP_PREFIX.length())));
            }
        }
        return result;
    }

    @Override
    public void addGroup(String username, String group) {
        String groupName = GROUP_PREFIX + group;
        if (this.users.get(groupName) == null) {
            this.addUserInternal(groupName, "group");
        }
        this.addRole(username, groupName);
    }

    @Override
    public void deleteGroup(String username, String group) {
        this.deleteRole(username, GROUP_PREFIX + group);
        for (UserPrincipal user : this.listUsers()) {
            for (GroupPrincipal g : this.listGroups(user)) {
                if (!group.equals(g.getName())) continue;
                return;
            }
        }
        this.deleteUser(GROUP_PREFIX + group);
    }

    @Override
    public void addGroupRole(String group, String role) {
        this.addRole(GROUP_PREFIX + group, role);
    }

    @Override
    public void deleteGroupRole(String group, String role) {
        this.deleteRole(GROUP_PREFIX + group, role);
    }
}

