/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.console.completer;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.gogo.commands.basic.AbstractCommand;
import org.apache.felix.gogo.commands.basic.DefaultActionPreparator;
import org.apache.karaf.shell.console.CompletableFunction;
import org.apache.karaf.shell.console.Completer;
import org.apache.karaf.shell.console.NameScoping;
import org.apache.karaf.shell.console.completer.NullCompleter;
import org.apache.karaf.shell.console.completer.Parser;
import org.apache.karaf.shell.console.completer.StringsCompleter;
import org.osgi.service.command.CommandSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgumentCompleter
implements Completer {
    final Completer commandCompleter;
    final Completer optionsCompleter;
    final List<Completer> argsCompleters;
    final AbstractCommand function;
    final Map<Option, Field> fields = new HashMap<Option, Field>();
    final Map<String, Option> options = new HashMap<String, Option>();
    boolean strict = true;

    public ArgumentCompleter(CommandSession session, AbstractCommand function, String command) {
        this.function = function;
        this.commandCompleter = new StringsCompleter(this.getNames(session, command));
        for (Class<? extends Action> type = function.getActionClass(); type != null; type = type.getSuperclass()) {
            for (Field field : type.getDeclaredFields()) {
                Option option = field.getAnnotation(Option.class);
                if (option == null) continue;
                this.fields.put(option, field);
                this.options.put(option.name(), option);
                String[] aliases = option.aliases();
                if (aliases == null) continue;
                for (String alias : aliases) {
                    this.options.put(alias, option);
                }
            }
        }
        this.options.put(DefaultActionPreparator.HELP.name(), DefaultActionPreparator.HELP);
        this.optionsCompleter = new StringsCompleter(this.options.keySet());
        this.argsCompleters = new ArrayList<Completer>();
        if (function instanceof CompletableFunction) {
            List<Completer> fcl = ((CompletableFunction)((Object)function)).getCompleters();
            if (fcl != null) {
                for (Completer c : fcl) {
                    this.argsCompleters.add(c == null ? NullCompleter.INSTANCE : c);
                }
            } else {
                this.argsCompleters.add(NullCompleter.INSTANCE);
            }
        } else {
            this.argsCompleters.add(NullCompleter.INSTANCE);
        }
    }

    private String[] getNames(CommandSession session, String scopedCommand) {
        String command = NameScoping.getCommandNameWithoutGlobalPrefix(session, scopedCommand);
        String[] s = command.split(":");
        if (s.length == 1) {
            return s;
        }
        return new String[]{command, s[1]};
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public boolean getStrict() {
        return this.strict;
    }

    @Override
    public int complete(String buffer, int cursor, List<String> candidates) {
        int ret;
        ArgumentList list = this.delimit(buffer, cursor);
        int argpos = list.getArgumentPosition();
        int argIndex = list.getCursorArgumentIndex();
        Completer comp = null;
        String[] args = list.getArguments();
        int index = 0;
        if (index < argIndex) {
            if (!this.verifyCompleter(this.commandCompleter, args[index])) {
                return -1;
            }
            ++index;
        } else {
            comp = this.commandCompleter;
        }
        if (comp == null) {
            while (index < argIndex && args[index].startsWith("-")) {
                if (!this.verifyCompleter(this.optionsCompleter, args[index])) {
                    return -1;
                }
                Option option = this.options.get(args[index]);
                if (option == null) {
                    return -1;
                }
                Field field = this.fields.get(option);
                if (field != null && field.getType() != Boolean.TYPE && field.getType() != Boolean.class && ++index == argIndex) {
                    comp = NullCompleter.INSTANCE;
                }
                ++index;
            }
            if (comp == null && index >= argIndex && index < args.length && args[index].startsWith("-")) {
                comp = this.optionsCompleter;
            }
        }
        if (comp == null) {
            int indexArg = 0;
            while (index < argIndex) {
                Completer sub = this.argsCompleters.get(indexArg >= this.argsCompleters.size() ? this.argsCompleters.size() - 1 : indexArg);
                if (!this.verifyCompleter(sub, args[index])) {
                    return -1;
                }
                ++index;
                ++indexArg;
            }
            comp = this.argsCompleters.get(indexArg >= this.argsCompleters.size() ? this.argsCompleters.size() - 1 : indexArg);
        }
        if ((ret = comp.complete(list.getCursorArgument(), argpos, candidates)) == -1) {
            return -1;
        }
        int pos = ret + (list.getBufferPosition() - argpos);
        if (cursor != buffer.length() && this.isDelimiter(buffer, cursor)) {
            for (int i = 0; i < candidates.size(); ++i) {
                String val = candidates.get(i);
                while (val.length() > 0 && this.isDelimiter(val, val.length() - 1)) {
                    val = val.substring(0, val.length() - 1);
                }
                candidates.set(i, val);
            }
        }
        return pos;
    }

    protected boolean verifyCompleter(Completer completer, String argument) {
        ArrayList<String> candidates = new ArrayList<String>();
        return completer.complete(argument, argument.length(), candidates) != -1 && !candidates.isEmpty();
    }

    public ArgumentList delimit(String buffer, int cursor) {
        Parser parser = new Parser(buffer, cursor);
        try {
            List<List<List<String>>> program = parser.program();
            List<String> pipe = program.get(parser.c0).get(parser.c1);
            return new ArgumentList(pipe.toArray(new String[pipe.size()]), parser.c2, parser.c3, cursor);
        }
        catch (Throwable t) {
            return new ArgumentList(new String[]{buffer}, 0, cursor, cursor);
        }
    }

    public boolean isDelimiter(String buffer, int pos) {
        return !this.isEscaped(buffer, pos) && this.isDelimiterChar(buffer, pos);
    }

    public boolean isEscaped(String buffer, int pos) {
        return pos > 0 && buffer.charAt(pos) == '\\' && !this.isEscaped(buffer, pos - 1);
    }

    public boolean isDelimiterChar(String buffer, int pos) {
        return Character.isWhitespace(buffer.charAt(pos));
    }

    public static class ArgumentList {
        private String[] arguments;
        private int cursorArgumentIndex;
        private int argumentPosition;
        private int bufferPosition;

        public ArgumentList(String[] arguments, int cursorArgumentIndex, int argumentPosition, int bufferPosition) {
            this.arguments = arguments;
            this.cursorArgumentIndex = cursorArgumentIndex;
            this.argumentPosition = argumentPosition;
            this.bufferPosition = bufferPosition;
        }

        public void setCursorArgumentIndex(int cursorArgumentIndex) {
            this.cursorArgumentIndex = cursorArgumentIndex;
        }

        public int getCursorArgumentIndex() {
            return this.cursorArgumentIndex;
        }

        public String getCursorArgument() {
            if (this.cursorArgumentIndex < 0 || this.cursorArgumentIndex >= this.arguments.length) {
                return null;
            }
            return this.arguments[this.cursorArgumentIndex];
        }

        public void setArgumentPosition(int argumentPosition) {
            this.argumentPosition = argumentPosition;
        }

        public int getArgumentPosition() {
            return this.argumentPosition;
        }

        public void setArguments(String[] arguments) {
            this.arguments = arguments;
        }

        public String[] getArguments() {
            return this.arguments;
        }

        public void setBufferPosition(int bufferPosition) {
            this.bufferPosition = bufferPosition;
        }

        public int getBufferPosition() {
            return this.bufferPosition;
        }
    }
}

