/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.console.impl.jline;

import java.io.InputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.Properties;
import jline.Terminal;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Function;
import org.apache.felix.service.threadio.ThreadIO;
import org.apache.karaf.jaas.modules.JaasHelper;
import org.apache.karaf.shell.console.Console;
import org.apache.karaf.shell.console.factory.ConsoleFactory;
import org.apache.karaf.shell.console.impl.jline.ConsoleImpl;
import org.apache.karaf.shell.util.ShellUtil;
import org.osgi.framework.BundleContext;

public class ConsoleFactoryService
implements ConsoleFactory {
    private static final Class<?>[] SECURITY_BUGFIX = new Class[]{JaasHelper.class, JaasHelper.OsgiSubjectDomainCombiner.class, JaasHelper.DelegatingProtectionDomain.class};
    private final BundleContext bundleContext;
    private CommandProcessor processor;
    private ThreadIO threadIO;

    public ConsoleFactoryService(BundleContext bc, CommandProcessor processor, ThreadIO threadIO) {
        this.bundleContext = bc;
        this.processor = processor;
        this.threadIO = threadIO;
    }

    @Override
    public Console create(InputStream in, PrintStream out, PrintStream err, final Terminal terminal, String encoding, Runnable closeCallback) {
        ConsoleImpl console = new ConsoleImpl(this.processor, this.threadIO, in, out, err, terminal, encoding, closeCallback, this.bundleContext, true);
        CommandSession session = console.getSession();
        session.put("USER", ShellUtil.getCurrentUserName());
        session.put("APPLICATION", System.getProperty("karaf.name", "root"));
        session.put("#LINES", new Function(){

            @Override
            public Object execute(CommandSession session, List<Object> arguments) throws Exception {
                return Integer.toString(terminal.getHeight());
            }
        });
        session.put("#COLUMNS", new Function(){

            @Override
            public Object execute(CommandSession session, List<Object> arguments) throws Exception {
                return Integer.toString(terminal.getWidth());
            }
        });
        session.put(".jline.terminal", terminal);
        this.addSystemProperties(session);
        session.put("pid", this.getPid());
        return console;
    }

    private String getPid() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        String[] parts = name.split("@");
        return parts[0];
    }

    private void addSystemProperties(CommandSession session) {
        Properties sysProps = System.getProperties();
        for (String string : sysProps.keySet()) {
            session.put(string, System.getProperty(string));
        }
    }
}

