/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling.features;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.karaf.tooling.features.MojoSupport;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddFeaturesToRepoMojo
extends MojoSupport {
    private List<String> descriptors;
    private List<String> features;
    private File repository;
    private boolean skipNonMavenProtocols = true;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            HashMap<String, Feature> featuresMap = new HashMap<String, Feature>();
            for (String uri : this.descriptors) {
                Repository repo = new Repository(URI.create(this.translateFromMaven(uri)));
                for (Feature f : repo.getFeatures()) {
                    featuresMap.put(f.getName(), f);
                }
            }
            HashSet<String> transitiveFeatures = new HashSet<String>();
            this.addFeatures(this.features, transitiveFeatures, featuresMap);
            HashSet<String> bundles = new HashSet<String>();
            for (String feature : transitiveFeatures) {
                bundles.addAll(((Feature)featuresMap.get(feature)).getBundles());
            }
            this.getLog().info((CharSequence)("Base repo: " + this.localRepo.getUrl()));
            for (String bundle : bundles) {
                int index = bundle.indexOf("mvn:");
                if (index < 0) {
                    if (this.skipNonMavenProtocols) continue;
                    throw new MojoExecutionException("Bundle url is not a maven url: " + bundle);
                }
                bundle = bundle.substring(index);
                int index1 = bundle.indexOf(63);
                int index2 = bundle.indexOf(35);
                int endIndex = -1;
                if (index1 > 0) {
                    endIndex = index2 > 0 ? Math.min(index1, index2) : index1;
                } else if (index2 > 0) {
                    endIndex = index2;
                }
                if (endIndex >= 0) {
                    bundle = bundle.substring(0, endIndex);
                }
                String[] parts = bundle.substring("mvn:".length()).split("/");
                String groupId = parts[0];
                String artifactId = parts[1];
                String version = null;
                String classifier = null;
                String type = "jar";
                if (parts.length > 2) {
                    version = parts[2];
                    if (parts.length > 3) {
                        type = parts[3];
                        if (parts.length > 4) {
                            classifier = parts[4];
                        }
                    }
                }
                String dir = groupId.replace('.', '/') + "/" + artifactId + "/" + version + "/";
                String name = artifactId + "-" + version + (classifier != null ? "-" + classifier : "") + "." + type;
                try {
                    Artifact artifact = this.factory.createArtifactWithClassifier(groupId, artifactId, version, type, classifier);
                    this.getLog().info((CharSequence)("Copying bundle: " + bundle));
                    this.resolver.resolve(artifact, this.remoteRepos, this.localRepo);
                    AddFeaturesToRepoMojo.copy(new FileInputStream(artifact.getFile()), this.repository, name, dir, new byte[8192]);
                }
                catch (ArtifactResolutionException e) {
                    this.getLog().error((CharSequence)("Can't resolve bundle " + bundle), (Throwable)e);
                }
                catch (ArtifactNotFoundException e) {
                    this.getLog().error((CharSequence)("Can't resolve bundle " + bundle), (Throwable)e);
                }
            }
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (MojoFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error populating repository", e);
        }
    }

    private void addFeatures(List<String> features, Set<String> transitiveFeatures, Map<String, Feature> featuresMap) {
        for (String feature : features) {
            Feature f = featuresMap.get(feature);
            if (f == null) {
                throw new IllegalArgumentException("Unable to find the feature '" + feature + "'");
            }
            transitiveFeatures.add(feature);
            this.addFeatures(f.getDependencies(), transitiveFeatures, featuresMap);
        }
    }

    public static void copy(InputStream is, File dir, String destName, String destDir, byte[] buffer) throws IOException {
        File targetDir;
        if (destDir == null) {
            destDir = "";
        }
        if (!(targetDir = new File(dir, destDir)).exists()) {
            if (!targetDir.mkdirs()) {
                throw new IOException("Unable to create target directory: " + targetDir);
            }
        } else if (!targetDir.isDirectory()) {
            throw new IOException("Target is not a directory: " + targetDir);
        }
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(new File(targetDir, destName)));
        int count = 0;
        while ((count = is.read(buffer)) > 0) {
            bos.write(buffer, 0, count);
        }
        bos.close();
    }

    public static class Repository {
        private URI uri;
        private List<Feature> features;

        public Repository(URI uri) {
            this.uri = uri;
        }

        public URI getURI() {
            return this.uri;
        }

        public Feature[] getFeatures() throws Exception {
            if (this.features == null) {
                this.load();
            }
            return this.features.toArray(new Feature[this.features.size()]);
        }

        public void load() throws IOException {
            try {
                this.features = new ArrayList<Feature>();
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                Document doc = factory.newDocumentBuilder().parse(this.uri.toURL().openStream());
                NodeList nodes = doc.getDocumentElement().getChildNodes();
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node node = nodes.item(i);
                    if (!(node instanceof Element) || !"feature".equals(node.getNodeName())) continue;
                    Element e = (Element)nodes.item(i);
                    String name = e.getAttribute("name");
                    Feature f = new Feature(name);
                    NodeList featureNodes = e.getElementsByTagName("feature");
                    for (int j = 0; j < featureNodes.getLength(); ++j) {
                        Element b = (Element)featureNodes.item(j);
                        f.addDependency(b.getTextContent());
                    }
                    NodeList configNodes = e.getElementsByTagName("config");
                    for (int j = 0; j < configNodes.getLength(); ++j) {
                        Element c = (Element)configNodes.item(j);
                        String cfgName = c.getAttribute("name");
                        String data = c.getTextContent();
                        Properties properties = new Properties();
                        properties.load(new ByteArrayInputStream(data.getBytes()));
                        Hashtable<String, String> hashtable = new Hashtable<String, String>();
                        for (Object key : properties.keySet()) {
                            String n = key.toString();
                            hashtable.put(n, properties.getProperty(n));
                        }
                        f.addConfig(cfgName, hashtable);
                    }
                    NodeList bundleNodes = e.getElementsByTagName("bundle");
                    for (int j = 0; j < bundleNodes.getLength(); ++j) {
                        Element b = (Element)bundleNodes.item(j);
                        f.addBundle(b.getTextContent());
                    }
                    this.features.add(f);
                }
            }
            catch (SAXException e) {
                throw (IOException)new IOException().initCause(e);
            }
            catch (ParserConfigurationException e) {
                throw (IOException)new IOException().initCause(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Feature {
        private String name;
        private List<String> dependencies = new ArrayList<String>();
        private List<String> bundles = new ArrayList<String>();
        private Map<String, Map<String, String>> configs = new HashMap<String, Map<String, String>>();

        public Feature(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public List<String> getDependencies() {
            return this.dependencies;
        }

        public List<String> getBundles() {
            return this.bundles;
        }

        public Map<String, Map<String, String>> getConfigurations() {
            return this.configs;
        }

        public void addDependency(String dependency) {
            this.dependencies.add(dependency);
        }

        public void addBundle(String bundle) {
            this.bundles.add(bundle);
        }

        public void addConfig(String name, Map<String, String> properties) {
            this.configs.put(name, properties);
        }
    }
}

