/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling;

import java.io.File;
import org.apache.karaf.jpm.Process;
import org.apache.karaf.jpm.impl.ProcessBuilderFactoryImpl;
import org.apache.karaf.tooling.utils.MojoSupport;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="docker", defaultPhase=LifecyclePhase.PACKAGE)
public class DockerMojo
extends MojoSupport {
    @Parameter(defaultValue="${project.build.directory}")
    private File location;
    @Parameter(defaultValue="karaf")
    private String imageName;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Creating Docker image");
        try {
            Process process = new ProcessBuilderFactoryImpl().newBuilder().command("docker build -t " + this.imageName + " .").directory(this.location).start();
            this.getLog().info((CharSequence)("Docker PID " + process.getPid() + " running"));
            while (process.isRunning()) {
                Thread.sleep(100L);
            }
            this.getLog().info((CharSequence)("Docker image " + this.imageName + " created"));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Can't create Docker image: " + e.getMessage(), e);
        }
    }
}

