/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.spi;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public class ThrowableInformation
implements Serializable {
    static final long serialVersionUID = -4748765566864322735L;
    private transient Throwable throwable;
    private final Method toStringList;

    public ThrowableInformation(Throwable throwable) {
        this.throwable = throwable;
        Method method = null;
        try {
            Class<?> throwables = Class.forName("org.apache.logging.log4j.core.util.Throwables");
            method = throwables.getMethod("toStringList", Throwable.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
        this.toStringList = method;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public synchronized String[] getThrowableStrRep() {
        if (this.toStringList != null && this.throwable != null) {
            try {
                List elements = (List)this.toStringList.invoke(null, this.throwable);
                if (elements != null) {
                    return elements.toArray(new String[0]);
                }
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
        return null;
    }
}

