/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.flume.appender;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.util.Integers;
import org.apache.logging.log4j.plugins.Plugin;
import org.apache.logging.log4j.plugins.PluginAttribute;
import org.apache.logging.log4j.plugins.PluginFactory;
import org.apache.logging.log4j.status.StatusLogger;

@Plugin(name="Agent", category="Core", printObject=true)
public final class Agent {
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 35853;
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final String host;
    private final int port;

    private Agent(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        return "host=" + this.host + " port=" + this.port;
    }

    @PluginFactory
    public static Agent createAgent(@PluginAttribute(value="host") String host, @PluginAttribute(value="port") String port) {
        int portNum;
        if (host == null) {
            host = DEFAULT_HOST;
        }
        try {
            portNum = Integers.parseInt((String)port, (int)35853);
        }
        catch (Exception ex) {
            LOGGER.error("Error parsing port number " + port, (Throwable)ex);
            return null;
        }
        return new Agent(host, portNum);
    }
}

