/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.nosql.appender;

import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.db.AbstractDatabaseAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.util.Booleans;
import org.apache.logging.log4j.nosql.appender.NoSqlDatabaseManager;
import org.apache.logging.log4j.nosql.appender.NoSqlProvider;

@Plugin(name="NoSql", category="Core", elementType="appender", printObject=true)
public final class NoSqlAppender
extends AbstractDatabaseAppender<NoSqlDatabaseManager<?>> {
    private static final long serialVersionUID = 1L;
    private final String description = String.valueOf(this.getName()) + "{ manager=" + this.getManager() + " }";

    private NoSqlAppender(String name, Filter filter, boolean ignoreExceptions, NoSqlDatabaseManager<?> manager) {
        super(name, filter, ignoreExceptions, manager);
    }

    public String toString() {
        return this.description;
    }

    @PluginFactory
    public static NoSqlAppender createAppender(@PluginAttribute(value="name") String name, @PluginAttribute(value="ignoreExceptions") String ignore, @PluginElement(value="Filter") Filter filter, @PluginAttribute(value="bufferSize") String bufferSize, @PluginElement(value="NoSqlProvider") NoSqlProvider<?> provider) {
        if (provider == null) {
            LOGGER.error("NoSQL provider not specified for appender [{}].", new Object[]{name});
            return null;
        }
        int bufferSizeInt = AbstractAppender.parseInt((String)bufferSize, (int)0);
        boolean ignoreExceptions = Booleans.parseBoolean((String)ignore, (boolean)true);
        String managerName = "noSqlManager{ description=" + name + ", bufferSize=" + bufferSizeInt + ", provider=" + provider + " }";
        NoSqlDatabaseManager<?> manager = NoSqlDatabaseManager.getNoSqlDatabaseManager(managerName, bufferSizeInt, provider);
        if (manager == null) {
            return null;
        }
        return new NoSqlAppender(name, filter, ignoreExceptions, manager);
    }
}

