/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.bind;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.plugins.bind.AbstractConfigurationBinder;
import org.apache.logging.log4j.plugins.bind.ConfigurationBinder;
import org.apache.logging.log4j.plugins.bind.ConfigurationBindingException;

public class FactoryMethodBinder {
    private final Method factoryMethod;
    private final Map<Parameter, ConfigurationBinder> binders = new ConcurrentHashMap<Parameter, ConfigurationBinder>();
    private final Map<Parameter, Object> boundParameters = new ConcurrentHashMap<Parameter, Object>();

    public FactoryMethodBinder(Method factoryMethod) {
        this.factoryMethod = Objects.requireNonNull(factoryMethod);
        for (Parameter parameter : factoryMethod.getParameters()) {
            this.binders.put(parameter, new ParameterConfigurationBinder(parameter));
        }
    }

    public void forEachParameter(BiConsumer<Parameter, ConfigurationBinder> consumer) {
        this.binders.forEach(consumer);
    }

    public Object invoke() throws Throwable {
        Parameter[] parameters = this.factoryMethod.getParameters();
        Object[] args = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            args[i] = this.boundParameters.get(parameters[i]);
        }
        try {
            return this.factoryMethod.invoke(null, args);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationBindingException("Cannot access factory method " + this.factoryMethod, e);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    private class ParameterConfigurationBinder
    extends AbstractConfigurationBinder<Parameter> {
        private ParameterConfigurationBinder(Parameter parameter) {
            super(parameter, Parameter::getParameterizedType);
        }

        @Override
        public void bindObject(Object factory, Object value) {
            this.validate(value);
            if (value != null) {
                FactoryMethodBinder.this.boundParameters.put((Parameter)this.element, value);
            }
        }
    }
}

