/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.inject;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.plugins.Node;
import org.apache.logging.log4j.plugins.PluginAliases;
import org.apache.logging.log4j.plugins.bind.ConfigurationBinder;
import org.apache.logging.log4j.plugins.inject.ConfigurationInjector;
import org.apache.logging.log4j.plugins.name.AnnotatedElementNameProvider;
import org.apache.logging.log4j.status.StatusLogger;

public abstract class AbstractConfigurationInjector<Ann extends Annotation, Cfg>
implements ConfigurationInjector<Ann, Cfg> {
    protected static final Logger LOGGER = StatusLogger.getLogger();
    protected Ann annotation;
    protected AnnotatedElement annotatedElement;
    protected Type conversionType;
    protected String name;
    protected Collection<String> aliases = Collections.emptyList();
    protected ConfigurationBinder configurationBinder;
    protected StringBuilder debugLog;
    protected Function<String, String> stringSubstitutionStrategy = Function.identity();
    protected Cfg configuration;
    protected Node node;

    @Override
    public ConfigurationInjector<Ann, Cfg> withAnnotation(Ann annotation) {
        this.annotation = (Annotation)Objects.requireNonNull(annotation);
        return this;
    }

    @Override
    public ConfigurationInjector<Ann, Cfg> withAnnotatedElement(AnnotatedElement element) {
        this.annotatedElement = Objects.requireNonNull(element);
        this.withName(AnnotatedElementNameProvider.getName(element));
        PluginAliases aliases = element.getAnnotation(PluginAliases.class);
        if (aliases != null) {
            this.withAliases(aliases.value());
        }
        return this;
    }

    @Override
    public ConfigurationInjector<Ann, Cfg> withConversionType(Type type) {
        this.conversionType = Objects.requireNonNull(type);
        return this;
    }

    @Override
    public ConfigurationInjector<Ann, Cfg> withName(String name) {
        this.name = Objects.requireNonNull(name);
        return this;
    }

    @Override
    public ConfigurationInjector<Ann, Cfg> withAliases(String ... aliases) {
        this.aliases = Arrays.asList(aliases);
        return this;
    }

    @Override
    public ConfigurationInjector<Ann, Cfg> withConfigurationBinder(ConfigurationBinder binder) {
        this.configurationBinder = binder;
        return this;
    }

    @Override
    public ConfigurationInjector<Ann, Cfg> withDebugLog(StringBuilder debugLog) {
        this.debugLog = Objects.requireNonNull(debugLog);
        return this;
    }

    @Override
    public ConfigurationInjector<Ann, Cfg> withStringSubstitutionStrategy(Function<String, String> strategy) {
        this.stringSubstitutionStrategy = Objects.requireNonNull(strategy);
        return this;
    }

    @Override
    public ConfigurationInjector<Ann, Cfg> withConfiguration(Cfg configuration) {
        this.configuration = Objects.requireNonNull(configuration);
        return this;
    }

    @Override
    public ConfigurationInjector<Ann, Cfg> withNode(Node node) {
        this.node = Objects.requireNonNull(node);
        return this;
    }

    protected Optional<String> findAndRemoveNodeAttribute() {
        Objects.requireNonNull(this.node);
        Objects.requireNonNull(this.name);
        Map<String, String> attributes = this.node.getAttributes();
        for (String key : attributes.keySet()) {
            if (key.equalsIgnoreCase(this.name)) {
                return Optional.ofNullable(attributes.remove(key));
            }
            for (String alias : this.aliases) {
                if (!key.equalsIgnoreCase(alias)) continue;
                return Optional.ofNullable(attributes.remove(key));
            }
        }
        return Optional.empty();
    }
}

