/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.inject;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.function.Function;
import org.apache.logging.log4j.plugins.Node;
import org.apache.logging.log4j.plugins.bind.ConfigurationBinder;
import org.apache.logging.log4j.plugins.inject.InjectorStrategy;
import org.apache.logging.log4j.util.ReflectionUtil;

public interface ConfigurationInjector<Ann extends Annotation, Cfg> {
    public static <Cfg> Optional<ConfigurationInjector<Annotation, Cfg>> forAnnotatedElement(AnnotatedElement element) {
        for (Annotation annotation : element.getAnnotations()) {
            InjectorStrategy strategy = annotation.annotationType().getAnnotation(InjectorStrategy.class);
            if (strategy == null) continue;
            ConfigurationInjector injector = (ConfigurationInjector)ReflectionUtil.instantiate(strategy.value());
            return Optional.of(injector.withAnnotatedElement(element).withAnnotation(annotation));
        }
        return Optional.empty();
    }

    public ConfigurationInjector<Ann, Cfg> withAnnotation(Ann var1);

    public ConfigurationInjector<Ann, Cfg> withAnnotatedElement(AnnotatedElement var1);

    public ConfigurationInjector<Ann, Cfg> withConversionType(Type var1);

    public ConfigurationInjector<Ann, Cfg> withName(String var1);

    public ConfigurationInjector<Ann, Cfg> withAliases(String ... var1);

    public ConfigurationInjector<Ann, Cfg> withConfigurationBinder(ConfigurationBinder var1);

    public ConfigurationInjector<Ann, Cfg> withDebugLog(StringBuilder var1);

    public ConfigurationInjector<Ann, Cfg> withStringSubstitutionStrategy(Function<String, String> var1);

    public ConfigurationInjector<Ann, Cfg> withConfiguration(Cfg var1);

    public ConfigurationInjector<Ann, Cfg> withNode(Node var1);

    public void inject(Object var1);
}

