/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping.term;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.grouping.AbstractAllGroupHeadsCollector;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.SentinelIntSet;

public abstract class TermAllGroupHeadsCollector<GH extends AbstractAllGroupHeadsCollector.GroupHead<?>>
extends AbstractAllGroupHeadsCollector<GH> {
    private static final int DEFAULT_INITIAL_SIZE = 128;
    final String groupField;
    final BytesRef scratchBytesRef = new BytesRef();
    FieldCache.DocTermsIndex groupIndex;
    AtomicReaderContext readerContext;

    protected TermAllGroupHeadsCollector(String groupField, int numberOfSorts) {
        super(numberOfSorts);
        this.groupField = groupField;
    }

    public static AbstractAllGroupHeadsCollector<?> create(String groupField, Sort sortWithinGroup) {
        return TermAllGroupHeadsCollector.create(groupField, sortWithinGroup, 128);
    }

    public static AbstractAllGroupHeadsCollector<?> create(String groupField, Sort sortWithinGroup, int initialSize) {
        boolean sortAllScore = true;
        boolean sortAllFieldValue = true;
        for (SortField sortField : sortWithinGroup.getSort()) {
            if (sortField.getType() == SortField.Type.SCORE) {
                sortAllFieldValue = false;
                continue;
            }
            if (TermAllGroupHeadsCollector.needGeneralImpl(sortField)) {
                return new GeneralAllGroupHeadsCollector(groupField, sortWithinGroup);
            }
            sortAllScore = false;
        }
        if (sortAllScore) {
            return new ScoreAllGroupHeadsCollector(groupField, sortWithinGroup, initialSize);
        }
        if (sortAllFieldValue) {
            return new OrdAllGroupHeadsCollector(groupField, sortWithinGroup, initialSize);
        }
        return new OrdScoreAllGroupHeadsCollector(groupField, sortWithinGroup, initialSize);
    }

    private static boolean needGeneralImpl(SortField sortField) {
        SortField.Type sortType = sortField.getType();
        return sortType != SortField.Type.STRING_VAL && sortType != SortField.Type.STRING && sortType != SortField.Type.SCORE;
    }

    static class ScoreAllGroupHeadsCollector
    extends TermAllGroupHeadsCollector<GroupHead> {
        private final SentinelIntSet ordSet;
        private final List<GroupHead> collectedGroups;
        private final SortField[] fields;
        private Scorer scorer;
        private GroupHead[] segmentGroupHeads;

        ScoreAllGroupHeadsCollector(String groupField, Sort sortWithinGroup, int initialSize) {
            super(groupField, sortWithinGroup.getSort().length);
            this.ordSet = new SentinelIntSet(initialSize, -1);
            this.collectedGroups = new ArrayList<GroupHead>(initialSize);
            SortField[] sortFields = sortWithinGroup.getSort();
            this.fields = new SortField[sortFields.length];
            for (int i = 0; i < sortFields.length; ++i) {
                this.reversed[i] = sortFields[i].getReverse() ? -1 : 1;
                this.fields[i] = sortFields[i];
            }
        }

        @Override
        protected Collection<GroupHead> getCollectedGroupHeads() {
            return this.collectedGroups;
        }

        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
        }

        @Override
        protected void retrieveGroupHeadAndAddIfNotExist(int doc) throws IOException {
            GroupHead groupHead;
            int key = this.groupIndex.getOrd(doc);
            if (!this.ordSet.exists(key)) {
                this.ordSet.put(key);
                BytesRef term = key == 0 ? null : this.groupIndex.getTerm(doc, new BytesRef());
                groupHead = new GroupHead(doc, term);
                this.collectedGroups.add(groupHead);
                this.segmentGroupHeads[key] = groupHead;
                this.temporalResult.stop = true;
            } else {
                this.temporalResult.stop = false;
                groupHead = this.segmentGroupHeads[key];
            }
            this.temporalResult.groupHead = groupHead;
        }

        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.readerContext = context;
            this.groupIndex = FieldCache.DEFAULT.getTermsIndex(context.reader(), this.groupField);
            this.ordSet.clear();
            this.segmentGroupHeads = new GroupHead[this.groupIndex.numOrd()];
            for (GroupHead collectedGroup : this.collectedGroups) {
                int ord = this.groupIndex.binarySearchLookup((BytesRef)collectedGroup.groupValue, this.scratchBytesRef);
                if (ord < 0) continue;
                this.ordSet.put(ord);
                this.segmentGroupHeads[ord] = collectedGroup;
            }
        }

        class GroupHead
        extends AbstractAllGroupHeadsCollector.GroupHead<BytesRef> {
            float[] scores;

            private GroupHead(int doc, BytesRef groupValue) throws IOException {
                super(groupValue, doc + ScoreAllGroupHeadsCollector.this.readerContext.docBase);
                this.scores = new float[ScoreAllGroupHeadsCollector.this.fields.length];
                float score = ScoreAllGroupHeadsCollector.this.scorer.score();
                for (int i = 0; i < this.scores.length; ++i) {
                    this.scores[i] = score;
                }
            }

            @Override
            public int compare(int compIDX, int doc) throws IOException {
                float score = ScoreAllGroupHeadsCollector.this.scorer.score();
                if (this.scores[compIDX] < score) {
                    return 1;
                }
                if (this.scores[compIDX] > score) {
                    return -1;
                }
                return 0;
            }

            @Override
            public void updateDocHead(int doc) throws IOException {
                float score = ScoreAllGroupHeadsCollector.this.scorer.score();
                for (int i = 0; i < this.scores.length; ++i) {
                    this.scores[i] = score;
                }
                this.doc = doc + ScoreAllGroupHeadsCollector.this.readerContext.docBase;
            }
        }
    }

    static class OrdAllGroupHeadsCollector
    extends TermAllGroupHeadsCollector<GroupHead> {
        private final SentinelIntSet ordSet;
        private final List<GroupHead> collectedGroups;
        private final SortField[] fields;
        private FieldCache.DocTermsIndex[] sortsIndex;
        private GroupHead[] segmentGroupHeads;

        OrdAllGroupHeadsCollector(String groupField, Sort sortWithinGroup, int initialSize) {
            super(groupField, sortWithinGroup.getSort().length);
            this.ordSet = new SentinelIntSet(initialSize, -1);
            this.collectedGroups = new ArrayList<GroupHead>(initialSize);
            SortField[] sortFields = sortWithinGroup.getSort();
            this.fields = new SortField[sortFields.length];
            this.sortsIndex = new FieldCache.DocTermsIndex[sortFields.length];
            for (int i = 0; i < sortFields.length; ++i) {
                this.reversed[i] = sortFields[i].getReverse() ? -1 : 1;
                this.fields[i] = sortFields[i];
            }
        }

        @Override
        protected Collection<GroupHead> getCollectedGroupHeads() {
            return this.collectedGroups;
        }

        public void setScorer(Scorer scorer) throws IOException {
        }

        @Override
        protected void retrieveGroupHeadAndAddIfNotExist(int doc) throws IOException {
            GroupHead groupHead;
            int key = this.groupIndex.getOrd(doc);
            if (!this.ordSet.exists(key)) {
                this.ordSet.put(key);
                BytesRef term = key == 0 ? null : this.groupIndex.getTerm(doc, new BytesRef());
                groupHead = new GroupHead(doc, term);
                this.collectedGroups.add(groupHead);
                this.segmentGroupHeads[key] = groupHead;
                this.temporalResult.stop = true;
            } else {
                this.temporalResult.stop = false;
                groupHead = this.segmentGroupHeads[key];
            }
            this.temporalResult.groupHead = groupHead;
        }

        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.readerContext = context;
            this.groupIndex = FieldCache.DEFAULT.getTermsIndex(context.reader(), this.groupField);
            for (int i = 0; i < this.fields.length; ++i) {
                this.sortsIndex[i] = FieldCache.DEFAULT.getTermsIndex(context.reader(), this.fields[i].getField());
            }
            this.ordSet.clear();
            this.segmentGroupHeads = new GroupHead[this.groupIndex.numOrd()];
            for (GroupHead collectedGroup : this.collectedGroups) {
                int groupOrd = this.groupIndex.binarySearchLookup((BytesRef)collectedGroup.groupValue, this.scratchBytesRef);
                if (groupOrd < 0) continue;
                this.ordSet.put(groupOrd);
                this.segmentGroupHeads[groupOrd] = collectedGroup;
                for (int i = 0; i < this.sortsIndex.length; ++i) {
                    collectedGroup.sortOrds[i] = this.sortsIndex[i].binarySearchLookup(collectedGroup.sortValues[i], this.scratchBytesRef);
                }
            }
        }

        class GroupHead
        extends AbstractAllGroupHeadsCollector.GroupHead<BytesRef> {
            BytesRef[] sortValues;
            int[] sortOrds;

            private GroupHead(int doc, BytesRef groupValue) {
                super(groupValue, doc + OrdAllGroupHeadsCollector.this.readerContext.docBase);
                this.sortValues = new BytesRef[OrdAllGroupHeadsCollector.this.sortsIndex.length];
                this.sortOrds = new int[OrdAllGroupHeadsCollector.this.sortsIndex.length];
                for (int i = 0; i < OrdAllGroupHeadsCollector.this.sortsIndex.length; ++i) {
                    this.sortValues[i] = OrdAllGroupHeadsCollector.this.sortsIndex[i].getTerm(doc, new BytesRef());
                    this.sortOrds[i] = OrdAllGroupHeadsCollector.this.sortsIndex[i].getOrd(doc);
                }
            }

            @Override
            public int compare(int compIDX, int doc) throws IOException {
                if (this.sortOrds[compIDX] < 0) {
                    return this.sortValues[compIDX].compareTo(OrdAllGroupHeadsCollector.this.sortsIndex[compIDX].getTerm(doc, OrdAllGroupHeadsCollector.this.scratchBytesRef));
                }
                return this.sortOrds[compIDX] - OrdAllGroupHeadsCollector.this.sortsIndex[compIDX].getOrd(doc);
            }

            @Override
            public void updateDocHead(int doc) throws IOException {
                for (int i = 0; i < OrdAllGroupHeadsCollector.this.sortsIndex.length; ++i) {
                    this.sortValues[i] = OrdAllGroupHeadsCollector.this.sortsIndex[i].getTerm(doc, this.sortValues[i]);
                    this.sortOrds[i] = OrdAllGroupHeadsCollector.this.sortsIndex[i].getOrd(doc);
                }
                this.doc = doc + OrdAllGroupHeadsCollector.this.readerContext.docBase;
            }
        }
    }

    static class OrdScoreAllGroupHeadsCollector
    extends TermAllGroupHeadsCollector<GroupHead> {
        private final SentinelIntSet ordSet;
        private final List<GroupHead> collectedGroups;
        private final SortField[] fields;
        private FieldCache.DocTermsIndex[] sortsIndex;
        private Scorer scorer;
        private GroupHead[] segmentGroupHeads;

        OrdScoreAllGroupHeadsCollector(String groupField, Sort sortWithinGroup, int initialSize) {
            super(groupField, sortWithinGroup.getSort().length);
            this.ordSet = new SentinelIntSet(initialSize, -1);
            this.collectedGroups = new ArrayList<GroupHead>(initialSize);
            SortField[] sortFields = sortWithinGroup.getSort();
            this.fields = new SortField[sortFields.length];
            this.sortsIndex = new FieldCache.DocTermsIndex[sortFields.length];
            for (int i = 0; i < sortFields.length; ++i) {
                this.reversed[i] = sortFields[i].getReverse() ? -1 : 1;
                this.fields[i] = sortFields[i];
            }
        }

        @Override
        protected Collection<GroupHead> getCollectedGroupHeads() {
            return this.collectedGroups;
        }

        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
        }

        @Override
        protected void retrieveGroupHeadAndAddIfNotExist(int doc) throws IOException {
            GroupHead groupHead;
            int key = this.groupIndex.getOrd(doc);
            if (!this.ordSet.exists(key)) {
                this.ordSet.put(key);
                BytesRef term = key == 0 ? null : this.groupIndex.getTerm(doc, new BytesRef());
                groupHead = new GroupHead(doc, term);
                this.collectedGroups.add(groupHead);
                this.segmentGroupHeads[key] = groupHead;
                this.temporalResult.stop = true;
            } else {
                this.temporalResult.stop = false;
                groupHead = this.segmentGroupHeads[key];
            }
            this.temporalResult.groupHead = groupHead;
        }

        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.readerContext = context;
            this.groupIndex = FieldCache.DEFAULT.getTermsIndex(context.reader(), this.groupField);
            for (int i = 0; i < this.fields.length; ++i) {
                if (this.fields[i].getType() == SortField.Type.SCORE) continue;
                this.sortsIndex[i] = FieldCache.DEFAULT.getTermsIndex(context.reader(), this.fields[i].getField());
            }
            this.ordSet.clear();
            this.segmentGroupHeads = new GroupHead[this.groupIndex.numOrd()];
            for (GroupHead collectedGroup : this.collectedGroups) {
                int ord = this.groupIndex.binarySearchLookup((BytesRef)collectedGroup.groupValue, this.scratchBytesRef);
                if (ord < 0) continue;
                this.ordSet.put(ord);
                this.segmentGroupHeads[ord] = collectedGroup;
                for (int i = 0; i < this.sortsIndex.length; ++i) {
                    if (this.fields[i].getType() == SortField.Type.SCORE) continue;
                    collectedGroup.sortOrds[i] = this.sortsIndex[i].binarySearchLookup(collectedGroup.sortValues[i], this.scratchBytesRef);
                }
            }
        }

        class GroupHead
        extends AbstractAllGroupHeadsCollector.GroupHead<BytesRef> {
            BytesRef[] sortValues;
            int[] sortOrds;
            float[] scores;

            private GroupHead(int doc, BytesRef groupValue) throws IOException {
                super(groupValue, doc + OrdScoreAllGroupHeadsCollector.this.readerContext.docBase);
                this.sortValues = new BytesRef[OrdScoreAllGroupHeadsCollector.this.sortsIndex.length];
                this.sortOrds = new int[OrdScoreAllGroupHeadsCollector.this.sortsIndex.length];
                this.scores = new float[OrdScoreAllGroupHeadsCollector.this.sortsIndex.length];
                for (int i = 0; i < OrdScoreAllGroupHeadsCollector.this.sortsIndex.length; ++i) {
                    if (OrdScoreAllGroupHeadsCollector.this.fields[i].getType() == SortField.Type.SCORE) {
                        this.scores[i] = OrdScoreAllGroupHeadsCollector.this.scorer.score();
                        continue;
                    }
                    this.sortValues[i] = OrdScoreAllGroupHeadsCollector.this.sortsIndex[i].getTerm(doc, new BytesRef());
                    this.sortOrds[i] = OrdScoreAllGroupHeadsCollector.this.sortsIndex[i].getOrd(doc);
                }
            }

            @Override
            public int compare(int compIDX, int doc) throws IOException {
                if (OrdScoreAllGroupHeadsCollector.this.fields[compIDX].getType() == SortField.Type.SCORE) {
                    float score = OrdScoreAllGroupHeadsCollector.this.scorer.score();
                    if (this.scores[compIDX] < score) {
                        return 1;
                    }
                    if (this.scores[compIDX] > score) {
                        return -1;
                    }
                    return 0;
                }
                if (this.sortOrds[compIDX] < 0) {
                    return this.sortValues[compIDX].compareTo(OrdScoreAllGroupHeadsCollector.this.sortsIndex[compIDX].getTerm(doc, OrdScoreAllGroupHeadsCollector.this.scratchBytesRef));
                }
                return this.sortOrds[compIDX] - OrdScoreAllGroupHeadsCollector.this.sortsIndex[compIDX].getOrd(doc);
            }

            @Override
            public void updateDocHead(int doc) throws IOException {
                for (int i = 0; i < OrdScoreAllGroupHeadsCollector.this.sortsIndex.length; ++i) {
                    if (OrdScoreAllGroupHeadsCollector.this.fields[i].getType() == SortField.Type.SCORE) {
                        this.scores[i] = OrdScoreAllGroupHeadsCollector.this.scorer.score();
                        continue;
                    }
                    this.sortValues[i] = OrdScoreAllGroupHeadsCollector.this.sortsIndex[i].getTerm(doc, this.sortValues[i]);
                    this.sortOrds[i] = OrdScoreAllGroupHeadsCollector.this.sortsIndex[i].getOrd(doc);
                }
                this.doc = doc + OrdScoreAllGroupHeadsCollector.this.readerContext.docBase;
            }
        }
    }

    static class GeneralAllGroupHeadsCollector
    extends TermAllGroupHeadsCollector<GroupHead> {
        private final Sort sortWithinGroup;
        private final Map<BytesRef, GroupHead> groups;
        private Scorer scorer;

        GeneralAllGroupHeadsCollector(String groupField, Sort sortWithinGroup) {
            super(groupField, sortWithinGroup.getSort().length);
            this.sortWithinGroup = sortWithinGroup;
            this.groups = new HashMap<BytesRef, GroupHead>();
            SortField[] sortFields = sortWithinGroup.getSort();
            for (int i = 0; i < sortFields.length; ++i) {
                this.reversed[i] = sortFields[i].getReverse() ? -1 : 1;
            }
        }

        @Override
        protected void retrieveGroupHeadAndAddIfNotExist(int doc) throws IOException {
            int ord = this.groupIndex.getOrd(doc);
            BytesRef groupValue = ord == 0 ? null : this.groupIndex.lookup(ord, this.scratchBytesRef);
            GroupHead groupHead = this.groups.get(groupValue);
            if (groupHead == null) {
                groupHead = new GroupHead(groupValue, this.sortWithinGroup, doc);
                this.groups.put(groupValue == null ? null : BytesRef.deepCopyOf((BytesRef)groupValue), groupHead);
                this.temporalResult.stop = true;
            } else {
                this.temporalResult.stop = false;
            }
            this.temporalResult.groupHead = groupHead;
        }

        @Override
        protected Collection<GroupHead> getCollectedGroupHeads() {
            return this.groups.values();
        }

        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.readerContext = context;
            this.groupIndex = FieldCache.DEFAULT.getTermsIndex(context.reader(), this.groupField);
            for (GroupHead groupHead : this.groups.values()) {
                for (int i = 0; i < groupHead.comparators.length; ++i) {
                    groupHead.comparators[i] = groupHead.comparators[i].setNextReader(context);
                }
            }
        }

        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
            for (GroupHead groupHead : this.groups.values()) {
                for (FieldComparator<?> comparator : groupHead.comparators) {
                    comparator.setScorer(scorer);
                }
            }
        }

        class GroupHead
        extends AbstractAllGroupHeadsCollector.GroupHead<BytesRef> {
            final FieldComparator<?>[] comparators;

            private GroupHead(BytesRef groupValue, Sort sort, int doc) throws IOException {
                super(groupValue, doc + GeneralAllGroupHeadsCollector.this.readerContext.docBase);
                SortField[] sortFields = sort.getSort();
                this.comparators = new FieldComparator[sortFields.length];
                for (int i = 0; i < sortFields.length; ++i) {
                    this.comparators[i] = sortFields[i].getComparator(1, i).setNextReader(GeneralAllGroupHeadsCollector.this.readerContext);
                    this.comparators[i].setScorer(GeneralAllGroupHeadsCollector.this.scorer);
                    this.comparators[i].copy(0, doc);
                    this.comparators[i].setBottom(0);
                }
            }

            @Override
            public int compare(int compIDX, int doc) throws IOException {
                return this.comparators[compIDX].compareBottom(doc);
            }

            @Override
            public void updateDocHead(int doc) throws IOException {
                for (FieldComparator<?> comparator : this.comparators) {
                    comparator.copy(0, doc);
                    comparator.setBottom(0);
                }
                this.doc = doc + GeneralAllGroupHeadsCollector.this.readerContext.docBase;
            }
        }
    }
}

