/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function.valuesource;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.docvalues.DocTermsIndexDocValues;
import org.apache.lucene.queries.function.valuesource.FieldCacheSource;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.mutable.MutableValue;
import org.apache.lucene.util.mutable.MutableValueStr;

public class BytesRefFieldSource
extends FieldCacheSource {
    public BytesRefFieldSource(String field) {
        super(field);
    }

    @Override
    public FunctionValues getValues(Map context, AtomicReaderContext readerContext) throws IOException {
        FieldInfo fieldInfo = readerContext.reader().getFieldInfos().fieldInfo(this.field);
        if (fieldInfo != null && fieldInfo.getDocValuesType() == FieldInfo.DocValuesType.BINARY) {
            final BinaryDocValues binaryValues = DocValues.getBinary((AtomicReader)readerContext.reader(), (String)this.field);
            final Bits docsWithField = DocValues.getDocsWithField((AtomicReader)readerContext.reader(), (String)this.field);
            return new FunctionValues(){

                @Override
                public boolean exists(int doc) {
                    return docsWithField.get(doc);
                }

                @Override
                public boolean bytesVal(int doc, BytesRefBuilder target) {
                    target.copyBytes(binaryValues.get(doc));
                    return target.length() > 0;
                }

                @Override
                public String strVal(int doc) {
                    BytesRefBuilder bytes = new BytesRefBuilder();
                    return this.bytesVal(doc, bytes) ? bytes.get().utf8ToString() : null;
                }

                @Override
                public Object objectVal(int doc) {
                    return this.strVal(doc);
                }

                @Override
                public String toString(int doc) {
                    return BytesRefFieldSource.this.description() + '=' + this.strVal(doc);
                }

                @Override
                public FunctionValues.ValueFiller getValueFiller() {
                    return new FunctionValues.ValueFiller(){
                        private final MutableValueStr mval = new MutableValueStr();

                        @Override
                        public MutableValue getValue() {
                            return this.mval;
                        }

                        @Override
                        public void fillValue(int doc) {
                            this.mval.exists = docsWithField.get(doc);
                            this.mval.value.clear();
                            this.mval.value.copyBytes(binaryValues.get(doc));
                        }
                    };
                }
            };
        }
        return new DocTermsIndexDocValues(this, readerContext, this.field){

            @Override
            protected String toTerm(String readableValue) {
                return readableValue;
            }

            @Override
            public Object objectVal(int doc) {
                return this.strVal(doc);
            }

            @Override
            public String toString(int doc) {
                return BytesRefFieldSource.this.description() + '=' + this.strVal(doc);
            }
        };
    }
}

