/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function.valuesource;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.docvalues.DoubleDocValues;
import org.apache.lucene.queries.function.valuesource.FieldCacheSource;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.mutable.MutableValue;
import org.apache.lucene.util.mutable.MutableValueDouble;

public class DoubleFieldSource
extends FieldCacheSource {
    public DoubleFieldSource(String field) {
        super(field);
    }

    @Override
    public String description() {
        return "double(" + this.field + ')';
    }

    @Override
    public FunctionValues getValues(Map context, AtomicReaderContext readerContext) throws IOException {
        final NumericDocValues arr = DocValues.getNumeric((AtomicReader)readerContext.reader(), (String)this.field);
        final Bits valid = DocValues.getDocsWithField((AtomicReader)readerContext.reader(), (String)this.field);
        return new DoubleDocValues(this){

            @Override
            public double doubleVal(int doc) {
                return Double.longBitsToDouble(arr.get(doc));
            }

            @Override
            public boolean exists(int doc) {
                return arr.get(doc) != 0L || valid.get(doc);
            }

            @Override
            public FunctionValues.ValueFiller getValueFiller() {
                return new FunctionValues.ValueFiller(){
                    private final MutableValueDouble mval = new MutableValueDouble();

                    @Override
                    public MutableValue getValue() {
                        return this.mval;
                    }

                    @Override
                    public void fillValue(int doc) {
                        this.mval.value = this.doubleVal(doc);
                        this.mval.exists = this.mval.value != 0.0 || valid.get(doc);
                    }
                };
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (o.getClass() != DoubleFieldSource.class) {
            return false;
        }
        DoubleFieldSource other = (DoubleFieldSource)o;
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        int h = Double.class.hashCode();
        return h += super.hashCode();
    }
}

