/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.utils;

import java.io.IOException;
import java.io.Serializable;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.MultipleOutputs;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.iterator.sequencefile.PathFilters;
import org.apache.mahout.common.iterator.sequencefile.PathType;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileDirIterator;

public final class SplitInputJob {
    private static final String DOWNSAMPLING_FACTOR = "SplitInputJob.downsamplingFactor";
    private static final String RANDOM_SELECTION_PCT = "SplitInputJob.randomSelectionPct";
    private static final String TRAINING_TAG = "training";
    private static final String TEST_TAG = "test";

    private SplitInputJob() {
    }

    public static void run(Configuration initialConf, Path inputPath, Path outputPath, int keepPct, float randomSelectionPercent) throws IOException, ClassNotFoundException, InterruptedException {
        int downsamplingFactor = (int)(100.0 / (double)keepPct);
        initialConf.setInt(DOWNSAMPLING_FACTOR, downsamplingFactor);
        initialConf.setFloat(RANDOM_SELECTION_PCT, randomSelectionPercent);
        FileSystem fs = FileSystem.get((Configuration)initialConf);
        SequenceFileDirIterator iterator = new SequenceFileDirIterator(inputPath, PathType.LIST, PathFilters.partFilter(), null, false, fs.getConf());
        if (!iterator.hasNext()) {
            throw new IllegalStateException("Couldn't determine class of the input values");
        }
        Pair pair = (Pair)iterator.next();
        Class<?> keyClass = ((WritableComparable)pair.getFirst()).getClass();
        Class<?> valueClass = ((Writable)pair.getSecond()).getClass();
        Job job = new Job(new Configuration(initialConf));
        MultipleOutputs.addNamedOutput((Job)job, (String)TRAINING_TAG, SequenceFileOutputFormat.class, keyClass, valueClass);
        MultipleOutputs.addNamedOutput((Job)job, (String)TEST_TAG, SequenceFileOutputFormat.class, keyClass, valueClass);
        job.setJarByClass(SplitInputJob.class);
        FileInputFormat.addInputPath((Job)job, (Path)inputPath);
        FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
        job.setNumReduceTasks(1);
        job.setInputFormatClass(SequenceFileInputFormat.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        job.setMapperClass(SplitInputMapper.class);
        job.setReducerClass(SplitInputReducer.class);
        job.setSortComparatorClass(SplitInputComparator.class);
        job.setOutputKeyClass(keyClass);
        job.setOutputValueClass(valueClass);
        job.submit();
        boolean succeeded = job.waitForCompletion(true);
        if (!succeeded) {
            throw new IllegalStateException("Job failed!");
        }
    }

    public static class SplitInputComparator
    extends WritableComparator
    implements Serializable {
        private final Random rnd = RandomUtils.getRandom();

        protected SplitInputComparator() {
            super(WritableComparable.class);
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            if (this.rnd.nextBoolean()) {
                return 1;
            }
            return -1;
        }
    }

    public static class SplitInputReducer
    extends Reducer<WritableComparable<?>, Writable, WritableComparable<?>, Writable> {
        private MultipleOutputs multipleOutputs;
        private final Random rnd = RandomUtils.getRandom();
        private float randomSelectionPercent;

        protected void setup(Reducer.Context ctx) throws IOException {
            this.randomSelectionPercent = ctx.getConfiguration().getFloat(SplitInputJob.RANDOM_SELECTION_PCT, 0.0f);
            this.multipleOutputs = new MultipleOutputs((TaskInputOutputContext)ctx);
        }

        protected void reduce(WritableComparable<?> key, Iterable<Writable> values, Reducer.Context context) throws IOException, InterruptedException {
            for (Writable value : values) {
                if ((float)this.rnd.nextInt(100) < this.randomSelectionPercent) {
                    this.multipleOutputs.write(SplitInputJob.TEST_TAG, key, (Object)value);
                    continue;
                }
                this.multipleOutputs.write(SplitInputJob.TRAINING_TAG, key, (Object)value);
            }
        }

        protected void cleanup(Reducer.Context context) throws IOException {
            try {
                this.multipleOutputs.close();
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }
    }

    public static class SplitInputMapper
    extends Mapper<WritableComparable<?>, Writable, WritableComparable<?>, Writable> {
        private int downsamplingFactor;

        public void setup(Mapper.Context ctx) {
            this.downsamplingFactor = ctx.getConfiguration().getInt(SplitInputJob.DOWNSAMPLING_FACTOR, 1);
        }

        public void run(Mapper.Context context) throws IOException, InterruptedException {
            this.setup(context);
            int i = 0;
            while (context.nextKeyValue()) {
                if (i % this.downsamplingFactor == 0) {
                    this.map(context.getCurrentKey(), context.getCurrentValue(), context);
                }
                ++i;
            }
            this.cleanup(context);
        }
    }
}

