/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import java.util.Iterator;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.DiagonalMatrix;
import org.apache.mahout.math.MahoutTestCase;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.function.Functions;
import org.junit.Assert;
import org.junit.Test;

public class DiagonalMatrixTest
extends MahoutTestCase {
    @Test
    public void testBasics() {
        DiagonalMatrix a = new DiagonalMatrix(new double[]{1.0, 2.0, 3.0, 4.0});
        DiagonalMatrixTest.assertEquals((double)0.0, (double)a.viewDiagonal().minus((Vector)new DenseVector(new double[]{1.0, 2.0, 3.0, 4.0})).norm(1.0), (double)1.0E-10);
        DiagonalMatrixTest.assertEquals((double)0.0, (double)a.viewPart(0, 3, 0, 3).viewDiagonal().minus((Vector)new DenseVector(new double[]{1.0, 2.0, 3.0})).norm(1.0), (double)1.0E-10);
        DiagonalMatrixTest.assertEquals((double)4.0, (double)a.get(3, 3), (double)1.0E-10);
        DenseMatrix m = new DenseMatrix(4, 4);
        m.assign((Matrix)a);
        DiagonalMatrixTest.assertEquals((double)0.0, (double)m.minus((Matrix)a).aggregate(Functions.PLUS, Functions.ABS), (double)1.0E-10);
        DiagonalMatrixTest.assertEquals((double)0.0, (double)m.transpose().times((Matrix)m).minus(a.transpose().times((Matrix)a)).aggregate(Functions.PLUS, Functions.ABS), (double)1.0E-10);
        DiagonalMatrixTest.assertEquals((double)0.0, (double)m.plus((Matrix)m).minus(a.plus((Matrix)a)).aggregate(Functions.PLUS, Functions.ABS), (double)1.0E-10);
        m = new DenseMatrix((double[][])new double[][]{{1.0, 2.0, 3.0, 4.0}, {5.0, 6.0, 7.0, 8.0}});
        DiagonalMatrixTest.assertEquals((double)100.0, (double)a.timesLeft((Matrix)m).aggregate(Functions.PLUS, Functions.ABS), (double)1.0E-10);
        DiagonalMatrixTest.assertEquals((double)100.0, (double)a.times(m.transpose()).aggregate(Functions.PLUS, Functions.ABS), (double)1.0E-10);
    }

    @Test
    public void testSparsity() {
        DenseVector d = new DenseVector(10);
        for (int i = 0; i < 10; ++i) {
            d.set(i, (double)(i * i));
        }
        DiagonalMatrix m = new DiagonalMatrix((Vector)d);
        Assert.assertFalse((boolean)m.viewRow(0).isDense());
        Assert.assertFalse((boolean)m.viewColumn(0).isDense());
        for (int i = 0; i < 10; ++i) {
            DiagonalMatrixTest.assertEquals((double)(i * i), (double)m.viewRow(i).zSum(), (double)0.0);
            DiagonalMatrixTest.assertEquals((double)(i * i), (double)m.viewRow(i).get(i), (double)0.0);
            DiagonalMatrixTest.assertEquals((double)(i * i), (double)m.viewColumn(i).zSum(), (double)0.0);
            DiagonalMatrixTest.assertEquals((double)(i * i), (double)m.viewColumn(i).get(i), (double)0.0);
        }
        Iterator ix = m.viewRow(7).nonZeroes().iterator();
        DiagonalMatrixTest.assertTrue((boolean)ix.hasNext());
        Vector.Element r = (Vector.Element)ix.next();
        DiagonalMatrixTest.assertEquals((long)7L, (long)r.index());
        DiagonalMatrixTest.assertEquals((double)49.0, (double)r.get(), (double)0.0);
        DiagonalMatrixTest.assertFalse((boolean)ix.hasNext());
        DiagonalMatrixTest.assertEquals((double)0.0, (double)m.viewRow(5).get(3), (double)0.0);
        DiagonalMatrixTest.assertEquals((double)0.0, (double)m.viewColumn(8).get(3), (double)0.0);
        m.viewRow(3).set(3, 1.0);
        DiagonalMatrixTest.assertEquals((double)1.0, (double)m.get(3, 3), (double)0.0);
        for (Vector.Element element : m.viewRow(6).all()) {
            if (element.index() == 6) {
                DiagonalMatrixTest.assertEquals((double)36.0, (double)element.get(), (double)0.0);
                continue;
            }
            DiagonalMatrixTest.assertEquals((double)0.0, (double)element.get(), (double)0.0);
        }
    }
}

