/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.math.function.DoubleDoubleFunction;
import org.apache.mahout.math.function.Functions;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class FunctionTest {
    private static final int NUM_POINTS = 100;
    private final Random random = RandomUtils.getRandom();
    private DoubleDoubleFunction function;
    private String functionName;

    @Parameterized.Parameters
    public static Collection<Object[]> generateData() {
        ArrayList data = Lists.newArrayList();
        for (Field field : Functions.class.getDeclaredFields()) {
            if (!field.getType().isAssignableFrom(DoubleDoubleFunction.class) || !Modifier.isStatic(field.getModifiers()) || field.getName().equals("SECOND_LEFT_ZERO")) continue;
            try {
                data.add(new Object[]{field.get(null), field.getName()});
            }
            catch (IllegalAccessException e) {
                System.out.printf("Couldn't access Functions field %s\n", field.getName());
            }
        }
        return data;
    }

    public FunctionTest(DoubleDoubleFunction function, String functionName) {
        this.function = function;
        this.functionName = functionName;
    }

    @Test
    public void testIsLikeRightPlus() {
        if (!this.function.isLikeRightPlus()) {
            return;
        }
        for (int i = 0; i < 100; ++i) {
            double x = this.random.nextDouble();
            Assert.assertEquals((String)this.functionName, (double)x, (double)this.function.apply(x, 0.0), (double)0.0);
        }
    }

    @Test
    public void testIsLikeLeftMult() {
        if (!this.function.isLikeLeftMult()) {
            return;
        }
        for (int i = 0; i < 100; ++i) {
            double y = this.random.nextDouble();
            Assert.assertEquals((String)this.functionName, (double)0.0, (double)this.function.apply(0.0, y), (double)0.0);
        }
    }

    @Test
    public void testIsLikeRightMult() {
        if (!this.function.isLikeRightMult()) {
            return;
        }
        for (int i = 0; i < 100; ++i) {
            double x = this.random.nextDouble();
            Assert.assertEquals((String)this.functionName, (double)0.0, (double)this.function.apply(x, 0.0), (double)0.0);
        }
    }

    @Test
    public void testIsCommutative() {
        if (!this.function.isCommutative()) {
            return;
        }
        for (int i = 0; i < 100; ++i) {
            double x = this.random.nextDouble();
            double y = this.random.nextDouble();
            Assert.assertEquals((String)this.functionName, (double)this.function.apply(x, y), (double)this.function.apply(y, x), (double)1.0E-6);
        }
    }

    @Test
    public void testIsAssociative() {
        if (!this.function.isAssociative()) {
            return;
        }
        for (int i = 0; i < 100; ++i) {
            double x = this.random.nextDouble();
            double y = this.random.nextDouble();
            double z = this.random.nextDouble();
            Assert.assertEquals((String)this.functionName, (double)this.function.apply(x, this.function.apply(y, z)), (double)this.function.apply(this.function.apply(x, y), z), (double)1.0E-6);
        }
    }

    @Test
    public void testIsDensifying() {
        if (!this.function.isDensifying()) {
            Assert.assertEquals((String)this.functionName, (double)0.0, (double)this.function.apply(0.0, 0.0), (double)0.0);
        }
    }
}

