/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.MahoutTestCase;
import org.apache.mahout.math.Matrices;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.SparseMatrix;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.function.IntIntFunction;
import org.junit.Assert;
import org.junit.Test;

public class MatricesTest
extends MahoutTestCase {
    @Test
    public void testFunctionalView() {
        Matrix m = Matrices.functionalMatrixView((int)5, (int)6, (IntIntFunction)new IntIntFunction(){

            public double apply(int row, int col) {
                Assert.assertTrue((row < 5 ? 1 : 0) != 0);
                Assert.assertTrue((col < 6 ? 1 : 0) != 0);
                return row + col;
            }
        });
        MatricesTest.assertEquals((double)135.0, (double)m.aggregate(Functions.PLUS, Functions.IDENTITY), (double)1.0E-10);
    }

    @Test
    public void testTransposeView() {
        Matrix m = Matrices.gaussianView((int)5, (int)6, (long)1234L);
        Matrix controlM = new DenseMatrix(5, 6).assign(m);
        System.out.printf("M=\n%s\n", m);
        System.out.printf("controlM=\n%s\n", controlM);
        Matrix mtm = Matrices.transposedView((Matrix)m).times(m);
        Matrix controlMtm = controlM.transpose().times(controlM);
        System.out.printf("M'M=\n%s\n", mtm);
        Matrix diff = mtm.minus(controlMtm);
        MatricesTest.assertEquals((double)0.0, (double)diff.aggregate(Functions.PLUS, Functions.ABS), (double)1.0E-10);
    }

    @Test
    public void testViewDenseSparseReporting() {
        SparseMatrix m = new SparseMatrix(1000, 1000);
        m.set(1, 1, 33.0);
        Matrix mt = Matrices.transposedView((Matrix)m);
        MatricesTest.assertTrue((!mt.viewColumn(0).isDense() ? 1 : 0) != 0);
        MatricesTest.assertTrue((!mt.viewRow(0).isDense() ? 1 : 0) != 0);
        m = new DenseMatrix(10, 10);
        m.set(1, 1, 33.0);
        mt = Matrices.transposedView((Matrix)m);
        MatricesTest.assertTrue((boolean)mt.viewColumn(0).isDense());
        MatricesTest.assertTrue((boolean)mt.viewRow(0).isDense());
    }

    @Test
    public void testUniformView() {
        Matrix m1 = Matrices.uniformView((int)5, (int)6, (int)1234);
        Matrix m2 = Matrices.uniformView((int)5, (int)6, (int)1234);
        for (int row = 0; row < m1.numRows(); ++row) {
            for (int col = 0; col < m1.numCols(); ++col) {
                MatricesTest.assertTrue((m1.getQuick(row, col) >= 0.0 ? 1 : 0) != 0);
                MatricesTest.assertTrue((m1.getQuick(row, col) < 1.0 ? 1 : 0) != 0);
            }
        }
        Matrix diff = m1.minus(m2);
        MatricesTest.assertEquals((double)0.0, (double)diff.aggregate(Functions.PLUS, Functions.ABS), (double)1.0E-10);
    }

    @Test
    public void testSymmetricUniformView() {
        Matrix m1 = Matrices.symmetricUniformView((int)5, (int)6, (int)1234);
        Matrix m2 = Matrices.symmetricUniformView((int)5, (int)6, (int)1234);
        for (int row = 0; row < m1.numRows(); ++row) {
            for (int col = 0; col < m1.numCols(); ++col) {
                MatricesTest.assertTrue((m1.getQuick(row, col) >= -1.0 ? 1 : 0) != 0);
                MatricesTest.assertTrue((m1.getQuick(row, col) < 1.0 ? 1 : 0) != 0);
            }
        }
        Matrix diff = m1.minus(m2);
        MatricesTest.assertEquals((double)0.0, (double)diff.aggregate(Functions.PLUS, Functions.ABS), (double)1.0E-10);
    }

    @Test
    public void testGaussianView() {
        Matrix m1 = Matrices.gaussianView((int)5, (int)6, (long)1234L);
        Matrix m2 = Matrices.gaussianView((int)5, (int)6, (long)1234L);
        Matrix diff = m1.minus(m2);
        MatricesTest.assertEquals((double)0.0, (double)diff.aggregate(Functions.PLUS, Functions.ABS), (double)1.0E-10);
    }
}

