/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.RandomWrapper;
import org.apache.mahout.math.AbstractVectorTest;
import org.apache.mahout.math.SequentialAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.junit.Test;

public final class TestSequentialAccessSparseVector
extends AbstractVectorTest<SequentialAccessSparseVector> {
    @Override
    Vector generateTestVector(int cardinality) {
        return new SequentialAccessSparseVector(cardinality);
    }

    @Test
    public void testDotSuperBig() {
        SequentialAccessSparseVector w = new SequentialAccessSparseVector(Integer.MAX_VALUE, 12);
        w.set(1, 0.4);
        w.set(2, 0.4);
        w.set(3, -0.666666667);
        SequentialAccessSparseVector v = new SequentialAccessSparseVector(Integer.MAX_VALUE, 12);
        v.set(3, 1.0);
        TestSequentialAccessSparseVector.assertEquals((String)"super-big", (double)-0.666666667, (double)v.dot((Vector)w), (double)1.0E-6);
    }

    @Override
    public SequentialAccessSparseVector vectorToTest(int size) {
        SequentialAccessSparseVector r = new SequentialAccessSparseVector(size);
        RandomWrapper gen = RandomUtils.getRandom();
        for (int i = 0; i < 3; ++i) {
            r.set(gen.nextInt(r.size()), gen.nextGaussian());
        }
        return r;
    }

    @Override
    @Test
    public void testToString() {
        super.testToString();
    }
}

