/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.MahoutTestCase;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.UpperTriangular;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.function.Functions;
import org.junit.Test;

public class UpperTriangularTest
extends MahoutTestCase {
    @Test
    public void testBasics() {
        UpperTriangular a = new UpperTriangular(new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0}, false);
        UpperTriangularTest.assertEquals((double)0.0, (double)a.viewDiagonal().minus((Vector)new DenseVector(new double[]{1.0, 5.0, 8.0, 10.0})).norm(1.0), (double)1.0E-10);
        UpperTriangularTest.assertEquals((double)0.0, (double)a.viewPart(0, 3, 1, 3).viewDiagonal().minus((Vector)new DenseVector(new double[]{2.0, 6.0, 9.0})).norm(1.0), (double)1.0E-10);
        UpperTriangularTest.assertEquals((double)4.0, (double)a.get(0, 3), (double)1.0E-10);
        UpperTriangularTest.print((Matrix)a);
        Matrix m = new DenseMatrix(4, 4).assign((Matrix)a);
        UpperTriangularTest.assertEquals((double)0.0, (double)m.minus((Matrix)a).aggregate(Functions.PLUS, Functions.ABS), (double)1.0E-10);
        UpperTriangularTest.print(m);
        UpperTriangularTest.assertEquals((double)0.0, (double)m.transpose().times(m).minus(a.transpose().times((Matrix)a)).aggregate(Functions.PLUS, Functions.ABS), (double)1.0E-10);
        UpperTriangularTest.assertEquals((double)0.0, (double)m.plus(m).minus(a.plus((Matrix)a)).aggregate(Functions.PLUS, Functions.ABS), (double)1.0E-10);
    }

    private static void print(Matrix m) {
        for (int i = 0; i < m.rowSize(); ++i) {
            for (int j = 0; j < m.columnSize(); ++j) {
                if (Math.abs(m.get(i, j)) > 1.0E-10) {
                    System.out.printf("%10.3f ", m.get(i, j));
                    continue;
                }
                System.out.printf("%10s ", (i + j) % 3 == 0 ? "." : "");
            }
            System.out.printf("\n", new Object[0]);
        }
        System.out.printf("\n", new Object[0]);
    }
}

