/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import org.apache.mahout.math.AbstractVectorTest;
import org.apache.mahout.math.Centroid;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.QRDecomposition;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.WeightedVector;
import org.apache.mahout.math.WeightedVectorComparator;
import org.apache.mahout.math.function.Functions;
import org.junit.Test;

public class WeightedVectorTest
extends AbstractVectorTest {
    @Test
    public void testLength() {
        DenseVector v = new DenseVector(new double[]{0.9921337470551008, 1.0031004325833064, 0.9963963182745947});
        Centroid c = new Centroid(3, (Vector)new DenseVector((Vector)v), 2.0);
        WeightedVectorTest.assertEquals((double)c.getVector().getLengthSquared(), (double)c.getLengthSquared(), (double)1.0E-17);
        c.set(0, -1.0);
        System.out.printf("c = %.9f\nv = %.9f\n", c.getLengthSquared(), c.getVector().getLengthSquared());
        WeightedVectorTest.assertEquals((double)c.getVector().getLengthSquared(), (double)c.getLengthSquared(), (double)1.0E-17);
    }

    public Vector vectorToTest(int size) {
        return new WeightedVector((Vector)new DenseVector(size), 4.52, 345);
    }

    @Test
    public void testOrdering() {
        WeightedVector v1 = new WeightedVector((Vector)new DenseVector(new double[]{1.0, 2.0, 3.0}), 5.41, 31);
        WeightedVector v2 = new WeightedVector((Vector)new DenseVector(new double[]{1.0, 2.0, 3.0}), 5.0, 31);
        WeightedVector v3 = new WeightedVector((Vector)new DenseVector(new double[]{1.0, 3.0, 3.0}), 5.0, 31);
        WeightedVector v4 = v1.clone();
        WeightedVectorComparator comparator = new WeightedVectorComparator();
        WeightedVectorTest.assertTrue((comparator.compare(v1, v2) > 0 ? 1 : 0) != 0);
        WeightedVectorTest.assertTrue((comparator.compare(v3, v1) < 0 ? 1 : 0) != 0);
        WeightedVectorTest.assertTrue((comparator.compare(v3, v2) > 0 ? 1 : 0) != 0);
        WeightedVectorTest.assertEquals((long)0L, (long)comparator.compare(v4, v1));
        WeightedVectorTest.assertEquals((long)0L, (long)comparator.compare(v1, v1));
    }

    @Test
    public void testProjection() {
        Vector v1 = new DenseVector(10).assign(Functions.random());
        WeightedVector v2 = new WeightedVector(v1, v1, 31);
        WeightedVectorTest.assertEquals((double)v1.dot(v1), (double)v2.getWeight(), (double)1.0E-13);
        WeightedVectorTest.assertEquals((long)31L, (long)v2.getIndex());
        Matrix y = new DenseMatrix(10, 4).assign(Functions.random());
        Matrix q = new QRDecomposition(y.viewPart(0, 10, 0, 3)).getQ();
        Vector nullSpace = y.viewColumn(3).minus(q.times(q.transpose().times(y.viewColumn(3))));
        WeightedVector v3 = new WeightedVector(q.viewColumn(0).plus(q.viewColumn(1)), nullSpace, 1);
        WeightedVectorTest.assertEquals((double)0.0, (double)v3.getWeight(), (double)1.0E-13);
        Vector qx = q.viewColumn(0).plus(q.viewColumn(1)).normalize();
        WeightedVector v4 = new WeightedVector(qx, q.viewColumn(0), 2);
        WeightedVectorTest.assertEquals((double)Math.sqrt(0.5), (double)v4.getWeight(), (double)1.0E-13);
        WeightedVector v5 = WeightedVector.project((Vector)q.viewColumn(0), (Vector)qx);
        WeightedVectorTest.assertEquals((double)Math.sqrt(0.5), (double)v5.getWeight(), (double)1.0E-13);
    }

    @Override
    public void testSize() {
        WeightedVectorTest.assertEquals((String)"size", (long)3L, (long)this.getTestVector().getNumNonZeroElements());
    }

    @Override
    Vector generateTestVector(int cardinality) {
        return new WeightedVector((Vector)new DenseVector(cardinality), 3.14, 53);
    }
}

