/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.jet.random;

import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.io.CharStreams;
import com.google.common.io.InputSupplier;
import com.google.common.io.Resources;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Random;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.math.MahoutTestCase;
import org.apache.mahout.math.jet.random.NegativeBinomial;
import org.junit.Test;

public final class NegativeBinomialTest
extends MahoutTestCase {
    private static final Splitter onComma = Splitter.on((String)",").trimResults();

    @Test
    public void testDistributionFunctions() throws Exception {
        InputSupplier input = Resources.newReaderSupplier((URL)Resources.getResource((String)"negative-binomial-test-data.csv"), (Charset)Charsets.UTF_8);
        boolean header = true;
        for (String line : CharStreams.readLines((InputSupplier)input)) {
            if (header) {
                header = false;
                continue;
            }
            Iterable values = onComma.split((CharSequence)line);
            int k = Integer.parseInt((String)Iterables.get((Iterable)values, (int)0));
            double p = Double.parseDouble((String)Iterables.get((Iterable)values, (int)1));
            int r = Integer.parseInt((String)Iterables.get((Iterable)values, (int)2));
            double density = Double.parseDouble((String)Iterables.get((Iterable)values, (int)3));
            double cume = Double.parseDouble((String)Iterables.get((Iterable)values, (int)4));
            NegativeBinomial nb = new NegativeBinomial(r, p, (Random)RandomUtils.getRandom());
            NegativeBinomialTest.assertEquals((String)("cumulative " + k + ',' + p + ',' + r), (double)cume, (double)nb.cdf(k), (double)(cume * 1.0E-5));
            NegativeBinomialTest.assertEquals((String)("density " + k + ',' + p + ',' + r), (double)density, (double)nb.pdf(k), (double)(density * 1.0E-5));
        }
    }
}

