/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.mahout.math.function.LongObjectProcedure;
import org.apache.mahout.math.function.LongProcedure;
import org.apache.mahout.math.list.LongArrayList;
import org.apache.mahout.math.map.OpenLongObjectHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OpenLongObjectHashMapTest
extends Assert {
    private TestClass item;
    private TestClass anotherItem;
    private TestClass anotherItem2;
    private TestClass anotherItem3;
    private TestClass anotherItem4;
    private TestClass anotherItem5;

    @Before
    public void before() {
        this.item = new TestClass(101L);
        this.anotherItem = new TestClass(99L);
        this.anotherItem2 = new TestClass(2L);
        this.anotherItem3 = new TestClass(3L);
        this.anotherItem4 = new TestClass(4L);
        this.anotherItem5 = new TestClass(5L);
    }

    @Test
    public void testConstructors() {
        OpenLongObjectHashMap map = new OpenLongObjectHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenLongObjectHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenLongObjectHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenLongObjectHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenLongObjectHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenLongObjectHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenLongObjectHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenLongObjectHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenLongObjectHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenLongObjectHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenLongObjectHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenLongObjectHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenLongObjectHashMap map = new OpenLongObjectHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenLongObjectHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenLongObjectHashMap map = new OpenLongObjectHashMap();
        for (int i = 0; i < 100; ++i) {
            map.put((long)i, (Object)this.item);
            OpenLongObjectHashMapTest.assertEquals((long)1L, (long)map.size());
            map.clear();
            OpenLongObjectHashMapTest.assertEquals((long)0L, (long)map.size());
            OpenLongObjectHashMapTest.assertFalse((String)("Contains: " + i), (boolean)map.containsKey((long)i));
            OpenLongObjectHashMapTest.assertSame(null, (Object)map.get((long)i));
        }
    }

    @Test
    public void testClone() {
        OpenLongObjectHashMap map = new OpenLongObjectHashMap();
        map.put(11L, (Object)this.item);
        OpenLongObjectHashMap map2 = map.clone();
        map.clear();
        OpenLongObjectHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenLongObjectHashMap map = new OpenLongObjectHashMap();
        map.put(11L, (Object)this.item);
        OpenLongObjectHashMapTest.assertTrue((boolean)map.containsKey(11L));
        OpenLongObjectHashMapTest.assertFalse((boolean)map.containsKey(12L));
    }

    @Test
    public void testContainValue() {
        OpenLongObjectHashMap map = new OpenLongObjectHashMap();
        map.put(11L, (Object)this.item);
        OpenLongObjectHashMapTest.assertTrue((boolean)map.containsValue((Object)this.item));
        OpenLongObjectHashMapTest.assertFalse((boolean)map.containsValue((Object)this.anotherItem));
    }

    @Test
    public void testForEachKey() {
        final LongArrayList keys = new LongArrayList();
        OpenLongObjectHashMap map = new OpenLongObjectHashMap();
        map.put(11L, (Object)this.anotherItem);
        map.put(12L, (Object)this.anotherItem2);
        map.put(13L, (Object)this.anotherItem3);
        map.put(14L, (Object)this.anotherItem4);
        map.removeKey(13L);
        map.forEachKey(new LongProcedure(){

            public boolean apply(long element) {
                keys.add(element);
                return true;
            }
        });
        long[] keysArray = keys.toArray(new long[keys.size()]);
        Arrays.sort(keysArray);
        OpenLongObjectHashMapTest.assertArrayEquals((long[])new long[]{11L, 12L, 14L}, (long[])keysArray);
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenLongObjectHashMap map = new OpenLongObjectHashMap();
        map.put(11L, (Object)this.anotherItem);
        map.put(12L, (Object)this.anotherItem2);
        map.put(13L, (Object)this.anotherItem3);
        map.put(14L, (Object)this.anotherItem4);
        map.removeKey(13L);
        map.forEachPair((LongObjectProcedure)new LongObjectProcedure<TestClass>(){

            public boolean apply(long first, TestClass second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenLongObjectHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenLongObjectHashMapTest.assertEquals((long)11L, (long)((Pair)pairs.get((int)0)).k);
        OpenLongObjectHashMapTest.assertSame((Object)this.anotherItem, (Object)((Pair)pairs.get((int)0)).v);
        OpenLongObjectHashMapTest.assertEquals((long)12L, (long)((Pair)pairs.get((int)1)).k);
        OpenLongObjectHashMapTest.assertSame((Object)this.anotherItem2, (Object)((Pair)pairs.get((int)1)).v);
        OpenLongObjectHashMapTest.assertEquals((long)14L, (long)((Pair)pairs.get((int)2)).k);
        OpenLongObjectHashMapTest.assertSame((Object)this.anotherItem4, (Object)((Pair)pairs.get((int)2)).v);
        pairs.clear();
        map.forEachPair((LongObjectProcedure)new LongObjectProcedure<TestClass>(){
            int count = 0;

            public boolean apply(long first, TestClass second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenLongObjectHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenLongObjectHashMap map = new OpenLongObjectHashMap();
        map.put(11L, (Object)this.item);
        map.put(12L, (Object)this.anotherItem);
        OpenLongObjectHashMapTest.assertSame((Object)this.item, (Object)map.get(11L));
        OpenLongObjectHashMapTest.assertSame(null, (Object)map.get(0L));
    }

    @Test
    public void testKeys() {
        OpenLongObjectHashMap map = new OpenLongObjectHashMap();
        map.put(11L, (Object)this.item);
        map.put(12L, (Object)this.item);
        LongArrayList keys = new LongArrayList();
        map.keys(keys);
        keys.sort();
        OpenLongObjectHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenLongObjectHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        LongArrayList k2 = map.keys();
        k2.sort();
        OpenLongObjectHashMapTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testPairsMatching() {
        LongArrayList keyList = new LongArrayList();
        ArrayList valueList = new ArrayList();
        OpenLongObjectHashMap map = new OpenLongObjectHashMap();
        map.put(11L, (Object)this.anotherItem2);
        map.put(12L, (Object)this.anotherItem3);
        map.put(13L, (Object)this.anotherItem4);
        map.put(14L, (Object)this.anotherItem5);
        map.removeKey(13L);
        map.pairsMatching((LongObjectProcedure)new LongObjectProcedure<TestClass>(){

            public boolean apply(long first, TestClass second) {
                return first % 2L == 0L;
            }
        }, keyList, valueList);
        keyList.sort();
        Collections.sort(valueList);
        OpenLongObjectHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenLongObjectHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenLongObjectHashMapTest.assertEquals((long)12L, (long)keyList.get(0));
        OpenLongObjectHashMapTest.assertEquals((long)14L, (long)keyList.get(1));
        OpenLongObjectHashMapTest.assertSame((Object)this.anotherItem3, valueList.get(0));
        OpenLongObjectHashMapTest.assertSame((Object)this.anotherItem5, valueList.get(1));
    }

    @Test
    public void testValues() {
        OpenLongObjectHashMap map = new OpenLongObjectHashMap();
        map.put(11L, (Object)this.anotherItem);
        map.put(12L, (Object)this.anotherItem2);
        map.put(13L, (Object)this.anotherItem3);
        map.put(14L, (Object)this.anotherItem4);
        map.removeKey(13L);
        ArrayList values = new ArrayList(100);
        map.values(values);
        OpenLongObjectHashMapTest.assertEquals((long)3L, (long)values.size());
        Collections.sort(values);
        OpenLongObjectHashMapTest.assertEquals((Object)this.anotherItem2, values.get(0));
        OpenLongObjectHashMapTest.assertEquals((Object)this.anotherItem4, values.get(1));
        OpenLongObjectHashMapTest.assertEquals((Object)this.anotherItem, values.get(2));
    }

    @Test
    public void testCopy() {
        OpenLongObjectHashMap map = new OpenLongObjectHashMap();
        map.put(11L, (Object)this.item);
        OpenLongObjectHashMap map2 = (OpenLongObjectHashMap)map.copy();
        map.clear();
        OpenLongObjectHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenLongObjectHashMap map = new OpenLongObjectHashMap();
        map.put(11L, (Object)this.anotherItem);
        map.put(12L, (Object)this.anotherItem2);
        map.put(13L, (Object)this.anotherItem3);
        map.put(14L, (Object)this.anotherItem4);
        map.removeKey(13L);
        OpenLongObjectHashMap map2 = (OpenLongObjectHashMap)map.copy();
        OpenLongObjectHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenLongObjectHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenLongObjectHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenLongObjectHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey(11L);
        OpenLongObjectHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenLongObjectHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenLongObjectHashMap map = new OpenLongObjectHashMap();
        map.put(11L, (Object)this.anotherItem5);
        map.put(12L, (Object)this.anotherItem4);
        map.put(13L, (Object)this.anotherItem3);
        map.put(14L, (Object)this.anotherItem2);
        map.removeKey(13L);
        LongArrayList keys = new LongArrayList();
        map.keysSortedByValue(keys);
        long[] keysArray = keys.toArray(new long[keys.size()]);
        OpenLongObjectHashMapTest.assertArrayEquals((long[])new long[]{14L, 12L, 11L}, (long[])keysArray);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenLongObjectHashMap map = new OpenLongObjectHashMap();
        map.put(11L, (Object)this.anotherItem5);
        map.put(12L, (Object)this.anotherItem4);
        map.put(13L, (Object)this.anotherItem3);
        map.put(14L, (Object)this.anotherItem2);
        LongArrayList keys = new LongArrayList();
        ArrayList values = new ArrayList();
        map.pairsSortedByKey(keys, values);
        OpenLongObjectHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenLongObjectHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenLongObjectHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenLongObjectHashMapTest.assertSame((Object)this.anotherItem5, values.get(0));
        OpenLongObjectHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        OpenLongObjectHashMapTest.assertSame((Object)this.anotherItem4, values.get(1));
        OpenLongObjectHashMapTest.assertEquals((long)13L, (long)keys.get(2));
        OpenLongObjectHashMapTest.assertSame((Object)this.anotherItem3, values.get(2));
        OpenLongObjectHashMapTest.assertEquals((long)14L, (long)keys.get(3));
        OpenLongObjectHashMapTest.assertSame((Object)this.anotherItem2, values.get(3));
    }

    @Test
    public void testPairsSortedByValue() {
        OpenLongObjectHashMap map = new OpenLongObjectHashMap();
        map.put(11L, (Object)this.anotherItem5);
        map.put(12L, (Object)this.anotherItem4);
        map.put(13L, (Object)this.anotherItem3);
        map.put(14L, (Object)this.anotherItem2);
        LongArrayList keys = new LongArrayList();
        ArrayList values = new ArrayList();
        map.pairsSortedByValue(keys, values);
        OpenLongObjectHashMapTest.assertEquals((long)11L, (long)keys.get(3));
        OpenLongObjectHashMapTest.assertEquals((Object)this.anotherItem5, values.get(3));
        OpenLongObjectHashMapTest.assertEquals((long)12L, (long)keys.get(2));
        OpenLongObjectHashMapTest.assertEquals((Object)this.anotherItem4, values.get(2));
        OpenLongObjectHashMapTest.assertEquals((long)13L, (long)keys.get(1));
        OpenLongObjectHashMapTest.assertEquals((Object)this.anotherItem3, values.get(1));
        OpenLongObjectHashMapTest.assertEquals((long)14L, (long)keys.get(0));
        OpenLongObjectHashMapTest.assertEquals((Object)this.anotherItem2, values.get(0));
    }

    private static class Pair
    implements Comparable<Pair> {
        long k;
        TestClass v;

        Pair(long k, TestClass v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.k < o.k) {
                return -1;
            }
            if (this.k == o.k) {
                return 0;
            }
            return 1;
        }
    }

    private static class TestClass
    implements Comparable<TestClass> {
        long x;

        TestClass(long x) {
            this.x = x;
        }

        public String toString() {
            return "[ts " + this.x + " ]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Long.valueOf(this.x).hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TestClass other = (TestClass)obj;
            return this.x == other.x;
        }

        @Override
        public int compareTo(TestClass o) {
            return (int)(this.x - o.x);
        }
    }
}

