/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.mahout.math.function.LongProcedure;
import org.apache.mahout.math.function.LongShortProcedure;
import org.apache.mahout.math.list.LongArrayList;
import org.apache.mahout.math.list.ShortArrayList;
import org.apache.mahout.math.map.OpenLongShortHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Test;

public class OpenLongShortHashMapTest
extends Assert {
    @Test
    public void testConstructors() {
        OpenLongShortHashMap map = new OpenLongShortHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenLongShortHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenLongShortHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenLongShortHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenLongShortHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenLongShortHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenLongShortHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenLongShortHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenLongShortHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenLongShortHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenLongShortHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenLongShortHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenLongShortHashMap map = new OpenLongShortHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenLongShortHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenLongShortHashMap map = new OpenLongShortHashMap();
        map.put(11L, (short)22);
        OpenLongShortHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenLongShortHashMapTest.assertEquals((long)0L, (long)map.size());
        OpenLongShortHashMapTest.assertEquals((double)0.0, (double)map.get(11L), (double)1.0E-7);
    }

    @Test
    public void testClone() {
        OpenLongShortHashMap map = new OpenLongShortHashMap();
        map.put(11L, (short)22);
        OpenLongShortHashMap map2 = (OpenLongShortHashMap)map.clone();
        map.clear();
        OpenLongShortHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenLongShortHashMap map = new OpenLongShortHashMap();
        map.put(11L, (short)22);
        OpenLongShortHashMapTest.assertTrue((boolean)map.containsKey(11L));
        OpenLongShortHashMapTest.assertFalse((boolean)map.containsKey(12L));
    }

    @Test
    public void testContainValue() {
        OpenLongShortHashMap map = new OpenLongShortHashMap();
        map.put(11L, (short)22);
        OpenLongShortHashMapTest.assertTrue((boolean)map.containsValue((short)22));
        OpenLongShortHashMapTest.assertFalse((boolean)map.containsValue((short)23));
    }

    @Test
    public void testForEachKey() {
        final LongArrayList keys = new LongArrayList();
        OpenLongShortHashMap map = new OpenLongShortHashMap();
        map.put(11L, (short)22);
        map.put(12L, (short)23);
        map.put(13L, (short)24);
        map.put(14L, (short)25);
        map.removeKey(13L);
        map.forEachKey(new LongProcedure(){

            public boolean apply(long element) {
                keys.add(element);
                return true;
            }
        });
        long[] keysArray = keys.toArray(new long[keys.size()]);
        Arrays.sort(keysArray);
        OpenLongShortHashMapTest.assertArrayEquals((long[])new long[]{11L, 12L, 14L}, (long[])keysArray);
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenLongShortHashMap map = new OpenLongShortHashMap();
        map.put(11L, (short)22);
        map.put(12L, (short)23);
        map.put(13L, (short)24);
        map.put(14L, (short)25);
        map.removeKey(13L);
        map.forEachPair(new LongShortProcedure(){

            public boolean apply(long first, short second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenLongShortHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenLongShortHashMapTest.assertEquals((long)11L, (long)((Pair)pairs.get((int)0)).k);
        OpenLongShortHashMapTest.assertEquals((long)22L, (long)((Pair)pairs.get((int)0)).v);
        OpenLongShortHashMapTest.assertEquals((long)12L, (long)((Pair)pairs.get((int)1)).k);
        OpenLongShortHashMapTest.assertEquals((long)23L, (long)((Pair)pairs.get((int)1)).v);
        OpenLongShortHashMapTest.assertEquals((long)14L, (long)((Pair)pairs.get((int)2)).k);
        OpenLongShortHashMapTest.assertEquals((long)25L, (long)((Pair)pairs.get((int)2)).v);
        pairs.clear();
        map.forEachPair(new LongShortProcedure(){
            int count = 0;

            public boolean apply(long first, short second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenLongShortHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenLongShortHashMap map = new OpenLongShortHashMap();
        map.put(11L, (short)22);
        map.put(12L, (short)23);
        OpenLongShortHashMapTest.assertEquals((long)22L, (long)map.get(11L));
        OpenLongShortHashMapTest.assertEquals((long)0L, (long)map.get(0L));
    }

    @Test
    public void testAdjustOrPutValue() {
        OpenLongShortHashMap map = new OpenLongShortHashMap();
        map.put(11L, (short)22);
        map.put(12L, (short)23);
        map.put(13L, (short)24);
        map.put(14L, (short)25);
        map.adjustOrPutValue(11L, (short)1, (short)3);
        OpenLongShortHashMapTest.assertEquals((long)25L, (long)map.get(11L));
        map.adjustOrPutValue(15L, (short)1, (short)3);
        OpenLongShortHashMapTest.assertEquals((long)1L, (long)map.get(15L));
    }

    @Test
    public void testKeys() {
        OpenLongShortHashMap map = new OpenLongShortHashMap();
        map.put(11L, (short)22);
        map.put(12L, (short)22);
        LongArrayList keys = new LongArrayList();
        map.keys(keys);
        keys.sort();
        OpenLongShortHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenLongShortHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        LongArrayList k2 = map.keys();
        k2.sort();
        OpenLongShortHashMapTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testPairsMatching() {
        LongArrayList keyList = new LongArrayList();
        ShortArrayList valueList = new ShortArrayList();
        OpenLongShortHashMap map = new OpenLongShortHashMap();
        map.put(11L, (short)22);
        map.put(12L, (short)23);
        map.put(13L, (short)24);
        map.put(14L, (short)25);
        map.removeKey(13L);
        map.pairsMatching(new LongShortProcedure(){

            public boolean apply(long first, short second) {
                return first % 2L == 0L;
            }
        }, keyList, valueList);
        keyList.sort();
        valueList.sort();
        OpenLongShortHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenLongShortHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenLongShortHashMapTest.assertEquals((long)12L, (long)keyList.get(0));
        OpenLongShortHashMapTest.assertEquals((long)14L, (long)keyList.get(1));
        OpenLongShortHashMapTest.assertEquals((long)23L, (long)valueList.get(0));
        OpenLongShortHashMapTest.assertEquals((long)25L, (long)valueList.get(1));
    }

    @Test
    public void testValues() {
        OpenLongShortHashMap map = new OpenLongShortHashMap();
        map.put(11L, (short)22);
        map.put(12L, (short)23);
        map.put(13L, (short)24);
        map.put(14L, (short)25);
        map.removeKey(13L);
        ShortArrayList values = new ShortArrayList(100);
        map.values(values);
        OpenLongShortHashMapTest.assertEquals((long)3L, (long)values.size());
        values.sort();
        OpenLongShortHashMapTest.assertEquals((long)22L, (long)values.get(0));
        OpenLongShortHashMapTest.assertEquals((long)23L, (long)values.get(1));
        OpenLongShortHashMapTest.assertEquals((long)25L, (long)values.get(2));
    }

    @Test
    public void testCopy() {
        OpenLongShortHashMap map = new OpenLongShortHashMap();
        map.put(11L, (short)22);
        OpenLongShortHashMap map2 = (OpenLongShortHashMap)map.copy();
        map.clear();
        OpenLongShortHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenLongShortHashMap map = new OpenLongShortHashMap();
        map.put(11L, (short)22);
        map.put(12L, (short)23);
        map.put(13L, (short)24);
        map.put(14L, (short)25);
        map.removeKey(13L);
        OpenLongShortHashMap map2 = (OpenLongShortHashMap)map.copy();
        OpenLongShortHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenLongShortHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenLongShortHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenLongShortHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey(11L);
        OpenLongShortHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenLongShortHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenLongShortHashMap map = new OpenLongShortHashMap();
        map.put(11L, (short)22);
        map.put(12L, (short)23);
        map.put(13L, (short)24);
        map.put(14L, (short)25);
        map.removeKey(13L);
        LongArrayList keys = new LongArrayList();
        map.keysSortedByValue(keys);
        long[] keysArray = keys.toArray(new long[keys.size()]);
        OpenLongShortHashMapTest.assertArrayEquals((long[])new long[]{11L, 12L, 14L}, (long[])keysArray);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenLongShortHashMap map = new OpenLongShortHashMap();
        map.put(11L, (short)100);
        map.put(12L, (short)70);
        map.put(13L, (short)30);
        map.put(14L, (short)3);
        LongArrayList keys = new LongArrayList();
        ShortArrayList values = new ShortArrayList();
        map.pairsSortedByKey(keys, values);
        OpenLongShortHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenLongShortHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenLongShortHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenLongShortHashMapTest.assertEquals((long)100L, (long)values.get(0));
        OpenLongShortHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        OpenLongShortHashMapTest.assertEquals((long)70L, (long)values.get(1));
        OpenLongShortHashMapTest.assertEquals((long)13L, (long)keys.get(2));
        OpenLongShortHashMapTest.assertEquals((long)30L, (long)values.get(2));
        OpenLongShortHashMapTest.assertEquals((long)14L, (long)keys.get(3));
        OpenLongShortHashMapTest.assertEquals((long)3L, (long)values.get(3));
        keys.clear();
        values.clear();
        map.pairsSortedByValue(keys, values);
        OpenLongShortHashMapTest.assertEquals((long)11L, (long)keys.get(3));
        OpenLongShortHashMapTest.assertEquals((long)100L, (long)values.get(3));
        OpenLongShortHashMapTest.assertEquals((long)12L, (long)keys.get(2));
        OpenLongShortHashMapTest.assertEquals((long)70L, (long)values.get(2));
        OpenLongShortHashMapTest.assertEquals((long)13L, (long)keys.get(1));
        OpenLongShortHashMapTest.assertEquals((long)30L, (long)values.get(1));
        OpenLongShortHashMapTest.assertEquals((long)14L, (long)keys.get(0));
        OpenLongShortHashMapTest.assertEquals((long)3L, (long)values.get(0));
    }

    private static class Pair
    implements Comparable<Pair> {
        long k;
        short v;

        Pair(long k, short v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.k < o.k) {
                return -1;
            }
            if (this.k == o.k) {
                return 0;
            }
            return 1;
        }
    }
}

