/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.mahout.math.function.ShortDoubleProcedure;
import org.apache.mahout.math.function.ShortProcedure;
import org.apache.mahout.math.list.DoubleArrayList;
import org.apache.mahout.math.list.ShortArrayList;
import org.apache.mahout.math.map.OpenShortDoubleHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Test;

public class OpenShortDoubleHashMapTest
extends Assert {
    @Test
    public void testConstructors() {
        OpenShortDoubleHashMap map = new OpenShortDoubleHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenShortDoubleHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenShortDoubleHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenShortDoubleHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenShortDoubleHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenShortDoubleHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenShortDoubleHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenShortDoubleHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenShortDoubleHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenShortDoubleHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenShortDoubleHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenShortDoubleHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenShortDoubleHashMap map = new OpenShortDoubleHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenShortDoubleHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenShortDoubleHashMap map = new OpenShortDoubleHashMap();
        map.put((short)11, 22.0);
        OpenShortDoubleHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenShortDoubleHashMapTest.assertEquals((long)0L, (long)map.size());
        OpenShortDoubleHashMapTest.assertEquals((double)0.0, (double)map.get((short)11), (double)1.0E-7);
    }

    @Test
    public void testClone() {
        OpenShortDoubleHashMap map = new OpenShortDoubleHashMap();
        map.put((short)11, 22.0);
        OpenShortDoubleHashMap map2 = (OpenShortDoubleHashMap)map.clone();
        map.clear();
        OpenShortDoubleHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenShortDoubleHashMap map = new OpenShortDoubleHashMap();
        map.put((short)11, 22.0);
        OpenShortDoubleHashMapTest.assertTrue((boolean)map.containsKey((short)11));
        OpenShortDoubleHashMapTest.assertFalse((boolean)map.containsKey((short)12));
    }

    @Test
    public void testContainValue() {
        OpenShortDoubleHashMap map = new OpenShortDoubleHashMap();
        map.put((short)11, 22.0);
        OpenShortDoubleHashMapTest.assertTrue((boolean)map.containsValue(22.0));
        OpenShortDoubleHashMapTest.assertFalse((boolean)map.containsValue(23.0));
    }

    @Test
    public void testForEachKey() {
        final ShortArrayList keys = new ShortArrayList();
        OpenShortDoubleHashMap map = new OpenShortDoubleHashMap();
        map.put((short)11, 22.0);
        map.put((short)12, 23.0);
        map.put((short)13, 24.0);
        map.put((short)14, 25.0);
        map.removeKey((short)13);
        map.forEachKey(new ShortProcedure(){

            public boolean apply(short element) {
                keys.add(element);
                return true;
            }
        });
        short[] keysArray = keys.toArray(new short[keys.size()]);
        Arrays.sort(keysArray);
        OpenShortDoubleHashMapTest.assertArrayEquals((short[])new short[]{11, 12, 14}, (short[])keysArray);
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenShortDoubleHashMap map = new OpenShortDoubleHashMap();
        map.put((short)11, 22.0);
        map.put((short)12, 23.0);
        map.put((short)13, 24.0);
        map.put((short)14, 25.0);
        map.removeKey((short)13);
        map.forEachPair(new ShortDoubleProcedure(){

            public boolean apply(short first, double second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenShortDoubleHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenShortDoubleHashMapTest.assertEquals((long)11L, (long)((Pair)pairs.get((int)0)).k);
        OpenShortDoubleHashMapTest.assertEquals((double)22.0, (double)((Pair)pairs.get((int)0)).v, (double)1.0E-6);
        OpenShortDoubleHashMapTest.assertEquals((long)12L, (long)((Pair)pairs.get((int)1)).k);
        OpenShortDoubleHashMapTest.assertEquals((double)23.0, (double)((Pair)pairs.get((int)1)).v, (double)1.0E-6);
        OpenShortDoubleHashMapTest.assertEquals((long)14L, (long)((Pair)pairs.get((int)2)).k);
        OpenShortDoubleHashMapTest.assertEquals((double)25.0, (double)((Pair)pairs.get((int)2)).v, (double)1.0E-6);
        pairs.clear();
        map.forEachPair(new ShortDoubleProcedure(){
            int count = 0;

            public boolean apply(short first, double second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenShortDoubleHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenShortDoubleHashMap map = new OpenShortDoubleHashMap();
        map.put((short)11, 22.0);
        map.put((short)12, 23.0);
        OpenShortDoubleHashMapTest.assertEquals((double)22.0, (double)map.get((short)11), (double)1.0E-6);
        OpenShortDoubleHashMapTest.assertEquals((double)0.0, (double)map.get((short)0), (double)1.0E-6);
    }

    @Test
    public void testAdjustOrPutValue() {
        OpenShortDoubleHashMap map = new OpenShortDoubleHashMap();
        map.put((short)11, 22.0);
        map.put((short)12, 23.0);
        map.put((short)13, 24.0);
        map.put((short)14, 25.0);
        map.adjustOrPutValue((short)11, 1.0, 3.0);
        OpenShortDoubleHashMapTest.assertEquals((double)25.0, (double)map.get((short)11), (double)1.0E-6);
        map.adjustOrPutValue((short)15, 1.0, 3.0);
        OpenShortDoubleHashMapTest.assertEquals((double)1.0, (double)map.get((short)15), (double)1.0E-6);
    }

    @Test
    public void testKeys() {
        OpenShortDoubleHashMap map = new OpenShortDoubleHashMap();
        map.put((short)11, 22.0);
        map.put((short)12, 22.0);
        ShortArrayList keys = new ShortArrayList();
        map.keys(keys);
        keys.sort();
        OpenShortDoubleHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenShortDoubleHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        ShortArrayList k2 = map.keys();
        k2.sort();
        OpenShortDoubleHashMapTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testPairsMatching() {
        ShortArrayList keyList = new ShortArrayList();
        DoubleArrayList valueList = new DoubleArrayList();
        OpenShortDoubleHashMap map = new OpenShortDoubleHashMap();
        map.put((short)11, 22.0);
        map.put((short)12, 23.0);
        map.put((short)13, 24.0);
        map.put((short)14, 25.0);
        map.removeKey((short)13);
        map.pairsMatching(new ShortDoubleProcedure(){

            public boolean apply(short first, double second) {
                return first % 2 == 0;
            }
        }, keyList, valueList);
        keyList.sort();
        valueList.sort();
        OpenShortDoubleHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenShortDoubleHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenShortDoubleHashMapTest.assertEquals((long)12L, (long)keyList.get(0));
        OpenShortDoubleHashMapTest.assertEquals((long)14L, (long)keyList.get(1));
        OpenShortDoubleHashMapTest.assertEquals((double)23.0, (double)valueList.get(0), (double)1.0E-6);
        OpenShortDoubleHashMapTest.assertEquals((double)25.0, (double)valueList.get(1), (double)1.0E-6);
    }

    @Test
    public void testValues() {
        OpenShortDoubleHashMap map = new OpenShortDoubleHashMap();
        map.put((short)11, 22.0);
        map.put((short)12, 23.0);
        map.put((short)13, 24.0);
        map.put((short)14, 25.0);
        map.removeKey((short)13);
        DoubleArrayList values = new DoubleArrayList(100);
        map.values(values);
        OpenShortDoubleHashMapTest.assertEquals((long)3L, (long)values.size());
        values.sort();
        OpenShortDoubleHashMapTest.assertEquals((double)22.0, (double)values.get(0), (double)1.0E-6);
        OpenShortDoubleHashMapTest.assertEquals((double)23.0, (double)values.get(1), (double)1.0E-6);
        OpenShortDoubleHashMapTest.assertEquals((double)25.0, (double)values.get(2), (double)1.0E-6);
    }

    @Test
    public void testCopy() {
        OpenShortDoubleHashMap map = new OpenShortDoubleHashMap();
        map.put((short)11, 22.0);
        OpenShortDoubleHashMap map2 = (OpenShortDoubleHashMap)map.copy();
        map.clear();
        OpenShortDoubleHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenShortDoubleHashMap map = new OpenShortDoubleHashMap();
        map.put((short)11, 22.0);
        map.put((short)12, 23.0);
        map.put((short)13, 24.0);
        map.put((short)14, 25.0);
        map.removeKey((short)13);
        OpenShortDoubleHashMap map2 = (OpenShortDoubleHashMap)map.copy();
        OpenShortDoubleHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenShortDoubleHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenShortDoubleHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenShortDoubleHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey((short)11);
        OpenShortDoubleHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenShortDoubleHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenShortDoubleHashMap map = new OpenShortDoubleHashMap();
        map.put((short)11, 22.0);
        map.put((short)12, 23.0);
        map.put((short)13, 24.0);
        map.put((short)14, 25.0);
        map.removeKey((short)13);
        ShortArrayList keys = new ShortArrayList();
        map.keysSortedByValue(keys);
        short[] keysArray = keys.toArray(new short[keys.size()]);
        OpenShortDoubleHashMapTest.assertArrayEquals((short[])new short[]{11, 12, 14}, (short[])keysArray);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenShortDoubleHashMap map = new OpenShortDoubleHashMap();
        map.put((short)11, 100.0);
        map.put((short)12, 70.0);
        map.put((short)13, 30.0);
        map.put((short)14, 3.0);
        ShortArrayList keys = new ShortArrayList();
        DoubleArrayList values = new DoubleArrayList();
        map.pairsSortedByKey(keys, values);
        OpenShortDoubleHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenShortDoubleHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenShortDoubleHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenShortDoubleHashMapTest.assertEquals((double)100.0, (double)values.get(0), (double)1.0E-6);
        OpenShortDoubleHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        OpenShortDoubleHashMapTest.assertEquals((double)70.0, (double)values.get(1), (double)1.0E-6);
        OpenShortDoubleHashMapTest.assertEquals((long)13L, (long)keys.get(2));
        OpenShortDoubleHashMapTest.assertEquals((double)30.0, (double)values.get(2), (double)1.0E-6);
        OpenShortDoubleHashMapTest.assertEquals((long)14L, (long)keys.get(3));
        OpenShortDoubleHashMapTest.assertEquals((double)3.0, (double)values.get(3), (double)1.0E-6);
        keys.clear();
        values.clear();
        map.pairsSortedByValue(keys, values);
        OpenShortDoubleHashMapTest.assertEquals((long)11L, (long)keys.get(3));
        OpenShortDoubleHashMapTest.assertEquals((double)100.0, (double)values.get(3), (double)1.0E-6);
        OpenShortDoubleHashMapTest.assertEquals((long)12L, (long)keys.get(2));
        OpenShortDoubleHashMapTest.assertEquals((double)70.0, (double)values.get(2), (double)1.0E-6);
        OpenShortDoubleHashMapTest.assertEquals((long)13L, (long)keys.get(1));
        OpenShortDoubleHashMapTest.assertEquals((double)30.0, (double)values.get(1), (double)1.0E-6);
        OpenShortDoubleHashMapTest.assertEquals((long)14L, (long)keys.get(0));
        OpenShortDoubleHashMapTest.assertEquals((double)3.0, (double)values.get(0), (double)1.0E-6);
    }

    private static class Pair
    implements Comparable<Pair> {
        short k;
        double v;

        Pair(short k, double v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.k < o.k) {
                return -1;
            }
            if (this.k == o.k) {
                return 0;
            }
            return 1;
        }
    }
}

