/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.mahout.math.function.ShortProcedure;
import org.apache.mahout.math.function.ShortShortProcedure;
import org.apache.mahout.math.list.ShortArrayList;
import org.apache.mahout.math.map.OpenShortShortHashMap;
import org.apache.mahout.math.map.PrimeFinder;
import org.junit.Assert;
import org.junit.Test;

public class OpenShortShortHashMapTest
extends Assert {
    @Test
    public void testConstructors() {
        OpenShortShortHashMap map = new OpenShortShortHashMap();
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenShortShortHashMapTest.assertEquals((long)277L, (long)capacity[0]);
        OpenShortShortHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenShortShortHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        int prime = PrimeFinder.nextPrime((int)907);
        map = new OpenShortShortHashMap(prime);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenShortShortHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenShortShortHashMapTest.assertEquals((double)0.5, (double)maxLoadFactor[0], (double)0.001);
        OpenShortShortHashMapTest.assertEquals((double)0.2, (double)minLoadFactor[0], (double)0.001);
        map = new OpenShortShortHashMap(prime, 0.4, 0.8);
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenShortShortHashMapTest.assertEquals((long)prime, (long)capacity[0]);
        OpenShortShortHashMapTest.assertEquals((double)0.4, (double)minLoadFactor[0], (double)0.001);
        OpenShortShortHashMapTest.assertEquals((double)0.8, (double)maxLoadFactor[0], (double)0.001);
    }

    @Test
    public void testEnsureCapacity() {
        OpenShortShortHashMap map = new OpenShortShortHashMap();
        int prime = PrimeFinder.nextPrime((int)907);
        map.ensureCapacity(prime);
        int[] capacity = new int[1];
        double[] minLoadFactor = new double[1];
        double[] maxLoadFactor = new double[1];
        map.getInternalFactors(capacity, minLoadFactor, maxLoadFactor);
        OpenShortShortHashMapTest.assertEquals((long)prime, (long)capacity[0]);
    }

    @Test
    public void testClear() {
        OpenShortShortHashMap map = new OpenShortShortHashMap();
        map.put((short)11, (short)22);
        OpenShortShortHashMapTest.assertEquals((long)1L, (long)map.size());
        map.clear();
        OpenShortShortHashMapTest.assertEquals((long)0L, (long)map.size());
        OpenShortShortHashMapTest.assertEquals((double)0.0, (double)map.get((short)11), (double)1.0E-7);
    }

    @Test
    public void testClone() {
        OpenShortShortHashMap map = new OpenShortShortHashMap();
        map.put((short)11, (short)22);
        OpenShortShortHashMap map2 = (OpenShortShortHashMap)map.clone();
        map.clear();
        OpenShortShortHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testContainsKey() {
        OpenShortShortHashMap map = new OpenShortShortHashMap();
        map.put((short)11, (short)22);
        OpenShortShortHashMapTest.assertTrue((boolean)map.containsKey((short)11));
        OpenShortShortHashMapTest.assertFalse((boolean)map.containsKey((short)12));
    }

    @Test
    public void testContainValue() {
        OpenShortShortHashMap map = new OpenShortShortHashMap();
        map.put((short)11, (short)22);
        OpenShortShortHashMapTest.assertTrue((boolean)map.containsValue((short)22));
        OpenShortShortHashMapTest.assertFalse((boolean)map.containsValue((short)23));
    }

    @Test
    public void testForEachKey() {
        final ShortArrayList keys = new ShortArrayList();
        OpenShortShortHashMap map = new OpenShortShortHashMap();
        map.put((short)11, (short)22);
        map.put((short)12, (short)23);
        map.put((short)13, (short)24);
        map.put((short)14, (short)25);
        map.removeKey((short)13);
        map.forEachKey(new ShortProcedure(){

            public boolean apply(short element) {
                keys.add(element);
                return true;
            }
        });
        short[] keysArray = keys.toArray(new short[keys.size()]);
        Arrays.sort(keysArray);
        OpenShortShortHashMapTest.assertArrayEquals((short[])new short[]{11, 12, 14}, (short[])keysArray);
    }

    @Test
    public void testForEachPair() {
        final ArrayList pairs = new ArrayList();
        OpenShortShortHashMap map = new OpenShortShortHashMap();
        map.put((short)11, (short)22);
        map.put((short)12, (short)23);
        map.put((short)13, (short)24);
        map.put((short)14, (short)25);
        map.removeKey((short)13);
        map.forEachPair(new ShortShortProcedure(){

            public boolean apply(short first, short second) {
                pairs.add(new Pair(first, second));
                return true;
            }
        });
        Collections.sort(pairs);
        OpenShortShortHashMapTest.assertEquals((long)3L, (long)pairs.size());
        OpenShortShortHashMapTest.assertEquals((long)11L, (long)((Pair)pairs.get((int)0)).k);
        OpenShortShortHashMapTest.assertEquals((long)22L, (long)((Pair)pairs.get((int)0)).v);
        OpenShortShortHashMapTest.assertEquals((long)12L, (long)((Pair)pairs.get((int)1)).k);
        OpenShortShortHashMapTest.assertEquals((long)23L, (long)((Pair)pairs.get((int)1)).v);
        OpenShortShortHashMapTest.assertEquals((long)14L, (long)((Pair)pairs.get((int)2)).k);
        OpenShortShortHashMapTest.assertEquals((long)25L, (long)((Pair)pairs.get((int)2)).v);
        pairs.clear();
        map.forEachPair(new ShortShortProcedure(){
            int count = 0;

            public boolean apply(short first, short second) {
                pairs.add(new Pair(first, second));
                ++this.count;
                return this.count < 2;
            }
        });
        OpenShortShortHashMapTest.assertEquals((long)2L, (long)pairs.size());
    }

    @Test
    public void testGet() {
        OpenShortShortHashMap map = new OpenShortShortHashMap();
        map.put((short)11, (short)22);
        map.put((short)12, (short)23);
        OpenShortShortHashMapTest.assertEquals((long)22L, (long)map.get((short)11));
        OpenShortShortHashMapTest.assertEquals((long)0L, (long)map.get((short)0));
    }

    @Test
    public void testAdjustOrPutValue() {
        OpenShortShortHashMap map = new OpenShortShortHashMap();
        map.put((short)11, (short)22);
        map.put((short)12, (short)23);
        map.put((short)13, (short)24);
        map.put((short)14, (short)25);
        map.adjustOrPutValue((short)11, (short)1, (short)3);
        OpenShortShortHashMapTest.assertEquals((long)25L, (long)map.get((short)11));
        map.adjustOrPutValue((short)15, (short)1, (short)3);
        OpenShortShortHashMapTest.assertEquals((long)1L, (long)map.get((short)15));
    }

    @Test
    public void testKeys() {
        OpenShortShortHashMap map = new OpenShortShortHashMap();
        map.put((short)11, (short)22);
        map.put((short)12, (short)22);
        ShortArrayList keys = new ShortArrayList();
        map.keys(keys);
        keys.sort();
        OpenShortShortHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenShortShortHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        ShortArrayList k2 = map.keys();
        k2.sort();
        OpenShortShortHashMapTest.assertEquals((Object)keys, (Object)k2);
    }

    @Test
    public void testPairsMatching() {
        ShortArrayList keyList = new ShortArrayList();
        ShortArrayList valueList = new ShortArrayList();
        OpenShortShortHashMap map = new OpenShortShortHashMap();
        map.put((short)11, (short)22);
        map.put((short)12, (short)23);
        map.put((short)13, (short)24);
        map.put((short)14, (short)25);
        map.removeKey((short)13);
        map.pairsMatching(new ShortShortProcedure(){

            public boolean apply(short first, short second) {
                return first % 2 == 0;
            }
        }, keyList, valueList);
        keyList.sort();
        valueList.sort();
        OpenShortShortHashMapTest.assertEquals((long)2L, (long)keyList.size());
        OpenShortShortHashMapTest.assertEquals((long)2L, (long)valueList.size());
        OpenShortShortHashMapTest.assertEquals((long)12L, (long)keyList.get(0));
        OpenShortShortHashMapTest.assertEquals((long)14L, (long)keyList.get(1));
        OpenShortShortHashMapTest.assertEquals((long)23L, (long)valueList.get(0));
        OpenShortShortHashMapTest.assertEquals((long)25L, (long)valueList.get(1));
    }

    @Test
    public void testValues() {
        OpenShortShortHashMap map = new OpenShortShortHashMap();
        map.put((short)11, (short)22);
        map.put((short)12, (short)23);
        map.put((short)13, (short)24);
        map.put((short)14, (short)25);
        map.removeKey((short)13);
        ShortArrayList values = new ShortArrayList(100);
        map.values(values);
        OpenShortShortHashMapTest.assertEquals((long)3L, (long)values.size());
        values.sort();
        OpenShortShortHashMapTest.assertEquals((long)22L, (long)values.get(0));
        OpenShortShortHashMapTest.assertEquals((long)23L, (long)values.get(1));
        OpenShortShortHashMapTest.assertEquals((long)25L, (long)values.get(2));
    }

    @Test
    public void testCopy() {
        OpenShortShortHashMap map = new OpenShortShortHashMap();
        map.put((short)11, (short)22);
        OpenShortShortHashMap map2 = (OpenShortShortHashMap)map.copy();
        map.clear();
        OpenShortShortHashMapTest.assertEquals((long)1L, (long)map2.size());
    }

    @Test
    public void testEquals() {
        OpenShortShortHashMap map = new OpenShortShortHashMap();
        map.put((short)11, (short)22);
        map.put((short)12, (short)23);
        map.put((short)13, (short)24);
        map.put((short)14, (short)25);
        map.removeKey((short)13);
        OpenShortShortHashMap map2 = (OpenShortShortHashMap)map.copy();
        OpenShortShortHashMapTest.assertEquals((Object)map, (Object)map2);
        OpenShortShortHashMapTest.assertTrue((boolean)map2.equals((Object)map));
        OpenShortShortHashMapTest.assertFalse((boolean)"Hello Sailor".equals(map));
        OpenShortShortHashMapTest.assertFalse((boolean)map.equals((Object)"hello sailor"));
        map2.removeKey((short)11);
        OpenShortShortHashMapTest.assertFalse((boolean)map.equals((Object)map2));
        OpenShortShortHashMapTest.assertFalse((boolean)map2.equals((Object)map));
    }

    @Test
    public void testKeysSortedByValue() {
        OpenShortShortHashMap map = new OpenShortShortHashMap();
        map.put((short)11, (short)22);
        map.put((short)12, (short)23);
        map.put((short)13, (short)24);
        map.put((short)14, (short)25);
        map.removeKey((short)13);
        ShortArrayList keys = new ShortArrayList();
        map.keysSortedByValue(keys);
        short[] keysArray = keys.toArray(new short[keys.size()]);
        OpenShortShortHashMapTest.assertArrayEquals((short[])new short[]{11, 12, 14}, (short[])keysArray);
    }

    @Test
    public void testPairsSortedByKey() {
        OpenShortShortHashMap map = new OpenShortShortHashMap();
        map.put((short)11, (short)100);
        map.put((short)12, (short)70);
        map.put((short)13, (short)30);
        map.put((short)14, (short)3);
        ShortArrayList keys = new ShortArrayList();
        ShortArrayList values = new ShortArrayList();
        map.pairsSortedByKey(keys, values);
        OpenShortShortHashMapTest.assertEquals((long)4L, (long)keys.size());
        OpenShortShortHashMapTest.assertEquals((long)4L, (long)values.size());
        OpenShortShortHashMapTest.assertEquals((long)11L, (long)keys.get(0));
        OpenShortShortHashMapTest.assertEquals((long)100L, (long)values.get(0));
        OpenShortShortHashMapTest.assertEquals((long)12L, (long)keys.get(1));
        OpenShortShortHashMapTest.assertEquals((long)70L, (long)values.get(1));
        OpenShortShortHashMapTest.assertEquals((long)13L, (long)keys.get(2));
        OpenShortShortHashMapTest.assertEquals((long)30L, (long)values.get(2));
        OpenShortShortHashMapTest.assertEquals((long)14L, (long)keys.get(3));
        OpenShortShortHashMapTest.assertEquals((long)3L, (long)values.get(3));
        keys.clear();
        values.clear();
        map.pairsSortedByValue(keys, values);
        OpenShortShortHashMapTest.assertEquals((long)11L, (long)keys.get(3));
        OpenShortShortHashMapTest.assertEquals((long)100L, (long)values.get(3));
        OpenShortShortHashMapTest.assertEquals((long)12L, (long)keys.get(2));
        OpenShortShortHashMapTest.assertEquals((long)70L, (long)values.get(2));
        OpenShortShortHashMapTest.assertEquals((long)13L, (long)keys.get(1));
        OpenShortShortHashMapTest.assertEquals((long)30L, (long)values.get(1));
        OpenShortShortHashMapTest.assertEquals((long)14L, (long)keys.get(0));
        OpenShortShortHashMapTest.assertEquals((long)3L, (long)values.get(0));
    }

    private static class Pair
    implements Comparable<Pair> {
        short k;
        short v;

        Pair(short k, short v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int compareTo(Pair o) {
            if (this.k < o.k) {
                return -1;
            }
            if (this.k == o.k) {
                return 0;
            }
            return 1;
        }
    }
}

