/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.random;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.math.MahoutTestCase;
import org.apache.mahout.math.random.Empirical;
import org.junit.Assert;
import org.junit.Test;

public class EmpiricalTest
extends MahoutTestCase {
    @Test
    public void testSimpleDist() {
        RandomUtils.useTestSeed();
        Empirical z = new Empirical(true, true, 3, new double[]{0.0, 1.0, 0.5, 2.0, 1.0, 3.0});
        ArrayList r = Lists.newArrayList();
        for (int i = 0; i < 10001; ++i) {
            r.add(z.sample());
        }
        Collections.sort(r);
        EmpiricalTest.assertEquals((double)2.0, (double)((Double)r.get(5000)), (double)0.15);
    }

    @Test
    public void testZeros() {
        Empirical z = new Empirical(true, true, 3, new double[]{0.0, 1.0, 0.5, 2.0, 1.0, 3.0});
        EmpiricalTest.assertEquals((double)-16.52, (double)z.sample(0.0), (double)0.01);
        EmpiricalTest.assertEquals((double)20.47, (double)z.sample(1.0), (double)0.01);
    }

    @Test
    public void testBadArguments() {
        try {
            new Empirical(true, false, 20, new double[]{0.0, 1.0, 0.5, 2.0, 0.9, 9.0, 0.99, 10.0});
            Assert.fail((String)"Should have caught that");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new Empirical(false, true, 20, new double[]{0.1, 1.0, 0.5, 2.0, 0.9, 9.0, 1.0, 10.0});
            Assert.fail((String)"Should have caught that");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new Empirical(true, true, 20, new double[]{-0.1, 1.0, 0.5, 2.0, 0.9, 9.0, 1.0, 10.0});
            Assert.fail((String)"Should have caught that");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new Empirical(true, true, 20, new double[]{0.0, 1.0, 0.5, 2.0, 0.9, 9.0, 1.2, 10.0});
            Assert.fail((String)"Should have caught that");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new Empirical(true, true, 20, new double[]{0.0, 1.0, 0.5, 2.0, 0.4, 9.0, 1.0, 10.0});
            Assert.fail((String)"Should have caught that");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

