/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.random;

import java.util.Arrays;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.math.MahoutTestCase;
import org.apache.mahout.math.random.Normal;
import org.apache.mahout.math.stats.OnlineSummarizer;
import org.junit.Before;
import org.junit.Test;

public final class NormalTest
extends MahoutTestCase {
    @Override
    @Before
    public void setUp() {
        RandomUtils.useTestSeed();
    }

    @Test
    public void testOffset() {
        OnlineSummarizer s = new OnlineSummarizer();
        Normal sampler = new Normal(2.0, 5.0);
        for (int i = 0; i < 10001; ++i) {
            s.add(((Double)sampler.sample()).doubleValue());
        }
        NormalTest.assertEquals((String)String.format("m = %.3f, sd = %.3f", s.getMean(), s.getSD()), (double)2.0, (double)s.getMean(), (double)(0.04 * s.getSD()));
        NormalTest.assertEquals((double)5.0, (double)s.getSD(), (double)0.12);
    }

    @Test
    public void testSample() throws Exception {
        double[] data = new double[10001];
        Normal sampler = new Normal();
        for (int i = 0; i < data.length; ++i) {
            data[i] = (Double)sampler.sample();
        }
        Arrays.sort(data);
        NormalDistribution reference = new NormalDistribution(RandomUtils.getRandom().getRandomGenerator(), 0.0, 1.0, 1.0E-9);
        NormalTest.assertEquals((String)"Median", (double)reference.inverseCumulativeProbability(0.5), (double)data[5000], (double)0.04);
    }
}

