/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.stats;

import com.tdunning.math.stats.TDigest;
import com.tdunning.math.stats.TreeDigest;

public class OnlineSummarizer {
    private TDigest quantiles = new TreeDigest(100.0);
    private double mean;
    private double variance;
    private int n;

    public void add(double sample) {
        ++this.n;
        double oldMean = this.mean;
        this.mean += (sample - this.mean) / (double)this.n;
        double diff = (sample - this.mean) * (sample - oldMean);
        this.variance += (diff - this.variance) / (double)this.n;
        this.quantiles.add(sample);
    }

    public int getCount() {
        return this.n;
    }

    public double getMean() {
        return this.mean;
    }

    public double getSD() {
        return Math.sqrt(this.variance);
    }

    public double getMin() {
        return this.getQuartile(0);
    }

    public double getMax() {
        return this.getQuartile(4);
    }

    public double getQuartile(int i) {
        return this.quantiles.quantile(0.25 * (double)i);
    }

    public double quantile(double q) {
        return this.quantiles.quantile(q);
    }

    public double getMedian() {
        return this.getQuartile(2);
    }
}

