/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.similarity.precompute;

import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.recommender.ItemBasedRecommender;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.apache.mahout.cf.taste.similarity.precompute.BatchItemSimilarities;
import org.apache.mahout.cf.taste.similarity.precompute.SimilarItems;
import org.apache.mahout.cf.taste.similarity.precompute.SimilarItemsWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultithreadedBatchItemSimilarities
extends BatchItemSimilarities {
    private int batchSize;
    private static final int DEFAULT_BATCH_SIZE = 100;
    private static final Logger log = LoggerFactory.getLogger(MultithreadedBatchItemSimilarities.class);

    public MultithreadedBatchItemSimilarities(ItemBasedRecommender recommender, int similarItemsPerItem) {
        this(recommender, similarItemsPerItem, 100);
    }

    public MultithreadedBatchItemSimilarities(ItemBasedRecommender recommender, int similarItemsPerItem, int batchSize) {
        super(recommender, similarItemsPerItem);
        this.batchSize = batchSize;
    }

    @Override
    public int computeItemSimilarities(int degreeOfParallelism, int maxDurationInHours, SimilarItemsWriter writer) throws IOException {
        ExecutorService executorService = Executors.newFixedThreadPool(degreeOfParallelism + 1);
        Output output = null;
        try {
            writer.open();
            DataModel dataModel = this.getRecommender().getDataModel();
            BlockingQueue<long[]> itemsIDsInBatches = MultithreadedBatchItemSimilarities.queueItemIDsInBatches(dataModel, this.batchSize, degreeOfParallelism);
            LinkedBlockingQueue<List<SimilarItems>> results = new LinkedBlockingQueue<List<SimilarItems>>();
            AtomicInteger numActiveWorkers = new AtomicInteger(degreeOfParallelism);
            for (int n = 0; n < degreeOfParallelism; ++n) {
                executorService.execute(new SimilarItemsWorker(n, itemsIDsInBatches, results, numActiveWorkers));
            }
            output = new Output(results, writer, numActiveWorkers);
            executorService.execute(output);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            executorService.shutdown();
            try {
                boolean succeeded = executorService.awaitTermination(maxDurationInHours, TimeUnit.HOURS);
                if (!succeeded) {
                    throw new RuntimeException("Unable to complete the computation in " + maxDurationInHours + " hours!");
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            Closeables.close((Closeable)writer, (boolean)false);
        }
        return output.getNumSimilaritiesProcessed();
    }

    private static BlockingQueue<long[]> queueItemIDsInBatches(DataModel dataModel, int batchSize, int degreeOfParallelism) throws TasteException {
        LongPrimitiveIterator itemIDs = dataModel.getItemIDs();
        int numItems = dataModel.getNumItems();
        LinkedBlockingQueue<long[]> itemIDBatches = new LinkedBlockingQueue<long[]>(numItems / batchSize + 1);
        long[] batch = new long[batchSize];
        int pos = 0;
        while (itemIDs.hasNext()) {
            batch[pos] = itemIDs.nextLong();
            if (++pos != batchSize) continue;
            itemIDBatches.add((long[])batch.clone());
            pos = 0;
        }
        if (pos > 0) {
            long[] lastBatch = new long[pos];
            System.arraycopy(batch, 0, lastBatch, 0, pos);
            itemIDBatches.add(lastBatch);
        }
        if (itemIDBatches.size() < degreeOfParallelism) {
            throw new IllegalStateException("Degree of parallelism [" + degreeOfParallelism + "] " + " is larger than number of batches [" + itemIDBatches.size() + "].");
        }
        log.info("Queued {} items in {} batches", (Object)numItems, (Object)itemIDBatches.size());
        return itemIDBatches;
    }

    private class SimilarItemsWorker
    implements Runnable {
        private final int number;
        private final BlockingQueue<long[]> itemIDBatches;
        private final BlockingQueue<List<SimilarItems>> results;
        private final AtomicInteger numActiveWorkers;

        SimilarItemsWorker(int number, BlockingQueue<long[]> itemIDBatches, BlockingQueue<List<SimilarItems>> results, AtomicInteger numActiveWorkers) {
            this.number = number;
            this.itemIDBatches = itemIDBatches;
            this.results = results;
            this.numActiveWorkers = numActiveWorkers;
        }

        @Override
        public void run() {
            int numBatchesProcessed = 0;
            while (!this.itemIDBatches.isEmpty()) {
                try {
                    long[] itemIDBatch = this.itemIDBatches.take();
                    ArrayList similarItemsOfBatch = Lists.newArrayListWithCapacity((int)itemIDBatch.length);
                    for (long itemID : itemIDBatch) {
                        List<RecommendedItem> similarItems = MultithreadedBatchItemSimilarities.this.getRecommender().mostSimilarItems(itemID, MultithreadedBatchItemSimilarities.this.getSimilarItemsPerItem());
                        similarItemsOfBatch.add(new SimilarItems(itemID, similarItems));
                    }
                    this.results.offer(similarItemsOfBatch);
                    if (++numBatchesProcessed % 5 != 0) continue;
                    log.info("worker {} processed {} batches", (Object)this.number, (Object)numBatchesProcessed);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            log.info("worker {} processed {} batches. done.", (Object)this.number, (Object)numBatchesProcessed);
            this.numActiveWorkers.decrementAndGet();
        }
    }

    private static class Output
    implements Runnable {
        private final BlockingQueue<List<SimilarItems>> results;
        private final SimilarItemsWriter writer;
        private final AtomicInteger numActiveWorkers;
        private int numSimilaritiesProcessed = 0;

        Output(BlockingQueue<List<SimilarItems>> results, SimilarItemsWriter writer, AtomicInteger numActiveWorkers) {
            this.results = results;
            this.writer = writer;
            this.numActiveWorkers = numActiveWorkers;
        }

        private int getNumSimilaritiesProcessed() {
            return this.numSimilaritiesProcessed;
        }

        @Override
        public void run() {
            while (this.numActiveWorkers.get() != 0) {
                try {
                    List<SimilarItems> similarItemsOfABatch = this.results.poll(10L, TimeUnit.MILLISECONDS);
                    if (similarItemsOfABatch == null) continue;
                    for (SimilarItems similarItems : similarItemsOfABatch) {
                        this.writer.add(similarItems);
                        this.numSimilaritiesProcessed += similarItems.numSimilarItems();
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

