/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.df.mapreduce.inmem;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.mahout.classifier.df.mapreduce.Builder;
import org.apache.mahout.common.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemInputFormat
extends InputFormat<IntWritable, NullWritable> {
    private static final Logger log = LoggerFactory.getLogger(InMemInputSplit.class);
    private Random rng;
    private Long seed;
    private boolean isSingleSeed;

    private static boolean isSingleSeed(Configuration conf) {
        return conf.getBoolean("debug.mahout.rf.single.seed", false);
    }

    public RecordReader<IntWritable, NullWritable> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        Preconditions.checkArgument((boolean)(split instanceof InMemInputSplit));
        return new InMemRecordReader((InMemInputSplit)split);
    }

    public List<InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        int numSplits = conf.getInt("mapred.map.tasks", -1);
        return this.getSplits(conf, numSplits);
    }

    public List<InputSplit> getSplits(Configuration conf, int numSplits) {
        int nbTrees = Builder.getNbTrees(conf);
        int splitSize = nbTrees / numSplits;
        this.seed = Builder.getRandomSeed(conf);
        this.isSingleSeed = InMemInputFormat.isSingleSeed(conf);
        if (this.rng != null && this.seed != null) {
            log.warn("getSplits() was called more than once and the 'seed' is set, this can lead to no-repeatable behavior");
        }
        this.rng = this.seed == null || this.isSingleSeed ? null : RandomUtils.getRandom((long)this.seed);
        int id = 0;
        ArrayList splits = Lists.newArrayListWithCapacity((int)numSplits);
        for (int index = 0; index < numSplits - 1; ++index) {
            splits.add(new InMemInputSplit(id, splitSize, this.nextSeed()));
            id += splitSize;
        }
        splits.add(new InMemInputSplit(id, nbTrees - id, this.nextSeed()));
        return splits;
    }

    private Long nextSeed() {
        if (this.seed == null) {
            return null;
        }
        if (this.isSingleSeed) {
            return this.seed;
        }
        return this.rng.nextLong();
    }

    public static class InMemInputSplit
    extends InputSplit
    implements Writable {
        private static final String[] NO_LOCATIONS = new String[0];
        private int firstId;
        private int nbTrees;
        private Long seed;

        public InMemInputSplit() {
        }

        public InMemInputSplit(int firstId, int nbTrees, Long seed) {
            this.firstId = firstId;
            this.nbTrees = nbTrees;
            this.seed = seed;
        }

        public int getFirstId() {
            return this.firstId;
        }

        public int getNbTrees() {
            return this.nbTrees;
        }

        public Long getSeed() {
            return this.seed;
        }

        public long getLength() throws IOException {
            return this.nbTrees;
        }

        public String[] getLocations() throws IOException {
            return NO_LOCATIONS;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof InMemInputSplit)) {
                return false;
            }
            InMemInputSplit split = (InMemInputSplit)((Object)obj);
            if (this.firstId != split.firstId || this.nbTrees != split.nbTrees) {
                return false;
            }
            if (this.seed == null) {
                return split.seed == null;
            }
            return this.seed.equals(split.seed);
        }

        public int hashCode() {
            return this.firstId + this.nbTrees + (this.seed == null ? 0 : this.seed.intValue());
        }

        public String toString() {
            return String.format(Locale.ENGLISH, "[firstId:%d, nbTrees:%d, seed:%d]", this.firstId, this.nbTrees, this.seed);
        }

        public void readFields(DataInput in) throws IOException {
            this.firstId = in.readInt();
            this.nbTrees = in.readInt();
            boolean isSeed = in.readBoolean();
            this.seed = isSeed ? Long.valueOf(in.readLong()) : null;
        }

        public void write(DataOutput out) throws IOException {
            out.writeInt(this.firstId);
            out.writeInt(this.nbTrees);
            out.writeBoolean(this.seed != null);
            if (this.seed != null) {
                out.writeLong(this.seed);
            }
        }

        public static InMemInputSplit read(DataInput in) throws IOException {
            InMemInputSplit split = new InMemInputSplit();
            split.readFields(in);
            return split;
        }
    }

    public static class InMemRecordReader
    extends RecordReader<IntWritable, NullWritable> {
        private final InMemInputSplit split;
        private int pos;
        private IntWritable key;
        private NullWritable value;

        public InMemRecordReader(InMemInputSplit split) {
            this.split = split;
        }

        public float getProgress() throws IOException {
            return this.pos == 0 ? 0.0f : (float)(this.pos - 1) / (float)this.split.nbTrees;
        }

        public IntWritable getCurrentKey() throws IOException, InterruptedException {
            return this.key;
        }

        public NullWritable getCurrentValue() throws IOException, InterruptedException {
            return this.value;
        }

        public void initialize(InputSplit arg0, TaskAttemptContext arg1) throws IOException, InterruptedException {
            this.key = new IntWritable();
            this.value = NullWritable.get();
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            if (this.pos < this.split.nbTrees) {
                this.key.set(this.split.firstId + this.pos);
                ++this.pos;
                return true;
            }
            return false;
        }

        public void close() throws IOException {
        }
    }
}

