/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.naivebayes.training;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.classifier.naivebayes.BayesUtils;
import org.apache.mahout.classifier.naivebayes.training.ComplementaryThetaTrainer;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public class ThetaMapper
extends Mapper<IntWritable, VectorWritable, Text, VectorWritable> {
    public static final String ALPHA_I = ThetaMapper.class.getName() + ".alphaI";
    static final String TRAIN_COMPLEMENTARY = ThetaMapper.class.getName() + ".trainComplementary";
    private ComplementaryThetaTrainer trainer;

    protected void setup(Mapper.Context ctx) throws IOException, InterruptedException {
        super.setup(ctx);
        Configuration conf = ctx.getConfiguration();
        float alphaI = conf.getFloat(ALPHA_I, 1.0f);
        Map<String, Vector> scores = BayesUtils.readScoresFromCache(conf);
        this.trainer = new ComplementaryThetaTrainer(scores.get("__SPF"), scores.get("__SPL"), alphaI);
    }

    protected void map(IntWritable key, VectorWritable value, Mapper.Context ctx) throws IOException, InterruptedException {
        this.trainer.train(key.get(), value.get());
    }

    protected void cleanup(Mapper.Context ctx) throws IOException, InterruptedException {
        ctx.write((Object)new Text("_LTN"), (Object)new VectorWritable(this.trainer.retrievePerLabelThetaNormalizer()));
        super.cleanup(ctx);
    }
}

