/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.fuzzykmeans;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.cli2.Option;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.clustering.classify.ClusterClassificationDriver;
import org.apache.mahout.clustering.classify.ClusterClassifier;
import org.apache.mahout.clustering.fuzzykmeans.FuzzyKMeansUtil;
import org.apache.mahout.clustering.iterator.ClusterIterator;
import org.apache.mahout.clustering.iterator.FuzzyKMeansClusteringPolicy;
import org.apache.mahout.clustering.kmeans.RandomSeedGenerator;
import org.apache.mahout.common.AbstractJob;
import org.apache.mahout.common.ClassUtils;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.commandline.DefaultOptionCreator;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.common.distance.SquaredEuclideanDistanceMeasure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FuzzyKMeansDriver
extends AbstractJob {
    public static final String M_OPTION = "m";
    private static final Logger log = LoggerFactory.getLogger(FuzzyKMeansDriver.class);

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Configuration)new Configuration(), (Tool)new FuzzyKMeansDriver(), (String[])args);
    }

    public int run(String[] args) throws Exception {
        this.addInputOption();
        this.addOutputOption();
        this.addOption((Option)DefaultOptionCreator.distanceMeasureOption().create());
        this.addOption((Option)DefaultOptionCreator.clustersInOption().withDescription("The input centroids, as Vectors.  Must be a SequenceFile of Writable, Cluster/Canopy.  If k is also specified, then a random set of vectors will be selected and written out to this path first").create());
        this.addOption((Option)DefaultOptionCreator.numClustersOption().withDescription("The k in k-Means.  If specified, then a random selection of k Vectors will be chosen as the Centroid and written to the clusters input path.").create());
        this.addOption((Option)DefaultOptionCreator.convergenceOption().create());
        this.addOption((Option)DefaultOptionCreator.maxIterationsOption().create());
        this.addOption((Option)DefaultOptionCreator.overwriteOption().create());
        this.addOption(M_OPTION, M_OPTION, "coefficient normalization factor, must be greater than 1", true);
        this.addOption((Option)DefaultOptionCreator.clusteringOption().create());
        this.addOption((Option)DefaultOptionCreator.emitMostLikelyOption().create());
        this.addOption((Option)DefaultOptionCreator.thresholdOption().create());
        this.addOption((Option)DefaultOptionCreator.methodOption().create());
        this.addOption((Option)DefaultOptionCreator.useSetRandomSeedOption().create());
        if (this.parseArguments(args) == null) {
            return -1;
        }
        Path input = this.getInputPath();
        Path clusters = new Path(this.getOption("clusters"));
        Path output = this.getOutputPath();
        String measureClass = this.getOption("distanceMeasure");
        if (measureClass == null) {
            measureClass = SquaredEuclideanDistanceMeasure.class.getName();
        }
        double convergenceDelta = Double.parseDouble(this.getOption("convergenceDelta"));
        float fuzziness = Float.parseFloat(this.getOption(M_OPTION));
        int maxIterations = Integer.parseInt(this.getOption("maxIter"));
        if (this.hasOption("overwrite")) {
            HadoopUtil.delete(this.getConf(), output);
        }
        boolean emitMostLikely = Boolean.parseBoolean(this.getOption("emitMostLikely"));
        double threshold = Double.parseDouble(this.getOption("threshold"));
        DistanceMeasure measure = ClassUtils.instantiateAs(measureClass, DistanceMeasure.class);
        if (this.hasOption("numClusters")) {
            int numClusters = Integer.parseInt(this.getOption("numClusters"));
            Long seed = null;
            if (this.hasOption("randomSeed")) {
                seed = Long.parseLong(this.getOption("randomSeed"));
            }
            clusters = RandomSeedGenerator.buildRandom(this.getConf(), input, clusters, numClusters, measure, seed);
        }
        boolean runClustering = this.hasOption("clustering");
        boolean runSequential = this.getOption("method").equalsIgnoreCase("sequential");
        FuzzyKMeansDriver.run(this.getConf(), input, clusters, output, convergenceDelta, maxIterations, fuzziness, runClustering, emitMostLikely, threshold, runSequential);
        return 0;
    }

    public static void run(Path input, Path clustersIn, Path output, double convergenceDelta, int maxIterations, float m, boolean runClustering, boolean emitMostLikely, double threshold, boolean runSequential) throws IOException, ClassNotFoundException, InterruptedException {
        Configuration conf = new Configuration();
        Path clustersOut = FuzzyKMeansDriver.buildClusters(conf, input, clustersIn, output, convergenceDelta, maxIterations, m, runSequential);
        if (runClustering) {
            log.info("Clustering ");
            FuzzyKMeansDriver.clusterData(conf, input, clustersOut, output, convergenceDelta, m, emitMostLikely, threshold, runSequential);
        }
    }

    public static void run(Configuration conf, Path input, Path clustersIn, Path output, double convergenceDelta, int maxIterations, float m, boolean runClustering, boolean emitMostLikely, double threshold, boolean runSequential) throws IOException, ClassNotFoundException, InterruptedException {
        Path clustersOut = FuzzyKMeansDriver.buildClusters(conf, input, clustersIn, output, convergenceDelta, maxIterations, m, runSequential);
        if (runClustering) {
            log.info("Clustering");
            FuzzyKMeansDriver.clusterData(conf, input, clustersOut, output, convergenceDelta, m, emitMostLikely, threshold, runSequential);
        }
    }

    public static Path buildClusters(Configuration conf, Path input, Path clustersIn, Path output, double convergenceDelta, int maxIterations, float m, boolean runSequential) throws IOException, InterruptedException, ClassNotFoundException {
        ArrayList clusters = Lists.newArrayList();
        FuzzyKMeansUtil.configureWithClusterInfo(conf, clustersIn, clusters);
        if (conf == null) {
            conf = new Configuration();
        }
        if (clusters.isEmpty()) {
            throw new IllegalStateException("No input clusters found in " + clustersIn + ". Check your -c argument.");
        }
        Path priorClustersPath = new Path(output, "clusters-0");
        FuzzyKMeansClusteringPolicy policy = new FuzzyKMeansClusteringPolicy(m, convergenceDelta);
        ClusterClassifier prior = new ClusterClassifier(clusters, policy);
        prior.writeToSeqFiles(priorClustersPath);
        if (runSequential) {
            ClusterIterator.iterateSeq(conf, input, priorClustersPath, output, maxIterations);
        } else {
            ClusterIterator.iterateMR(conf, input, priorClustersPath, output, maxIterations);
        }
        return output;
    }

    public static void clusterData(Configuration conf, Path input, Path clustersIn, Path output, double convergenceDelta, float m, boolean emitMostLikely, double threshold, boolean runSequential) throws IOException, ClassNotFoundException, InterruptedException {
        ClusterClassifier.writePolicy(new FuzzyKMeansClusteringPolicy(m, convergenceDelta), clustersIn);
        ClusterClassificationDriver.run(conf, input, output, new Path(output, "clusteredPoints"), threshold, emitMostLikely, runSequential);
    }
}

