/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common;

import com.google.common.primitives.Longs;
import java.io.Serializable;

public final class LongPair
implements Comparable<LongPair>,
Serializable {
    private final long first;
    private final long second;

    public LongPair(long first, long second) {
        this.first = first;
        this.second = second;
    }

    public long getFirst() {
        return this.first;
    }

    public long getSecond() {
        return this.second;
    }

    public LongPair swap() {
        return new LongPair(this.second, this.first);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LongPair)) {
            return false;
        }
        LongPair otherPair = (LongPair)obj;
        return this.first == otherPair.getFirst() && this.second == otherPair.getSecond();
    }

    public int hashCode() {
        int firstHash = Longs.hashCode((long)this.first);
        return (firstHash >>> 16 | firstHash << 16) ^ Longs.hashCode((long)this.second);
    }

    public String toString() {
        return '(' + String.valueOf(this.first) + ',' + this.second + ')';
    }

    @Override
    public int compareTo(LongPair o) {
        if (this.first < o.getFirst()) {
            return -1;
        }
        if (this.first > o.getFirst()) {
            return 1;
        }
        return this.second < o.getSecond() ? -1 : (this.second > o.getSecond() ? 1 : 0);
    }
}

