/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common.distance;

import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.DataInput;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.mahout.common.ClassUtils;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.common.parameters.ClassParameter;
import org.apache.mahout.common.parameters.Parameter;
import org.apache.mahout.common.parameters.Parametered;
import org.apache.mahout.common.parameters.PathParameter;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public abstract class WeightedDistanceMeasure
implements DistanceMeasure {
    private List<Parameter<?>> parameters;
    private Parameter<Path> weightsFile;
    private ClassParameter vectorClass;
    private Vector weights;

    @Override
    public void createParameters(String prefix, Configuration jobConf) {
        this.parameters = Lists.newArrayList();
        this.weightsFile = new PathParameter(prefix, "weightsFile", jobConf, null, "Path on DFS to a file containing the weights.");
        this.parameters.add(this.weightsFile);
        this.vectorClass = new ClassParameter(prefix, "vectorClass", jobConf, DenseVector.class, "Class<Vector> file specified in parameter weightsFile has been serialized with.");
        this.parameters.add(this.vectorClass);
    }

    @Override
    public Collection<Parameter<?>> getParameters() {
        return this.parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configure(Configuration jobConf) {
        block7: {
            if (this.parameters == null) {
                Parametered.ParameteredGeneralizations.configureParameters(this, jobConf);
            }
            try {
                if (this.weightsFile.get() == null) break block7;
                FileSystem fs = FileSystem.get((URI)this.weightsFile.get().toUri(), (Configuration)jobConf);
                VectorWritable weights = ClassUtils.instantiateAs((Class)this.vectorClass.get(), VectorWritable.class);
                if (!fs.exists(this.weightsFile.get())) {
                    throw new FileNotFoundException(this.weightsFile.get().toString());
                }
                FSDataInputStream in = fs.open(this.weightsFile.get());
                try {
                    weights.readFields((DataInput)in);
                }
                finally {
                    Closeables.close((Closeable)in, (boolean)true);
                }
                this.weights = weights.get();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public Vector getWeights() {
        return this.weights;
    }

    public void setWeights(Vector weights) {
        this.weights = weights;
    }
}

