/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.ep;

import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.classifier.sgd.PolymorphicWritable;
import org.apache.mahout.ep.Payload;
import org.apache.mahout.ep.State;

public class EvolutionaryProcess<T extends Payload<U>, U>
implements Writable,
Closeable {
    private ExecutorService pool;
    private int threadCount;
    private List<State<T, U>> population;
    private int populationSize;

    public EvolutionaryProcess() {
        this.population = Lists.newArrayList();
    }

    public EvolutionaryProcess(int threadCount, int populationSize, State<T, U> seed) {
        this.populationSize = populationSize;
        this.setThreadCount(threadCount);
        this.initializePopulation(populationSize, seed);
    }

    private void initializePopulation(int populationSize, State<T, U> seed) {
        this.population = Lists.newArrayList((Object[])new State[]{seed});
        for (int i = 0; i < populationSize; ++i) {
            this.population.add(seed.mutate());
        }
    }

    public void add(State<T, U> value) {
        this.population.add(value);
    }

    public void mutatePopulation(int survivors) {
        Collections.sort(this.population);
        ArrayList parents = Lists.newArrayList(this.population.subList(0, survivors));
        this.population.subList(survivors, this.population.size()).clear();
        int i = 0;
        while (this.population.size() < this.populationSize) {
            this.population.add(((State)parents.get(i % survivors)).mutate());
            ++i;
        }
    }

    public State<T, U> parallelDo(final Function<Payload<U>> fn) throws InterruptedException, ExecutionException {
        ArrayList tasks = Lists.newArrayList();
        for (final State<T, U> state : this.population) {
            tasks.add(new Callable<State<T, U>>(){

                @Override
                public State<T, U> call() {
                    double v = fn.apply(state.getPayload(), state.getMappedParams());
                    state.setValue(v);
                    return state;
                }
            });
        }
        List r = this.pool.invokeAll(tasks);
        double max = Double.NEGATIVE_INFINITY;
        State best = null;
        for (Future future : r) {
            State s = (State)future.get();
            double value = s.getValue();
            if (Double.isNaN(value) || !(value >= max)) continue;
            max = value;
            best = s;
        }
        if (best == null) {
            best = (State)r.get(0).get();
        }
        return best;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
        this.pool = Executors.newFixedThreadPool(threadCount);
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public int getPopulationSize() {
        return this.populationSize;
    }

    public List<State<T, U>> getPopulation() {
        return this.population;
    }

    @Override
    public void close() {
        List<Runnable> remainingTasks = this.pool.shutdownNow();
        try {
            this.pool.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Had to forcefully shut down " + remainingTasks.size() + " tasks");
        }
        if (!remainingTasks.isEmpty()) {
            throw new IllegalStateException("Had to forcefully shut down " + remainingTasks.size() + " tasks");
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.threadCount);
        out.writeInt(this.population.size());
        for (State<T, U> state : this.population) {
            PolymorphicWritable.write(out, state);
        }
    }

    public void readFields(DataInput input) throws IOException {
        this.setThreadCount(input.readInt());
        int n = input.readInt();
        this.population = Lists.newArrayList();
        for (int i = 0; i < n; ++i) {
            State state = PolymorphicWritable.read(input, State.class);
            this.population.add(state);
        }
    }

    public static interface Function<T> {
        public double apply(T var1, double[] var2);
    }
}

