/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.common.AbstractJob;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.mapreduce.MergeVectorsCombiner;
import org.apache.mahout.common.mapreduce.MergeVectorsReducer;
import org.apache.mahout.common.mapreduce.TransposeMapper;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.hadoop.DistributedRowMatrix;

public class TransposeJob
extends AbstractJob {
    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new TransposeJob(), (String[])args);
    }

    public int run(String[] strings) throws Exception {
        this.addInputOption();
        this.addOption("numRows", "nr", "Number of rows of the input matrix");
        this.addOption("numCols", "nc", "Number of columns of the input matrix");
        Map<String, List<String>> parsedArgs = this.parseArguments(strings);
        if (parsedArgs == null) {
            return -1;
        }
        int numRows = Integer.parseInt(this.getOption("numRows"));
        int numCols = Integer.parseInt(this.getOption("numCols"));
        DistributedRowMatrix matrix = new DistributedRowMatrix(this.getInputPath(), this.getTempPath(), numRows, numCols);
        matrix.setConf(new Configuration(this.getConf()));
        matrix.transpose();
        return 0;
    }

    public static Job buildTransposeJob(Path matrixInputPath, Path matrixOutputPath, int numInputRows) throws IOException {
        return TransposeJob.buildTransposeJob(new Configuration(), matrixInputPath, matrixOutputPath, numInputRows);
    }

    public static Job buildTransposeJob(Configuration initialConf, Path matrixInputPath, Path matrixOutputPath, int numInputRows) throws IOException {
        Job job = HadoopUtil.prepareJob(matrixInputPath, matrixOutputPath, SequenceFileInputFormat.class, TransposeMapper.class, IntWritable.class, VectorWritable.class, MergeVectorsReducer.class, IntWritable.class, VectorWritable.class, SequenceFileOutputFormat.class, initialConf);
        job.setCombinerClass(MergeVectorsCombiner.class);
        job.getConfiguration().setInt(TransposeMapper.NEW_NUM_COLS_PARAM, numInputRows);
        job.setJobName("TransposeJob: " + matrixInputPath);
        return job;
    }
}

