/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.similarity.cooccurrence;

import com.google.common.base.Preconditions;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.mahout.common.iterator.FixedSizeSamplingIterator;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.Varint;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.hadoop.similarity.cooccurrence.MutableElement;
import org.apache.mahout.math.hadoop.similarity.cooccurrence.TopElementsQueue;
import org.apache.mahout.math.map.OpenIntIntHashMap;

public final class Vectors {
    private Vectors() {
    }

    public static Vector maybeSample(Vector original, int sampleSize) {
        if (original.getNumNondefaultElements() <= sampleSize) {
            return original;
        }
        RandomAccessSparseVector sample = new RandomAccessSparseVector(original.size(), sampleSize);
        FixedSizeSamplingIterator sampledElements = new FixedSizeSamplingIterator(sampleSize, original.nonZeroes().iterator());
        while (sampledElements.hasNext()) {
            Vector.Element elem = (Vector.Element)sampledElements.next();
            sample.setQuick(elem.index(), elem.get());
        }
        return sample;
    }

    public static Vector topKElements(int k, Vector original) {
        if (original.getNumNondefaultElements() <= k) {
            return original;
        }
        TopElementsQueue topKQueue = new TopElementsQueue(k);
        for (Vector.Element nonZeroElement : original.nonZeroes()) {
            MutableElement mutableElement = (MutableElement)topKQueue.top();
            double candidateValue = nonZeroElement.get();
            if (!(candidateValue > mutableElement.get())) continue;
            mutableElement.setIndex(nonZeroElement.index());
            mutableElement.set(candidateValue);
            topKQueue.updateTop();
        }
        RandomAccessSparseVector topKSimilarities = new RandomAccessSparseVector(original.size(), k);
        for (Vector.Element element : topKQueue.getTopElements()) {
            topKSimilarities.setQuick(element.index(), element.get());
        }
        return topKSimilarities;
    }

    public static Vector merge(Iterable<VectorWritable> partialVectors) {
        Iterator<VectorWritable> vectors = partialVectors.iterator();
        Vector accumulator = vectors.next().get();
        while (vectors.hasNext()) {
            VectorWritable v = vectors.next();
            if (v == null) continue;
            for (Vector.Element nonZeroElement : v.get().nonZeroes()) {
                accumulator.setQuick(nonZeroElement.index(), nonZeroElement.get());
            }
        }
        return accumulator;
    }

    public static Vector sum(Iterator<VectorWritable> vectors) {
        Vector sum = vectors.next().get();
        while (vectors.hasNext()) {
            sum.assign(vectors.next().get(), Functions.PLUS);
        }
        return sum;
    }

    public static Vector.Element[] toArray(VectorWritable vectorWritable) {
        Vector.Element[] elements = new Vector.Element[vectorWritable.get().getNumNondefaultElements()];
        int k = 0;
        for (Vector.Element nonZeroElement : vectorWritable.get().nonZeroes()) {
            elements[k++] = new TemporaryElement(nonZeroElement.index(), nonZeroElement.get());
        }
        return elements;
    }

    public static void write(Vector vector, Path path, Configuration conf) throws IOException {
        Vectors.write(vector, path, conf, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(Vector vector, Path path, Configuration conf, boolean laxPrecision) throws IOException {
        FileSystem fs = FileSystem.get((URI)path.toUri(), (Configuration)conf);
        FSDataOutputStream out = fs.create(path);
        try {
            VectorWritable vectorWritable = new VectorWritable(vector);
            vectorWritable.setWritesLaxPrecision(laxPrecision);
            vectorWritable.write((DataOutput)out);
        }
        finally {
            Closeables.close((Closeable)out, (boolean)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OpenIntIntHashMap readAsIntMap(Path path, Configuration conf) throws IOException {
        FileSystem fs = FileSystem.get((URI)path.toUri(), (Configuration)conf);
        FSDataInputStream in = fs.open(path);
        try {
            OpenIntIntHashMap openIntIntHashMap = Vectors.readAsIntMap((DataInput)in);
            return openIntIntHashMap;
        }
        finally {
            Closeables.close((Closeable)in, (boolean)true);
        }
    }

    private static OpenIntIntHashMap readAsIntMap(DataInput in) throws IOException {
        byte flags = in.readByte();
        Preconditions.checkArgument((flags >> 4 == 0 ? 1 : 0) != 0, (String)"Unknown flags set: %d", (Object[])new Object[]{Integer.toString(flags, 2)});
        boolean dense = (flags & 1) != 0;
        boolean sequential = (flags & 2) != 0;
        boolean laxPrecision = (flags & 8) != 0;
        Preconditions.checkState((!dense && !sequential ? 1 : 0) != 0, (Object)"Only for reading sparse vectors!");
        Varint.readUnsignedVarInt(in);
        OpenIntIntHashMap values = new OpenIntIntHashMap();
        int numNonDefaultElements = Varint.readUnsignedVarInt(in);
        for (int i = 0; i < numNonDefaultElements; ++i) {
            int index = Varint.readUnsignedVarInt(in);
            double value = laxPrecision ? (double)in.readFloat() : in.readDouble();
            values.put(index, (int)value);
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector read(Path path, Configuration conf) throws IOException {
        FileSystem fs = FileSystem.get((URI)path.toUri(), (Configuration)conf);
        FSDataInputStream in = fs.open(path);
        try {
            Vector vector = VectorWritable.readVector((DataInput)in);
            return vector;
        }
        finally {
            Closeables.close((Closeable)in, (boolean)true);
        }
    }

    static class TemporaryElement
    implements Vector.Element {
        private final int index;
        private double value;

        TemporaryElement(int index, double value) {
            this.index = index;
            this.value = value;
        }

        TemporaryElement(Vector.Element toClone) {
            this(toClone.index(), toClone.get());
        }

        public double get() {
            return this.value;
        }

        public int index() {
            return this.index;
        }

        public void set(double value) {
            this.value = value;
        }
    }
}

