/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.stochasticsvd;

import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.text.NumberFormat;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.regex.Matcher;
import org.apache.commons.lang3.Validate;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.IOUtils;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.iterator.sequencefile.PathType;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileDirIterator;
import org.apache.mahout.math.SequentialAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.hadoop.stochasticsvd.BtJob;
import org.apache.mahout.math.hadoop.stochasticsvd.DenseBlockWritable;
import org.apache.mahout.math.hadoop.stochasticsvd.SparseRowBlockAccumulator;
import org.apache.mahout.math.hadoop.stochasticsvd.SparseRowBlockWritable;
import org.apache.mahout.math.hadoop.stochasticsvd.SplitPartitionedWritable;
import org.apache.mahout.math.hadoop.stochasticsvd.qr.QRFirstStep;

public final class ABtJob {
    public static final String PROP_BT_PATH = "ssvd.Bt.path";
    public static final String PROP_BT_BROADCAST = "ssvd.Bt.broadcast";

    private ABtJob() {
    }

    public static void run(Configuration conf, Path[] inputAPaths, Path inputBtGlob, Path outputPath, int aBlockRows, int minSplitSize, int k, int p, int outerProdBlockHeight, int numReduceTasks, boolean broadcastBInput) throws ClassNotFoundException, InterruptedException, IOException {
        JobConf oldApiJob = new JobConf(conf);
        Job job = new Job((Configuration)oldApiJob);
        job.setJobName("ABt-job");
        job.setJarByClass(ABtJob.class);
        job.setInputFormatClass(SequenceFileInputFormat.class);
        FileInputFormat.setInputPaths((Job)job, (Path[])inputAPaths);
        if (minSplitSize > 0) {
            FileInputFormat.setMinInputSplitSize((Job)job, (long)minSplitSize);
        }
        FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
        SequenceFileOutputFormat.setOutputCompressionType((Job)job, (SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK);
        job.setMapOutputKeyClass(SplitPartitionedWritable.class);
        job.setMapOutputValueClass(SparseRowBlockWritable.class);
        job.setOutputKeyClass(SplitPartitionedWritable.class);
        job.setOutputValueClass(VectorWritable.class);
        job.setMapperClass(ABtMapper.class);
        job.setCombinerClass(BtJob.OuterProductCombiner.class);
        job.setReducerClass(QRReducer.class);
        job.getConfiguration().setInt("ssvd.arowblock.size", aBlockRows);
        job.getConfiguration().setInt("ssvd.outerProdBlockHeight", outerProdBlockHeight);
        job.getConfiguration().setInt("ssvd.k", k);
        job.getConfiguration().setInt("ssvd.p", p);
        job.getConfiguration().set(PROP_BT_PATH, inputBtGlob.toString());
        job.setNumReduceTasks(numReduceTasks);
        if (broadcastBInput) {
            job.getConfiguration().set(PROP_BT_BROADCAST, "y");
            FileSystem fs = FileSystem.get((URI)inputBtGlob.toUri(), (Configuration)conf);
            FileStatus[] fstats = fs.globStatus(inputBtGlob);
            if (fstats != null) {
                for (FileStatus fstat : fstats) {
                    DistributedCache.addCacheFile((URI)fstat.getPath().toUri(), (Configuration)conf);
                }
            }
        }
        job.submit();
        job.waitForCompletion(false);
        if (!job.isSuccessful()) {
            throw new IOException("ABt job unsuccessful.");
        }
    }

    public static class QRReducer
    extends Reducer<SplitPartitionedWritable, SparseRowBlockWritable, SplitPartitionedWritable, VectorWritable> {
        private static final NumberFormat NUMBER_FORMAT = NumberFormat.getInstance();
        private final Deque<Closeable> closeables = Lists.newLinkedList();
        protected final SparseRowBlockWritable accum = new SparseRowBlockWritable();
        protected int blockHeight;
        protected int lastTaskId = -1;
        protected OutputCollector<Writable, DenseBlockWritable> qhatCollector;
        protected OutputCollector<Writable, VectorWritable> rhatCollector;
        protected QRFirstStep qr;

        protected void setup(Reducer.Context context) throws IOException, InterruptedException {
            this.blockHeight = context.getConfiguration().getInt("ssvd.outerProdBlockHeight", -1);
        }

        protected void setupBlock(Reducer.Context context, SplitPartitionedWritable spw) throws InterruptedException, IOException {
            IOUtils.close(this.closeables);
            this.qhatCollector = this.createOutputCollector("QHat", spw, context, DenseBlockWritable.class);
            this.rhatCollector = this.createOutputCollector("R", spw, context, VectorWritable.class);
            this.qr = new QRFirstStep(context.getConfiguration(), this.qhatCollector, this.rhatCollector);
            this.closeables.addFirst(this.qr);
            this.lastTaskId = spw.getTaskId();
        }

        protected void reduce(SplitPartitionedWritable key, Iterable<SparseRowBlockWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            this.accum.clear();
            for (SparseRowBlockWritable bw : values) {
                this.accum.plusBlock(bw);
            }
            if (key.getTaskId() != this.lastTaskId) {
                this.setupBlock(context, key);
            }
            long blockBase = key.getTaskItemOrdinal() * (long)this.blockHeight;
            for (int k = 0; k < this.accum.getNumRows(); ++k) {
                Vector yiRow = this.accum.getRows()[k];
                key.setTaskItemOrdinal(blockBase + (long)this.accum.getRowIndices()[k]);
                this.qr.collect((Writable)key, yiRow);
            }
        }

        private Path getSplitFilePath(String name, SplitPartitionedWritable spw, Reducer.Context context) throws InterruptedException, IOException {
            String uniqueFileName = FileOutputFormat.getUniqueFile((TaskAttemptContext)context, (String)name, (String)"");
            uniqueFileName = uniqueFileName.replaceFirst("-r-", "-m-");
            uniqueFileName = uniqueFileName.replaceFirst("\\d+$", Matcher.quoteReplacement(NUMBER_FORMAT.format(spw.getTaskId())));
            return new Path(FileOutputFormat.getWorkOutputPath((TaskInputOutputContext)context), uniqueFileName);
        }

        private <K, V> OutputCollector<K, V> createOutputCollector(String name, final SplitPartitionedWritable spw, Reducer.Context ctx, Class<V> valueClass) throws IOException, InterruptedException {
            Path outputPath = this.getSplitFilePath(name, spw, ctx);
            final SequenceFile.Writer w = SequenceFile.createWriter((FileSystem)FileSystem.get((URI)outputPath.toUri(), (Configuration)ctx.getConfiguration()), (Configuration)ctx.getConfiguration(), (Path)outputPath, SplitPartitionedWritable.class, valueClass);
            this.closeables.addFirst((Closeable)w);
            return new OutputCollector<K, V>(){

                public void collect(K key, V val) throws IOException {
                    w.append((Object)spw, val);
                }
            };
        }

        protected void cleanup(Reducer.Context context) throws IOException, InterruptedException {
            IOUtils.close(this.closeables);
        }

        static {
            NUMBER_FORMAT.setMinimumIntegerDigits(5);
            NUMBER_FORMAT.setGroupingUsed(false);
        }
    }

    public static class ABtMapper
    extends Mapper<Writable, VectorWritable, SplitPartitionedWritable, SparseRowBlockWritable> {
        private SplitPartitionedWritable outKey;
        private final Deque<Closeable> closeables = new ArrayDeque<Closeable>();
        private SequenceFileDirIterator<IntWritable, VectorWritable> btInput;
        private Vector[] aCols;
        private int aRowCount;
        private int kp;
        private int blockHeight;
        private SparseRowBlockAccumulator yiCollector;

        protected void map(Writable key, VectorWritable value, Mapper.Context context) throws IOException, InterruptedException {
            Vector vec = value.get();
            int vecSize = vec.size();
            if (this.aCols == null) {
                this.aCols = new Vector[vecSize];
            } else if (this.aCols.length < vecSize) {
                this.aCols = Arrays.copyOf(this.aCols, vecSize);
            }
            if (vec.isDense()) {
                for (int i = 0; i < vecSize; ++i) {
                    this.extendAColIfNeeded(i, this.aRowCount + 1);
                    this.aCols[i].setQuick(this.aRowCount, vec.getQuick(i));
                }
            } else {
                for (Vector.Element vecEl : vec.nonZeroes()) {
                    int i = vecEl.index();
                    this.extendAColIfNeeded(i, this.aRowCount + 1);
                    this.aCols[i].setQuick(this.aRowCount, vecEl.get());
                }
            }
            ++this.aRowCount;
        }

        private void extendAColIfNeeded(int col, int rowCount) {
            if (this.aCols[col] == null) {
                this.aCols[col] = new SequentialAccessSparseVector(rowCount < 10000 ? 10000 : rowCount, 1);
            } else if (this.aCols[col].size() < rowCount) {
                SequentialAccessSparseVector newVec = new SequentialAccessSparseVector(rowCount << 1, this.aCols[col].getNumNondefaultElements() << 1);
                newVec.viewPart(0, this.aCols[col].size()).assign(this.aCols[col]);
                this.aCols[col] = newVec;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
            try {
                int lastRowIndex = -1;
                while (this.btInput.hasNext()) {
                    Vector aCol;
                    Pair btRec = (Pair)this.btInput.next();
                    int btIndex = ((IntWritable)btRec.getFirst()).get();
                    Vector btVec = ((VectorWritable)((Object)btRec.getSecond())).get();
                    if (btIndex > this.aCols.length || (aCol = this.aCols[btIndex]) == null) continue;
                    int j = -1;
                    for (Vector.Element aEl : aCol.nonZeroes()) {
                        j = aEl.index();
                        this.yiCollector.collect(Long.valueOf(j), btVec.times(aEl.get()));
                    }
                    if (lastRowIndex >= j) continue;
                    lastRowIndex = j;
                }
                this.aCols = null;
                SequentialAccessSparseVector yDummy = new SequentialAccessSparseVector(this.kp);
                ++lastRowIndex;
                while (lastRowIndex < this.aRowCount) {
                    this.yiCollector.collect(Long.valueOf(lastRowIndex), (Vector)yDummy);
                    ++lastRowIndex;
                }
            }
            finally {
                IOUtils.close(this.closeables);
            }
        }

        protected void setup(final Mapper.Context context) throws IOException, InterruptedException {
            boolean distributedBt;
            int k = Integer.parseInt(context.getConfiguration().get("ssvd.k"));
            int p = Integer.parseInt(context.getConfiguration().get("ssvd.p"));
            this.kp = k + p;
            this.outKey = new SplitPartitionedWritable(context);
            String propBtPathStr = context.getConfiguration().get(ABtJob.PROP_BT_PATH);
            Validate.notNull((Object)propBtPathStr, (String)"Bt input is not set", (Object[])new Object[0]);
            Path btPath = new Path(propBtPathStr);
            boolean bl = distributedBt = context.getConfiguration().get(ABtJob.PROP_BT_BROADCAST) != null;
            if (distributedBt) {
                Path[] btFiles = HadoopUtil.getCachedFiles(context.getConfiguration());
                StringBuilder btLocalPath = new StringBuilder();
                for (Path btFile : btFiles) {
                    if (btLocalPath.length() > 0) {
                        btLocalPath.append('/');
                    }
                    btLocalPath.append(btFile);
                }
                this.btInput = new SequenceFileDirIterator(new Path(btLocalPath.toString()), PathType.LIST, null, null, true, context.getConfiguration());
            } else {
                this.btInput = new SequenceFileDirIterator(btPath, PathType.GLOB, null, null, true, context.getConfiguration());
            }
            this.closeables.addFirst(this.btInput);
            OutputCollector<LongWritable, SparseRowBlockWritable> yiBlockCollector = new OutputCollector<LongWritable, SparseRowBlockWritable>(){

                public void collect(LongWritable blockKey, SparseRowBlockWritable block) throws IOException {
                    ABtMapper.this.outKey.setTaskItemOrdinal((int)blockKey.get());
                    try {
                        context.write((Object)ABtMapper.this.outKey, (Object)block);
                    }
                    catch (InterruptedException exc) {
                        throw new IOException("Interrupted", exc);
                    }
                }
            };
            this.blockHeight = context.getConfiguration().getInt("ssvd.outerProdBlockHeight", -1);
            this.yiCollector = new SparseRowBlockAccumulator(this.blockHeight, yiBlockCollector);
            this.closeables.addFirst(this.yiCollector);
        }
    }
}

