/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.neighborhood;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.BoundType;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultiset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.neighborhood.UpdatableSearcher;
import org.apache.mahout.math.random.RandomProjector;
import org.apache.mahout.math.random.WeightedThing;

public class ProjectionSearch
extends UpdatableSearcher {
    private List<TreeMultiset<WeightedThing<Vector>>> scalarProjections;
    private Matrix basisMatrix;
    private final int searchSize;
    private final int numProjections;
    private boolean initialized = false;

    private void initialize(int numDimensions) {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.basisMatrix = RandomProjector.generateBasisNormal(this.numProjections, numDimensions);
        this.scalarProjections = Lists.newArrayList();
        for (int i = 0; i < this.numProjections; ++i) {
            this.scalarProjections.add((TreeMultiset<WeightedThing<Vector>>)TreeMultiset.create());
        }
    }

    public ProjectionSearch(DistanceMeasure distanceMeasure, int numProjections, int searchSize) {
        super(distanceMeasure);
        Preconditions.checkArgument((numProjections > 0 && numProjections < 100 ? 1 : 0) != 0, (Object)"Unreasonable value for number of projections. Must be: 0 < numProjections < 100");
        this.searchSize = searchSize;
        this.numProjections = numProjections;
    }

    @Override
    public void add(Vector vector) {
        this.initialize(vector.size());
        Vector projection = this.basisMatrix.times(vector);
        int i = 0;
        for (TreeMultiset<WeightedThing<Vector>> s : this.scalarProjections) {
            s.add((Object)new WeightedThing((Object)vector, projection.get(i++)));
        }
        int numVectors = this.scalarProjections.get(0).size();
        for (TreeMultiset<WeightedThing<Vector>> s : this.scalarProjections) {
            Preconditions.checkArgument((s.size() == numVectors ? 1 : 0) != 0, (Object)"Number of vectors in projection sets differ");
            double firstWeight = ((WeightedThing)s.firstEntry().getElement()).getWeight();
            for (WeightedThing w : s) {
                Preconditions.checkArgument((firstWeight <= w.getWeight() ? 1 : 0) != 0, (Object)"Weights not in non-decreasing order");
                firstWeight = w.getWeight();
            }
        }
    }

    @Override
    public int size() {
        if (this.scalarProjections == null) {
            return 0;
        }
        return this.scalarProjections.get(0).size();
    }

    @Override
    public List<WeightedThing<Vector>> search(Vector query, int limit) {
        HashSet candidates = Sets.newHashSet();
        Iterator projections = this.basisMatrix.iterator();
        for (TreeMultiset<WeightedThing<Vector>> v : this.scalarProjections) {
            Vector basisVector = (Vector)projections.next();
            WeightedThing projectedQuery = new WeightedThing((Object)query, query.dot(basisVector));
            for (WeightedThing candidate : Iterables.concat((Iterable)Iterables.limit((Iterable)v.tailMultiset((Object)projectedQuery, BoundType.CLOSED), (int)this.searchSize), (Iterable)Iterables.limit((Iterable)v.headMultiset((Object)projectedQuery, BoundType.OPEN).descendingMultiset(), (int)this.searchSize))) {
                candidates.add(candidate.getValue());
            }
        }
        ArrayList top = Lists.newArrayList();
        for (Vector candidate : candidates) {
            top.add(new WeightedThing((Object)candidate, this.distanceMeasure.distance(query, candidate)));
        }
        Collections.sort(top);
        return top.subList(0, Math.min(limit, top.size()));
    }

    @Override
    public WeightedThing<Vector> searchFirst(Vector query, boolean differentThanQuery) {
        double bestDistance = Double.POSITIVE_INFINITY;
        Vector bestVector = null;
        Iterator projections = this.basisMatrix.iterator();
        for (TreeMultiset<WeightedThing<Vector>> v : this.scalarProjections) {
            Vector basisVector = (Vector)projections.next();
            WeightedThing projectedQuery = new WeightedThing((Object)query, query.dot(basisVector));
            for (WeightedThing candidate : Iterables.concat((Iterable)Iterables.limit((Iterable)v.tailMultiset((Object)projectedQuery, BoundType.CLOSED), (int)this.searchSize), (Iterable)Iterables.limit((Iterable)v.headMultiset((Object)projectedQuery, BoundType.OPEN).descendingMultiset(), (int)this.searchSize))) {
                double distance = this.distanceMeasure.distance(query, (Vector)candidate.getValue());
                if (!(distance < bestDistance) || differentThanQuery && ((Vector)candidate.getValue()).equals(query)) continue;
                bestDistance = distance;
                bestVector = (Vector)candidate.getValue();
            }
        }
        return new WeightedThing(bestVector, bestDistance);
    }

    @Override
    public Iterator<Vector> iterator() {
        return new AbstractIterator<Vector>(){
            private final Iterator<WeightedThing<Vector>> projected;
            {
                this.projected = ((TreeMultiset)ProjectionSearch.this.scalarProjections.get(0)).iterator();
            }

            protected Vector computeNext() {
                if (!this.projected.hasNext()) {
                    return (Vector)this.endOfData();
                }
                return (Vector)this.projected.next().getValue();
            }
        };
    }

    @Override
    public boolean remove(Vector vector, double epsilon) {
        WeightedThing<Vector> toRemove = this.searchFirst(vector, false);
        if (toRemove.getWeight() < epsilon) {
            Iterator basisVectors = this.basisMatrix.iterator();
            for (TreeMultiset<WeightedThing<Vector>> projection : this.scalarProjections) {
                if (projection.remove((Object)new WeightedThing((Object)vector, vector.dot((Vector)basisVectors.next())))) continue;
                throw new RuntimeException("Internal inconsistency in ProjectionSearch");
            }
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.scalarProjections == null) {
            return;
        }
        for (TreeMultiset<WeightedThing<Vector>> set : this.scalarProjections) {
            set.clear();
        }
    }
}

