/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.vectorizer.encoders;

import com.google.common.base.Charsets;
import org.apache.mahout.math.Vector;
import org.apache.mahout.vectorizer.encoders.CachingValueEncoder;

public class ContinuousValueEncoder
extends CachingValueEncoder {
    public ContinuousValueEncoder(String name) {
        super(name, 1);
    }

    @Override
    public void addToVector(byte[] originalForm, double weight, Vector data) {
        int probes = this.getProbes();
        String name = this.getName();
        for (int i = 0; i < probes; ++i) {
            int n = this.hashForProbe(originalForm, data.size(), name, i);
            if (this.isTraceEnabled()) {
                this.trace((String)null, n);
            }
            data.set(n, data.get(n) + this.getWeight(originalForm, weight));
        }
    }

    @Override
    protected double getWeight(byte[] originalForm, double w) {
        if (originalForm == null) {
            return w;
        }
        return w * Double.parseDouble(new String(originalForm, Charsets.UTF_8));
    }

    @Override
    public String asString(String originalForm) {
        return this.getName() + ':' + originalForm;
    }

    @Override
    protected int getSeed() {
        return 1;
    }
}

