/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl.resolver;

import java.util.stream.Collectors;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectStepData;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.DependencyRequest;

public final class RequestTraceHelper {
    public static String interpretTrace(boolean detailed, RequestTrace requestTrace) {
        while (requestTrace != null) {
            Object data = requestTrace.getData();
            if (data instanceof DependencyRequest) {
                DependencyRequest request = (DependencyRequest)data;
                return "dependency resolution for " + request;
            }
            if (data instanceof CollectRequest) {
                CollectRequest request = (CollectRequest)data;
                return "dependency collection for " + request;
            }
            if (data instanceof CollectStepData) {
                CollectStepData stepData = (CollectStepData)data;
                String msg = "dependency collection step for " + stepData.getContext();
                if (detailed) {
                    msg = msg + ". Path to offending node from root:\n";
                    msg = msg + stepData.getPath().stream().map(n -> " -> " + n.toString()).collect(Collectors.joining("\n"));
                    msg = msg + "\n => " + stepData.getNode();
                }
                return msg;
            }
            if (data instanceof ArtifactDescriptorRequest) {
                ArtifactDescriptorRequest request = (ArtifactDescriptorRequest)data;
                return "artifact descriptor request for " + request.getArtifact();
            }
            if (data instanceof ArtifactRequest) {
                ArtifactRequest request = (ArtifactRequest)data;
                return "artifact request for " + request.getArtifact();
            }
            requestTrace = requestTrace.getParent();
        }
        return "n/a";
    }
}

