/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.plugin.descriptor;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.plugin.descriptor.ImmutableCollections;
import org.apache.maven.api.plugin.descriptor.Parameter;
import org.apache.maven.api.plugin.descriptor.Resolution;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class MojoDescriptor
implements Serializable {
    final String goal;
    final String description;
    final String implementation;
    final String language;
    final String phase;
    final String executePhase;
    final String executeGoal;
    final String executeLifecycle;
    final String dependencyResolution;
    final String dependencyCollection;
    final boolean directInvocationOnly;
    final boolean projectRequired;
    final boolean onlineRequired;
    final boolean aggregator;
    final boolean inheritedByDefault;
    final String since;
    final String deprecated;
    final String configurator;
    final List<Parameter> parameters;
    final List<Resolution> resolutions;
    final String id;
    final String fullGoalName;

    MojoDescriptor(String goal, String description, String implementation, String language, String phase, String executePhase, String executeGoal, String executeLifecycle, String dependencyResolution, String dependencyCollection, boolean directInvocationOnly, boolean projectRequired, boolean onlineRequired, boolean aggregator, boolean inheritedByDefault, String since, String deprecated, String configurator, Collection<Parameter> parameters, Collection<Resolution> resolutions, String id, String fullGoalName) {
        this.goal = goal;
        this.description = description;
        this.implementation = implementation;
        this.language = language;
        this.phase = phase;
        this.executePhase = executePhase;
        this.executeGoal = executeGoal;
        this.executeLifecycle = executeLifecycle;
        this.dependencyResolution = dependencyResolution;
        this.dependencyCollection = dependencyCollection;
        this.directInvocationOnly = directInvocationOnly;
        this.projectRequired = projectRequired;
        this.onlineRequired = onlineRequired;
        this.aggregator = aggregator;
        this.inheritedByDefault = inheritedByDefault;
        this.since = since;
        this.deprecated = deprecated;
        this.configurator = configurator;
        this.parameters = ImmutableCollections.copy(parameters);
        this.resolutions = ImmutableCollections.copy(resolutions);
        this.id = id;
        this.fullGoalName = fullGoalName;
    }

    public String getGoal() {
        return this.goal;
    }

    public String getDescription() {
        return this.description;
    }

    public String getImplementation() {
        return this.implementation;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getPhase() {
        return this.phase;
    }

    public String getExecutePhase() {
        return this.executePhase;
    }

    public String getExecuteGoal() {
        return this.executeGoal;
    }

    public String getExecuteLifecycle() {
        return this.executeLifecycle;
    }

    public String getDependencyResolution() {
        return this.dependencyResolution;
    }

    public String getDependencyCollection() {
        return this.dependencyCollection;
    }

    public boolean isDirectInvocationOnly() {
        return this.directInvocationOnly;
    }

    public boolean isProjectRequired() {
        return this.projectRequired;
    }

    public boolean isOnlineRequired() {
        return this.onlineRequired;
    }

    public boolean isAggregator() {
        return this.aggregator;
    }

    public boolean isInheritedByDefault() {
        return this.inheritedByDefault;
    }

    public String getSince() {
        return this.since;
    }

    public String getDeprecated() {
        return this.deprecated;
    }

    public String getConfigurator() {
        return this.configurator;
    }

    @Nonnull
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    @Nonnull
    public List<Resolution> getResolutions() {
        return this.resolutions;
    }

    public String getId() {
        return this.id;
    }

    public String getFullGoalName() {
        return this.fullGoalName;
    }

    @Nonnull
    public Builder with() {
        return MojoDescriptor.newBuilder(this);
    }

    @Nonnull
    public MojoDescriptor withGoal(String goal) {
        return MojoDescriptor.newBuilder(this, true).goal(goal).build();
    }

    @Nonnull
    public MojoDescriptor withDescription(String description) {
        return MojoDescriptor.newBuilder(this, true).description(description).build();
    }

    @Nonnull
    public MojoDescriptor withImplementation(String implementation) {
        return MojoDescriptor.newBuilder(this, true).implementation(implementation).build();
    }

    @Nonnull
    public MojoDescriptor withLanguage(String language) {
        return MojoDescriptor.newBuilder(this, true).language(language).build();
    }

    @Nonnull
    public MojoDescriptor withPhase(String phase) {
        return MojoDescriptor.newBuilder(this, true).phase(phase).build();
    }

    @Nonnull
    public MojoDescriptor withExecutePhase(String executePhase) {
        return MojoDescriptor.newBuilder(this, true).executePhase(executePhase).build();
    }

    @Nonnull
    public MojoDescriptor withExecuteGoal(String executeGoal) {
        return MojoDescriptor.newBuilder(this, true).executeGoal(executeGoal).build();
    }

    @Nonnull
    public MojoDescriptor withExecuteLifecycle(String executeLifecycle) {
        return MojoDescriptor.newBuilder(this, true).executeLifecycle(executeLifecycle).build();
    }

    @Nonnull
    public MojoDescriptor withDependencyResolution(String dependencyResolution) {
        return MojoDescriptor.newBuilder(this, true).dependencyResolution(dependencyResolution).build();
    }

    @Nonnull
    public MojoDescriptor withDependencyCollection(String dependencyCollection) {
        return MojoDescriptor.newBuilder(this, true).dependencyCollection(dependencyCollection).build();
    }

    @Nonnull
    public MojoDescriptor withDirectInvocationOnly(boolean directInvocationOnly) {
        return MojoDescriptor.newBuilder(this, true).directInvocationOnly(directInvocationOnly).build();
    }

    @Nonnull
    public MojoDescriptor withProjectRequired(boolean projectRequired) {
        return MojoDescriptor.newBuilder(this, true).projectRequired(projectRequired).build();
    }

    @Nonnull
    public MojoDescriptor withOnlineRequired(boolean onlineRequired) {
        return MojoDescriptor.newBuilder(this, true).onlineRequired(onlineRequired).build();
    }

    @Nonnull
    public MojoDescriptor withAggregator(boolean aggregator) {
        return MojoDescriptor.newBuilder(this, true).aggregator(aggregator).build();
    }

    @Nonnull
    public MojoDescriptor withInheritedByDefault(boolean inheritedByDefault) {
        return MojoDescriptor.newBuilder(this, true).inheritedByDefault(inheritedByDefault).build();
    }

    @Nonnull
    public MojoDescriptor withSince(String since) {
        return MojoDescriptor.newBuilder(this, true).since(since).build();
    }

    @Nonnull
    public MojoDescriptor withDeprecated(String deprecated) {
        return MojoDescriptor.newBuilder(this, true).deprecated(deprecated).build();
    }

    @Nonnull
    public MojoDescriptor withConfigurator(String configurator) {
        return MojoDescriptor.newBuilder(this, true).configurator(configurator).build();
    }

    @Nonnull
    public MojoDescriptor withParameters(Collection<Parameter> parameters) {
        return MojoDescriptor.newBuilder(this, true).parameters(parameters).build();
    }

    @Nonnull
    public MojoDescriptor withResolutions(Collection<Resolution> resolutions) {
        return MojoDescriptor.newBuilder(this, true).resolutions(resolutions).build();
    }

    @Nonnull
    public MojoDescriptor withId(String id) {
        return MojoDescriptor.newBuilder(this, true).id(id).build();
    }

    @Nonnull
    public MojoDescriptor withFullGoalName(String fullGoalName) {
        return MojoDescriptor.newBuilder(this, true).fullGoalName(fullGoalName).build();
    }

    @Nonnull
    public static MojoDescriptor newInstance() {
        return MojoDescriptor.newInstance(true);
    }

    @Nonnull
    public static MojoDescriptor newInstance(boolean withDefaults) {
        return MojoDescriptor.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return MojoDescriptor.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(MojoDescriptor from) {
        return MojoDescriptor.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(MojoDescriptor from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder {
        MojoDescriptor base;
        String goal;
        String description;
        String implementation;
        String language;
        String phase;
        String executePhase;
        String executeGoal;
        String executeLifecycle;
        String dependencyResolution;
        String dependencyCollection;
        Boolean directInvocationOnly;
        Boolean projectRequired;
        Boolean onlineRequired;
        Boolean aggregator;
        Boolean inheritedByDefault;
        String since;
        String deprecated;
        String configurator;
        Collection<Parameter> parameters;
        Collection<Resolution> resolutions;
        String id;
        String fullGoalName;

        Builder(boolean withDefaults) {
            if (withDefaults) {
                this.language = "java";
                this.dependencyResolution = "runtime";
                this.directInvocationOnly = false;
                this.projectRequired = true;
                this.onlineRequired = false;
                this.aggregator = false;
                this.inheritedByDefault = true;
            }
        }

        Builder(MojoDescriptor base, boolean forceCopy) {
            if (forceCopy) {
                this.goal = base.goal;
                this.description = base.description;
                this.implementation = base.implementation;
                this.language = base.language;
                this.phase = base.phase;
                this.executePhase = base.executePhase;
                this.executeGoal = base.executeGoal;
                this.executeLifecycle = base.executeLifecycle;
                this.dependencyResolution = base.dependencyResolution;
                this.dependencyCollection = base.dependencyCollection;
                this.directInvocationOnly = base.directInvocationOnly;
                this.projectRequired = base.projectRequired;
                this.onlineRequired = base.onlineRequired;
                this.aggregator = base.aggregator;
                this.inheritedByDefault = base.inheritedByDefault;
                this.since = base.since;
                this.deprecated = base.deprecated;
                this.configurator = base.configurator;
                this.parameters = base.parameters;
                this.resolutions = base.resolutions;
                this.id = base.id;
                this.fullGoalName = base.fullGoalName;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder goal(String goal) {
            this.goal = goal;
            return this;
        }

        @Nonnull
        public Builder description(String description) {
            this.description = description;
            return this;
        }

        @Nonnull
        public Builder implementation(String implementation) {
            this.implementation = implementation;
            return this;
        }

        @Nonnull
        public Builder language(String language) {
            this.language = language;
            return this;
        }

        @Nonnull
        public Builder phase(String phase) {
            this.phase = phase;
            return this;
        }

        @Nonnull
        public Builder executePhase(String executePhase) {
            this.executePhase = executePhase;
            return this;
        }

        @Nonnull
        public Builder executeGoal(String executeGoal) {
            this.executeGoal = executeGoal;
            return this;
        }

        @Nonnull
        public Builder executeLifecycle(String executeLifecycle) {
            this.executeLifecycle = executeLifecycle;
            return this;
        }

        @Nonnull
        public Builder dependencyResolution(String dependencyResolution) {
            this.dependencyResolution = dependencyResolution;
            return this;
        }

        @Nonnull
        public Builder dependencyCollection(String dependencyCollection) {
            this.dependencyCollection = dependencyCollection;
            return this;
        }

        @Nonnull
        public Builder directInvocationOnly(boolean directInvocationOnly) {
            this.directInvocationOnly = directInvocationOnly;
            return this;
        }

        @Nonnull
        public Builder projectRequired(boolean projectRequired) {
            this.projectRequired = projectRequired;
            return this;
        }

        @Nonnull
        public Builder onlineRequired(boolean onlineRequired) {
            this.onlineRequired = onlineRequired;
            return this;
        }

        @Nonnull
        public Builder aggregator(boolean aggregator) {
            this.aggregator = aggregator;
            return this;
        }

        @Nonnull
        public Builder inheritedByDefault(boolean inheritedByDefault) {
            this.inheritedByDefault = inheritedByDefault;
            return this;
        }

        @Nonnull
        public Builder since(String since) {
            this.since = since;
            return this;
        }

        @Nonnull
        public Builder deprecated(String deprecated) {
            this.deprecated = deprecated;
            return this;
        }

        @Nonnull
        public Builder configurator(String configurator) {
            this.configurator = configurator;
            return this;
        }

        @Nonnull
        public Builder parameters(Collection<Parameter> parameters) {
            this.parameters = parameters;
            return this;
        }

        @Nonnull
        public Builder resolutions(Collection<Resolution> resolutions) {
            this.resolutions = resolutions;
            return this;
        }

        @Nonnull
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @Nonnull
        public Builder fullGoalName(String fullGoalName) {
            this.fullGoalName = fullGoalName;
            return this;
        }

        @Nonnull
        public MojoDescriptor build() {
            if (!(this.base == null || this.goal != null && this.goal != this.base.goal || this.description != null && this.description != this.base.description || this.implementation != null && this.implementation != this.base.implementation || this.language != null && this.language != this.base.language || this.phase != null && this.phase != this.base.phase || this.executePhase != null && this.executePhase != this.base.executePhase || this.executeGoal != null && this.executeGoal != this.base.executeGoal || this.executeLifecycle != null && this.executeLifecycle != this.base.executeLifecycle || this.dependencyResolution != null && this.dependencyResolution != this.base.dependencyResolution || this.dependencyCollection != null && this.dependencyCollection != this.base.dependencyCollection || this.directInvocationOnly != null && this.directInvocationOnly != this.base.directInvocationOnly || this.projectRequired != null && this.projectRequired != this.base.projectRequired || this.onlineRequired != null && this.onlineRequired != this.base.onlineRequired || this.aggregator != null && this.aggregator != this.base.aggregator || this.inheritedByDefault != null && this.inheritedByDefault != this.base.inheritedByDefault || this.since != null && this.since != this.base.since || this.deprecated != null && this.deprecated != this.base.deprecated || this.configurator != null && this.configurator != this.base.configurator || this.parameters != null && this.parameters != this.base.parameters || this.resolutions != null && this.resolutions != this.base.resolutions || this.id != null && this.id != this.base.id || this.fullGoalName != null && this.fullGoalName != this.base.fullGoalName)) {
                return this.base;
            }
            return new MojoDescriptor(this.goal != null ? this.goal : (this.base != null ? this.base.goal : null), this.description != null ? this.description : (this.base != null ? this.base.description : null), this.implementation != null ? this.implementation : (this.base != null ? this.base.implementation : null), this.language != null ? this.language : (this.base != null ? this.base.language : null), this.phase != null ? this.phase : (this.base != null ? this.base.phase : null), this.executePhase != null ? this.executePhase : (this.base != null ? this.base.executePhase : null), this.executeGoal != null ? this.executeGoal : (this.base != null ? this.base.executeGoal : null), this.executeLifecycle != null ? this.executeLifecycle : (this.base != null ? this.base.executeLifecycle : null), this.dependencyResolution != null ? this.dependencyResolution : (this.base != null ? this.base.dependencyResolution : null), this.dependencyCollection != null ? this.dependencyCollection : (this.base != null ? this.base.dependencyCollection : null), this.directInvocationOnly != null ? this.directInvocationOnly : (this.base != null ? this.base.directInvocationOnly : false), this.projectRequired != null ? this.projectRequired : (this.base != null ? this.base.projectRequired : true), this.onlineRequired != null ? this.onlineRequired : (this.base != null ? this.base.onlineRequired : false), this.aggregator != null ? this.aggregator : (this.base != null ? this.base.aggregator : false), this.inheritedByDefault != null ? this.inheritedByDefault : (this.base != null ? this.base.inheritedByDefault : true), this.since != null ? this.since : (this.base != null ? this.base.since : null), this.deprecated != null ? this.deprecated : (this.base != null ? this.base.deprecated : null), this.configurator != null ? this.configurator : (this.base != null ? this.base.configurator : null), this.parameters != null ? this.parameters : (this.base != null ? this.base.parameters : null), this.resolutions != null ? this.resolutions : (this.base != null ? this.base.resolutions : null), this.id != null ? this.id : (this.base != null ? this.base.id : null), this.fullGoalName != null ? this.fullGoalName : (this.base != null ? this.base.fullGoalName : null));
        }
    }
}

