/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiver;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import org.apache.maven.api.Project;
import org.apache.maven.api.Session;
import org.codehaus.plexus.archiver.Archiver;

public class PomPropertiesUtil {
    private Properties loadPropertiesFile(Path file) throws IOException {
        Properties fileProps = new Properties();
        try (InputStream istream = Files.newInputStream(file, new OpenOption[0]);){
            fileProps.load(istream);
            Properties properties = fileProps;
            return properties;
        }
    }

    private boolean sameContents(Properties props, Path file) throws IOException {
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            return false;
        }
        Properties fileProps = this.loadPropertiesFile(file);
        return fileProps.equals(props);
    }

    private void createPropertiesFile(Properties properties, Path outputFile, boolean forceCreation) throws IOException {
        Path outputDir = outputFile.getParent();
        if (outputDir != null && !Files.isDirectory(outputDir, new LinkOption[0])) {
            Files.createDirectories(outputDir, new FileAttribute[0]);
        }
        if (!forceCreation && this.sameContents(properties, outputFile)) {
            return;
        }
        try (PrintWriter pw = new PrintWriter(outputFile.toFile(), StandardCharsets.ISO_8859_1.name());
             StringWriter sw = new StringWriter();){
            properties.store(sw, null);
            ArrayList<String> lines = new ArrayList<String>();
            try (BufferedReader r = new BufferedReader(new StringReader(sw.toString()));){
                String line;
                while ((line = r.readLine()) != null) {
                    if (line.startsWith("#")) continue;
                    lines.add(line);
                }
            }
            Collections.sort(lines);
            for (String l : lines) {
                pw.println(l);
            }
        }
    }

    public void createPomProperties(Session session, Project project, Archiver archiver, Path customPomPropertiesFile, Path pomPropertiesFile, boolean forceCreation) throws IOException {
        String groupId = project.getGroupId();
        String artifactId = project.getArtifactId();
        String version = project.getVersion();
        this.createPomProperties(session, groupId, artifactId, version, archiver, customPomPropertiesFile, pomPropertiesFile, forceCreation);
    }

    public void createPomProperties(Session session, String groupId, String artifactId, String version, Archiver archiver, Path customPomPropertiesFile, Path pomPropertiesFile, boolean forceCreation) throws IOException {
        Properties p = customPomPropertiesFile != null ? this.loadPropertiesFile(customPomPropertiesFile) : new Properties();
        p.setProperty("groupId", groupId);
        p.setProperty("artifactId", artifactId);
        p.setProperty("version", version);
        this.createPropertiesFile(p, pomPropertiesFile, forceCreation);
        archiver.addFile(pomPropertiesFile.toFile(), "META-INF/maven/" + groupId + "/" + artifactId + "/pom.properties");
    }
}

