/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.factory;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;

public class DefaultArtifactFactory
implements ArtifactFactory {
    private ArtifactHandlerManager artifactHandlerManager;

    public DefaultArtifactFactory() {
    }

    public DefaultArtifactFactory(ArtifactHandlerManager artifactHandlerManager) {
        this.artifactHandlerManager = artifactHandlerManager;
    }

    public Artifact createArtifact(String groupId, String artifactId, String version, String scope, String type) {
        return this.createArtifact(groupId, artifactId, version, scope, type, null, null);
    }

    public Artifact createArtifactWithClassifier(String groupId, String artifactId, String version, String scope, String type, String classifier) {
        return this.createArtifact(groupId, artifactId, version, scope, type, classifier, null);
    }

    public Artifact createArtifact(String groupId, String artifactId, String version, String scope, String type, String inheritedScope) {
        return this.createArtifact(groupId, artifactId, version, scope, type, null, inheritedScope);
    }

    private Artifact createArtifact(String groupId, String artifactId, String version, String scope, String type, String classifier, String inheritedScope) {
        String desiredScope = "runtime";
        if (inheritedScope == null) {
            desiredScope = scope;
        } else {
            if ("test".equals(scope) || "provided".equals(scope)) {
                return null;
            }
            if ("compile".equals(scope) && "compile".equals(inheritedScope)) {
                desiredScope = "compile";
            }
        }
        if ("test".equals(inheritedScope)) {
            desiredScope = "test";
        }
        if ("provided".equals(inheritedScope)) {
            desiredScope = "provided";
        }
        ArtifactHandler handler = this.artifactHandlerManager.getArtifactHandler(type);
        DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, version, desiredScope, type, classifier, handler);
        return artifact;
    }
}

