/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.di.impl;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.maven.api.annotations.Nullable;

public class Types {
    public static final Type[] NO_TYPES = new Type[0];
    public static final WildcardType WILDCARD_TYPE_ANY = new WildcardTypeImpl(new Type[]{Object.class}, new Type[0]);
    private static final Map<Type, Map<TypeVariable<?>, Type>> TYPE_BINDINGS_CACHE = new ConcurrentHashMap();

    public static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof WildcardType) {
            Type[] upperBounds = ((WildcardType)type).getUpperBounds();
            return Types.getRawType(Types.getUppermostType(upperBounds));
        }
        if (type instanceof GenericArrayType) {
            Class<?> rawComponentType = Types.getRawType(((GenericArrayType)type).getGenericComponentType());
            try {
                return Class.forName("[L" + rawComponentType.getName() + ";");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        if (type instanceof TypeVariable) {
            return Types.getRawType(Types.getUppermostType(((TypeVariable)type).getBounds()));
        }
        throw new IllegalArgumentException("Unsupported type: " + type);
    }

    public static Type getUppermostType(Type[] types) {
        Type result = types[0];
        for (int i = 1; i < types.length; ++i) {
            Type type = types[i];
            if (Types.isAssignable(type, result)) {
                result = type;
                continue;
            }
            if (Types.isAssignable(result, type)) continue;
            throw new IllegalArgumentException("Unrelated types: " + result + " , " + type);
        }
        return result;
    }

    public static Type[] getActualTypeArguments(Type type) {
        if (type instanceof Class) {
            Type[] typeArray;
            if (((Class)type).isArray()) {
                Type[] typeArray2 = new Type[1];
                typeArray = typeArray2;
                typeArray2[0] = ((Class)type).getComponentType();
            } else {
                typeArray = NO_TYPES;
            }
            return typeArray;
        }
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments();
        }
        if (type instanceof GenericArrayType) {
            return new Type[]{((GenericArrayType)type).getGenericComponentType()};
        }
        throw new IllegalArgumentException("Unsupported type: " + type);
    }

    public static Map<TypeVariable<?>, Type> getTypeBindings(Type type) {
        Type[] typeArguments = Types.getActualTypeArguments(type);
        if (typeArguments.length == 0) {
            return Collections.emptyMap();
        }
        TypeVariable<Class<?>>[] typeVariables = Types.getRawType(type).getTypeParameters();
        HashMap map = new HashMap();
        for (int i = 0; i < typeVariables.length; ++i) {
            map.put(typeVariables[i], typeArguments[i]);
        }
        return map;
    }

    public static Map<TypeVariable<?>, Type> getAllTypeBindings(Type type) {
        return TYPE_BINDINGS_CACHE.computeIfAbsent(type, t -> {
            HashMap mapping = new HashMap();
            Types.getAllTypeBindingsImpl(t, mapping);
            return mapping;
        });
    }

    private static void getAllTypeBindingsImpl(Type type, Map<TypeVariable<?>, Type> mapping) {
        Type superclass;
        Type[] typeArguments;
        Class<?> cls = Types.getRawType(type);
        if (type instanceof ParameterizedType && (typeArguments = ((ParameterizedType)type).getActualTypeArguments()).length != 0) {
            TypeVariable<Class<?>>[] typeVariables = cls.getTypeParameters();
            for (int i = 0; i < typeArguments.length; ++i) {
                Type typeArgument = typeArguments[i];
                mapping.put(typeVariables[i], typeArgument instanceof TypeVariable ? Objects.requireNonNull(mapping.get(typeArgument)) : typeArgument);
            }
        }
        if ((superclass = cls.getGenericSuperclass()) != null) {
            Types.getAllTypeBindingsImpl(superclass, mapping);
        }
        for (Type anInterface : cls.getGenericInterfaces()) {
            Types.getAllTypeBindingsImpl(anInterface, mapping);
        }
    }

    public static Type bind(Type type, Map<TypeVariable<?>, Type> bindings) {
        return Types.bind(type, bindings::get);
    }

    public static Type bind(Type type, Function<TypeVariable<?>, Type> bindings) {
        if (type instanceof Class) {
            return type;
        }
        if (type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type;
            Type actualType = bindings.apply(typeVariable);
            if (actualType == null) {
                throw new TypeNotBoundException("Type variable not found: " + typeVariable + " ( " + typeVariable.getGenericDeclaration() + " ) ");
            }
            return actualType;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            Type[] typeArguments2 = new Type[typeArguments.length];
            for (int i = 0; i < typeArguments.length; ++i) {
                typeArguments2[i] = Types.bind(typeArguments[i], bindings);
            }
            return new ParameterizedTypeImpl(parameterizedType.getOwnerType(), parameterizedType.getRawType(), typeArguments2);
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            return new GenericArrayTypeImpl(Types.bind(componentType, bindings));
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            Type[] upperBounds = wildcardType.getUpperBounds();
            Type[] upperBounds2 = new Type[upperBounds.length];
            for (int i = 0; i < upperBounds.length; ++i) {
                upperBounds2[i] = Types.bind(upperBounds[i], bindings);
            }
            Type[] lowerBounds = wildcardType.getLowerBounds();
            Type[] lowerBounds2 = new Type[lowerBounds.length];
            for (int i = 0; i < lowerBounds.length; ++i) {
                lowerBounds2[i] = Types.bind(lowerBounds[i], bindings);
            }
            return new WildcardTypeImpl(upperBounds2, lowerBounds2);
        }
        throw new IllegalArgumentException("Unsupported type: " + type);
    }

    public static ParameterizedType parameterizedType(@Nullable Type ownerType, Type rawType, Type[] parameters) {
        return new ParameterizedTypeImpl(ownerType, rawType, parameters);
    }

    public static ParameterizedType parameterizedType(Class<?> rawType, Type ... parameters) {
        return new ParameterizedTypeImpl(null, rawType, parameters);
    }

    public static Set<Type> getAllSuperTypes(Type original) {
        ArrayDeque<Type> todo = new ArrayDeque<Type>();
        todo.add(original);
        HashSet<Type> done = new HashSet<Type>();
        while (!todo.isEmpty()) {
            Function<TypeVariable<?>, Type> bindings;
            Type type = (Type)todo.remove();
            if (!done.add(type)) continue;
            Class<?> cls = Types.getRawType(type);
            if (type instanceof ParameterizedType) {
                Type[] typeArguments = ((ParameterizedType)type).getActualTypeArguments();
                Type[] typeVariables = cls.getTypeParameters();
                bindings = arg_0 -> Types.lambda$getAllSuperTypes$1(typeArguments, (TypeVariable[])typeVariables, arg_0);
            } else {
                bindings = v -> null;
            }
            Type[] interfaces = cls.getGenericInterfaces();
            for (Type itf : interfaces) {
                try {
                    todo.add(Types.bind(itf, bindings));
                }
                catch (TypeNotBoundException typeNotBoundException) {
                    // empty catch block
                }
            }
            Type supercls = cls.getGenericSuperclass();
            if (supercls == null) continue;
            try {
                todo.add(Types.bind(supercls, bindings));
            }
            catch (TypeNotBoundException typeNotBoundException) {}
        }
        return done;
    }

    public static Type simplifyType(Type original) {
        if (original instanceof Class) {
            return original;
        }
        if (original instanceof GenericArrayType) {
            Type repackedComponentType;
            Type componentType = ((GenericArrayType)original).getGenericComponentType();
            if (componentType != (repackedComponentType = Types.simplifyType(componentType))) {
                return Types.genericArrayType(repackedComponentType);
            }
            return original;
        }
        if (original instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)original;
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            Type[] repackedTypeArguments = Types.simplifyTypes(typeArguments);
            if (Types.isAllObjects(repackedTypeArguments)) {
                return parameterizedType.getRawType();
            }
            if (typeArguments != repackedTypeArguments) {
                return Types.parameterizedType(parameterizedType.getOwnerType(), parameterizedType.getRawType(), repackedTypeArguments);
            }
            return original;
        }
        if (original instanceof TypeVariable) {
            throw new IllegalArgumentException("Key should not contain a type variable: " + original);
        }
        if (original instanceof WildcardType) {
            Type[] lowerBounds;
            WildcardType wildcardType = (WildcardType)original;
            Type[] upperBounds = wildcardType.getUpperBounds();
            if (upperBounds.length == 1) {
                Type upperBound = upperBounds[0];
                if (upperBound != Object.class) {
                    return Types.simplifyType(upperBound);
                }
            } else if (upperBounds.length > 1) {
                throw new IllegalArgumentException("Multiple upper bounds not supported: " + original);
            }
            if ((lowerBounds = wildcardType.getLowerBounds()).length == 1) {
                return Types.simplifyType(lowerBounds[0]);
            }
            if (lowerBounds.length > 1) {
                throw new IllegalArgumentException("Multiple lower bounds not supported: " + original);
            }
            return Object.class;
        }
        return original;
    }

    private static Type[] simplifyTypes(Type[] original) {
        int length = original.length;
        for (int i = 0; i < length; ++i) {
            Type typeArgument = original[i];
            Type repackTypeArgument = Types.simplifyType(typeArgument);
            if (repackTypeArgument == typeArgument) continue;
            Type[] repackedTypeArguments = new Type[length];
            System.arraycopy(original, 0, repackedTypeArguments, 0, i);
            repackedTypeArguments[i++] = repackTypeArgument;
            while (i < length) {
                repackedTypeArguments[i] = Types.simplifyType(original[i]);
                ++i;
            }
            return repackedTypeArguments;
        }
        return original;
    }

    private static boolean isAllObjects(Type[] types) {
        for (Type type : types) {
            if (type == Object.class) continue;
            return false;
        }
        return true;
    }

    public static boolean isAssignable(Type to, Type from) {
        if (to instanceof Class && from instanceof Class) {
            return ((Class)to).isAssignableFrom((Class)from);
        }
        return Types.isAssignable(to, from, false);
    }

    private static boolean isAssignable(Type to, Type from, boolean strict) {
        if (to instanceof WildcardType || from instanceof WildcardType) {
            Type[] fromLowers;
            Type[] fromUppers;
            Type[] toLowers;
            Type[] toUppers;
            if (to instanceof WildcardType) {
                WildcardType wildcardTo = (WildcardType)((Object)to);
                toUppers = wildcardTo.getUpperBounds();
                toLowers = wildcardTo.getLowerBounds();
            } else {
                toUppers = new Type[]{to};
                Type[] typeArray = toLowers = strict ? toUppers : NO_TYPES;
            }
            if (from instanceof WildcardType) {
                WildcardType wildcardTo = (WildcardType)((Object)to);
                fromUppers = wildcardTo.getUpperBounds();
                fromLowers = wildcardTo.getLowerBounds();
            } else {
                fromUppers = new Type[]{from};
                fromLowers = strict ? fromUppers : NO_TYPES;
            }
            for (Type toUpper : toUppers) {
                for (Type fromUpper : fromUppers) {
                    if (Types.isAssignable(toUpper, fromUpper, false)) continue;
                    return false;
                }
            }
            if (toLowers.length == 0) {
                return true;
            }
            if (fromLowers.length == 0) {
                return false;
            }
            for (Type toLower : toLowers) {
                for (Type fromLower : fromLowers) {
                    if (Types.isAssignable(fromLower, toLower, false)) continue;
                    return false;
                }
            }
            return true;
        }
        if (to instanceof GenericArrayType) {
            to = Types.getRawType(to);
        }
        if (from instanceof GenericArrayType) {
            from = Types.getRawType(from);
        }
        if (!strict && to instanceof Class) {
            return to.isAssignableFrom(Types.getRawType(from));
        }
        Class<?> toRawClazz = Types.getRawType(to);
        Type[] toTypeArguments = Types.getActualTypeArguments(to);
        return Types.isAssignable(toRawClazz, toTypeArguments, from, strict);
    }

    private static boolean isAssignable(Class<?> toRawClazz, Type[] toTypeArguments, Type from, boolean strict) {
        Class<?> fromRawClazz = Types.getRawType(from);
        if (strict && !toRawClazz.equals(fromRawClazz)) {
            return false;
        }
        if (!strict && !toRawClazz.isAssignableFrom(fromRawClazz)) {
            return false;
        }
        if (toRawClazz.isArray()) {
            return true;
        }
        Type[] fromTypeArguments = Types.getActualTypeArguments(from);
        if (toRawClazz == fromRawClazz) {
            if (toTypeArguments.length > fromTypeArguments.length) {
                return false;
            }
            for (int i = 0; i < toTypeArguments.length; ++i) {
                if (Types.isAssignable(toTypeArguments[i], fromTypeArguments[i], true)) continue;
                return false;
            }
            return true;
        }
        Map<TypeVariable<?>, Type> typeBindings = Types.getTypeBindings(from);
        for (Type anInterface : fromRawClazz.getGenericInterfaces()) {
            if (!Types.isAssignable(toRawClazz, toTypeArguments, Types.bind(anInterface, (TypeVariable<?> key) -> typeBindings.getOrDefault(key, Types.wildcardTypeAny())), false)) continue;
            return true;
        }
        Type superclass = fromRawClazz.getGenericSuperclass();
        return superclass != null && Types.isAssignable(toRawClazz, toTypeArguments, Types.bind(superclass, typeBindings), false);
    }

    public static WildcardType wildcardType(Type[] upperBounds, Type[] lowerBounds) {
        return new WildcardTypeImpl(upperBounds, lowerBounds);
    }

    public static WildcardType wildcardTypeAny() {
        return WILDCARD_TYPE_ANY;
    }

    public static WildcardType wildcardTypeExtends(Type upperBound) {
        return new WildcardTypeImpl(new Type[]{upperBound}, NO_TYPES);
    }

    public static WildcardType wildcardTypeSuper(Type lowerBound) {
        return new WildcardTypeImpl(NO_TYPES, new Type[]{lowerBound});
    }

    public static GenericArrayType genericArrayType(Type componentType) {
        return new GenericArrayTypeImpl(componentType);
    }

    private static String toString(Type type) {
        return type instanceof Class ? ((Class)type).getName() : type.toString();
    }

    public static String getSimpleName(Type type) {
        if (type instanceof Class) {
            return ((Class)type).getSimpleName();
        }
        if (type instanceof ParameterizedType) {
            return Arrays.stream(((ParameterizedType)type).getActualTypeArguments()).map(Types::getSimpleName).collect(Collectors.joining(",", "<", ">"));
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            Type[] upperBounds = wildcardType.getUpperBounds();
            Type[] lowerBounds = wildcardType.getLowerBounds();
            return "?" + (String)(upperBounds.length == 0 ? "" : " extends " + Arrays.stream(upperBounds).map(Types::getSimpleName).collect(Collectors.joining(" & "))) + (String)(lowerBounds.length == 0 ? "" : " super " + Arrays.stream(lowerBounds).map(Types::getSimpleName).collect(Collectors.joining(" & ")));
        }
        if (type instanceof GenericArrayType) {
            return Types.getSimpleName(((GenericArrayType)type).getGenericComponentType()) + "[]";
        }
        return type.getTypeName();
    }

    private static /* synthetic */ Type lambda$getAllSuperTypes$1(Type[] typeArguments, TypeVariable[] typeVariables, TypeVariable v) {
        for (int i = 0; i < typeArguments.length; ++i) {
            Type typeArgument = typeArguments[i];
            if (!v.equals(typeVariables[i])) continue;
            return typeArgument;
        }
        return null;
    }

    public static class TypeNotBoundException
    extends IllegalArgumentException {
        public TypeNotBoundException(String s) {
            super(s);
        }
    }

    public static final class ParameterizedTypeImpl
    implements ParameterizedType {
        @Nullable
        private final Type ownerType;
        private final Type rawType;
        private final Type[] actualTypeArguments;

        ParameterizedTypeImpl(@Nullable Type ownerType, Type rawType, Type[] actualTypeArguments) {
            this.ownerType = ownerType;
            this.rawType = rawType;
            this.actualTypeArguments = actualTypeArguments;
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.actualTypeArguments;
        }

        @Override
        @Nullable
        public Type getOwnerType() {
            return this.ownerType;
        }

        public int hashCode() {
            return Objects.hashCode(this.ownerType) ^ Arrays.hashCode(this.actualTypeArguments) ^ this.rawType.hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof ParameterizedType)) {
                return false;
            }
            ParameterizedType that = (ParameterizedType)other;
            return this.getRawType().equals(that.getRawType()) && Objects.equals(this.getOwnerType(), that.getOwnerType()) && Arrays.equals(this.getActualTypeArguments(), that.getActualTypeArguments());
        }

        public String toString() {
            return this.rawType.getTypeName() + Arrays.stream(this.actualTypeArguments).map(Types::toString).collect(Collectors.joining(", ", "<", ">"));
        }
    }

    public static final class GenericArrayTypeImpl
    implements GenericArrayType {
        private final Type componentType;

        GenericArrayTypeImpl(Type componentType) {
            this.componentType = componentType;
        }

        @Override
        public Type getGenericComponentType() {
            return this.componentType;
        }

        public int hashCode() {
            return this.componentType.hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof GenericArrayType)) {
                return false;
            }
            GenericArrayType that = (GenericArrayType)other;
            return this.getGenericComponentType().equals(that.getGenericComponentType());
        }

        public String toString() {
            return Types.toString(this.componentType) + "[]";
        }
    }

    public static class WildcardTypeImpl
    implements WildcardType {
        private final Type[] upperBounds;
        private final Type[] lowerBounds;

        WildcardTypeImpl(Type[] upperBounds, Type[] lowerBounds) {
            this.upperBounds = upperBounds;
            this.lowerBounds = lowerBounds;
        }

        @Override
        public Type[] getUpperBounds() {
            return this.upperBounds;
        }

        @Override
        public Type[] getLowerBounds() {
            return this.lowerBounds;
        }

        public int hashCode() {
            return Arrays.hashCode(this.upperBounds) ^ Arrays.hashCode(this.lowerBounds);
        }

        public boolean equals(Object other) {
            if (!(other instanceof WildcardType)) {
                return false;
            }
            WildcardType that = (WildcardType)other;
            return Arrays.equals(this.getUpperBounds(), that.getUpperBounds()) && Arrays.equals(this.getLowerBounds(), that.getLowerBounds());
        }

        public String toString() {
            return "?" + (String)(this.upperBounds.length == 0 ? "" : " extends " + Arrays.stream(this.upperBounds).map(Types::toString).collect(Collectors.joining(" & "))) + (String)(this.lowerBounds.length == 0 ? "" : " super " + Arrays.stream(this.lowerBounds).map(Types::toString).collect(Collectors.joining(" & ")));
        }
    }
}

