/*
 * $Id$
 */

package org.apache.maven.model;

/**
 * null
 * 
 * @version $Revision$ $Date$
 */
public class Dependency implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field groupId
     */
    private String groupId;

    /**
     * Field artifactId
     */
    private String artifactId;

    /**
     * Field version
     */
    private String version;

    /**
     * Field type
     */
    private String type = "jar";

    /**
     * Field classifier
     */
    private String classifier;

    /**
     * Field scope
     */
    private String scope;

    /**
     * Field systemPath
     */
    private String systemPath;

    /**
     * Field exclusions
     */
    private java.util.List exclusions;

    /**
     * Field optional
     */
    private boolean optional = false;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addExclusion
     * 
     * @param exclusion
     */
    public void addExclusion(Exclusion exclusion)
    {
        getExclusions().add( exclusion );
    } //-- void addExclusion(Exclusion) 

    /**
     * Get 
     *             The unique id for an artifact produced by the
     * project group, e.g.
     *             <code>germonimo-jms</code>
     *           
     */
    public String getArtifactId()
    {
        return this.artifactId;
    } //-- String getArtifactId() 

    /**
     * Get 
     *             The classifier of the dependency. This allows
     * distinguishing two artifacts that belong to the same POM but
     *             were built differently, and is appended to the
     * filename after the version.
     *           
     */
    public String getClassifier()
    {
        return this.classifier;
    } //-- String getClassifier() 

    /**
     * Method getExclusions
     */
    public java.util.List getExclusions()
    {
        if ( this.exclusions == null )
        {
            this.exclusions = new java.util.ArrayList();
        }
        
        return this.exclusions;
    } //-- java.util.List getExclusions() 

    /**
     * Get 
     *             The project group that produced the dependency,
     * e.g.
     *             <code>geronimo</code>.
     *           
     */
    public String getGroupId()
    {
        return this.groupId;
    } //-- String getGroupId() 

    /**
     * Get 
     *             The scope of the dependency - compile, runtime,
     * test. Used to
     *             calculate the various classpaths used for
     * testing, etc. and for 
     *             determining which artifacts to include in a
     * distribution of this
     *             project. For more information, see 
     *             <a
     * href="http://maven.apache.org/maven2/dependency-mechanism.html">Dependency
     * Mechanism</a>.
     *           
     */
    public String getScope()
    {
        return this.scope;
    } //-- String getScope() 

    /**
     * Get FOR SYSTEM SCOPE ONLY. This specifies the path on the
     * filesystem for this
     *             dependency.
     */
    public String getSystemPath()
    {
        return this.systemPath;
    } //-- String getSystemPath() 

    /**
     * Get 
     *             The type of dependency. This defaults to
     * <code>jar</code>.
     *             Known recognised dependency types are:
     *             <ul>
     *             <li><code>jar</code></li>
     *             <li><code>ejb</code></li>
     *             <li><code>plugin</code></li>
     *             </ul>
     *           
     */
    public String getType()
    {
        return this.type;
    } //-- String getType() 

    /**
     * Get 
     *             The version of the dependency, e.g.
     * <code>3.2.1</code>
     *           
     */
    public String getVersion()
    {
        return this.version;
    } //-- String getVersion() 

    /**
     * Get 
     *             Indicates the dependency is optional for use of
     * this library. While the version of the dependency will be
     *             taken into account for dependency calculation if
     * the library is used elsewhere, it will not be passed on
     *             transitively.
     *           
     */
    public boolean isOptional()
    {
        return this.optional;
    } //-- boolean isOptional() 

    /**
     * Method removeExclusion
     * 
     * @param exclusion
     */
    public void removeExclusion(Exclusion exclusion)
    {
        getExclusions().remove( exclusion );
    } //-- void removeExclusion(Exclusion) 

    /**
     * Set 
     *             The unique id for an artifact produced by the
     * project group, e.g.
     *             <code>germonimo-jms</code>
     *           
     * 
     * @param artifactId
     */
    public void setArtifactId(String artifactId)
    {
        this.artifactId = artifactId;
    } //-- void setArtifactId(String) 

    /**
     * Set 
     *             The classifier of the dependency. This allows
     * distinguishing two artifacts that belong to the same POM but
     *             were built differently, and is appended to the
     * filename after the version.
     *           
     * 
     * @param classifier
     */
    public void setClassifier(String classifier)
    {
        this.classifier = classifier;
    } //-- void setClassifier(String) 

    /**
     * Set 
     *             Lists a set of artifacts that should be excluded
     * from this dependency's artifact list when it comes to
     *             calculating transitive dependencies.
     *           
     * 
     * @param exclusions
     */
    public void setExclusions(java.util.List exclusions)
    {
        this.exclusions = exclusions;
    } //-- void setExclusions(java.util.List) 

    /**
     * Set 
     *             The project group that produced the dependency,
     * e.g.
     *             <code>geronimo</code>.
     *           
     * 
     * @param groupId
     */
    public void setGroupId(String groupId)
    {
        this.groupId = groupId;
    } //-- void setGroupId(String) 

    /**
     * Set 
     *             Indicates the dependency is optional for use of
     * this library. While the version of the dependency will be
     *             taken into account for dependency calculation if
     * the library is used elsewhere, it will not be passed on
     *             transitively.
     *           
     * 
     * @param optional
     */
    public void setOptional(boolean optional)
    {
        this.optional = optional;
    } //-- void setOptional(boolean) 

    /**
     * Set 
     *             The scope of the dependency - compile, runtime,
     * test. Used to
     *             calculate the various classpaths used for
     * testing, etc. and for 
     *             determining which artifacts to include in a
     * distribution of this
     *             project. For more information, see 
     *             <a
     * href="http://maven.apache.org/maven2/dependency-mechanism.html">Dependency
     * Mechanism</a>.
     *           
     * 
     * @param scope
     */
    public void setScope(String scope)
    {
        this.scope = scope;
    } //-- void setScope(String) 

    /**
     * Set FOR SYSTEM SCOPE ONLY. This specifies the path on the
     * filesystem for this
     *             dependency.
     * 
     * @param systemPath
     */
    public void setSystemPath(String systemPath)
    {
        this.systemPath = systemPath;
    } //-- void setSystemPath(String) 

    /**
     * Set 
     *             The type of dependency. This defaults to
     * <code>jar</code>.
     *             Known recognised dependency types are:
     *             <ul>
     *             <li><code>jar</code></li>
     *             <li><code>ejb</code></li>
     *             <li><code>plugin</code></li>
     *             </ul>
     *           
     * 
     * @param type
     */
    public void setType(String type)
    {
        this.type = type;
    } //-- void setType(String) 

    /**
     * Set 
     *             The version of the dependency, e.g.
     * <code>3.2.1</code>
     *           
     * 
     * @param version
     */
    public void setVersion(String version)
    {
        this.version = version;
    } //-- void setVersion(String) 


            public String toString()
            {
                return "Dependency {groupId=" + groupId + ", artifactId=" + artifactId + ", version=" + version + ", type=" + type + "}";
            }
          
            public String getManagementKey()
            {
                return groupId + ":" + artifactId + ":" + type + (classifier != null ? ":" + classifier : "");
            }
          
    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }}
